/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.ruleset.api;

import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.ruleset.api.IRuleSetApi;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/v2/ruleset/api/RuleSetApi;", "Lcom/usercentrics/sdk/v2/ruleset/api/IRuleSetApi;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "restClient", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/domain/api/http/HttpRequests;)V", "buildUrl", "", "id", "getRuleSet", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "headers", "", "usercentrics_release"})
public final class RuleSetApi
implements IRuleSetApi {
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final HttpRequests restClient;

    public RuleSetApi(@NotNull UsercentricsLogger logger2, @NotNull NetworkResolver networkResolver2, @NotNull HttpRequests restClient) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this.logger = logger2;
        this.networkResolver = networkResolver2;
        this.restClient = restClient;
    }

    @Override
    @NotNull
    public HttpResponse getRuleSet(@NotNull String id, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        try {
            HttpResponse httpResponse;
            String baseUrl = this.buildUrl(id);
            HttpResponse it = httpResponse = this.restClient.getSync(baseUrl, headers);
            boolean bl = false;
            if (it.getStatusCode() == 403) {
                throw new UsercentricsException("Unable to find the Rule Set, please make sure your ruleSetID is correct.", null, 2, null);
            }
            return httpResponse;
        }
        catch (Throwable cause) {
            this.logger.error("Failed while fetching ruleSet using id: " + id, cause);
            if (cause instanceof UsercentricsException) {
                throw cause;
            }
            throw (Throwable)new UsercentricsException("Something went wrong while fetching the Rule Set.", cause);
        }
    }

    private final String buildUrl(String id) {
        return this.networkResolver.cdnBaseUrl() + "/ruleSet/" + id + ".json";
    }
}

