/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.ruleset.service;

import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.v2.location.data.LocationData;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import com.usercentrics.sdk.v2.location.repository.ILocationRepository;
import com.usercentrics.sdk.v2.ruleset.data.GeoRule;
import com.usercentrics.sdk.v2.ruleset.data.RuleSet;
import com.usercentrics.sdk.v2.ruleset.data.SessionGeoRule;
import com.usercentrics.sdk.v2.ruleset.repository.IRuleSetRepository;
import com.usercentrics.sdk.v2.ruleset.service.IRuleSetService;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lcom/usercentrics/sdk/v2/ruleset/service/RuleSetService;", "Lcom/usercentrics/sdk/v2/ruleset/service/IRuleSetService;", "ruleSetRepository", "Lcom/usercentrics/sdk/v2/ruleset/repository/IRuleSetRepository;", "locationRepository", "Lcom/usercentrics/sdk/v2/location/repository/ILocationRepository;", "(Lcom/usercentrics/sdk/v2/ruleset/repository/IRuleSetRepository;Lcom/usercentrics/sdk/v2/location/repository/ILocationRepository;)V", "findRuleForLocation", "Lcom/usercentrics/sdk/v2/ruleset/data/GeoRule;", "ruleSet", "Lcom/usercentrics/sdk/v2/ruleset/data/RuleSet;", "location", "Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "getActualSettingsId", "Lcom/usercentrics/sdk/v2/ruleset/data/SessionGeoRule;", "id", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nRuleSetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuleSetService.kt\ncom/usercentrics/sdk/v2/ruleset/service/RuleSetService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class RuleSetService
implements IRuleSetService {
    @NotNull
    private final IRuleSetRepository ruleSetRepository;
    @NotNull
    private final ILocationRepository locationRepository;

    public RuleSetService(@NotNull IRuleSetRepository ruleSetRepository, @NotNull ILocationRepository locationRepository2) {
        Intrinsics.checkNotNullParameter((Object)ruleSetRepository, (String)"ruleSetRepository");
        Intrinsics.checkNotNullParameter((Object)locationRepository2, (String)"locationRepository");
        this.ruleSetRepository = ruleSetRepository;
        this.locationRepository = locationRepository2;
    }

    @Override
    @Nullable
    public Object getActualSettingsId(@NotNull String id, @NotNull Continuation<? super SessionGeoRule> $completion) {
        Pair<RuleSet, UsercentricsLocation> fetchedRuleSet = this.ruleSetRepository.fetchRuleSet(id);
        UsercentricsLocation location = (UsercentricsLocation)fetchedRuleSet.getSecond();
        if (location.isEmpty()) {
            UsercentricsLocation cachedLocation;
            LocationData locationData = this.locationRepository.getCachedLocation();
            UsercentricsLocation usercentricsLocation = cachedLocation = locationData != null ? locationData.getClientLocation() : null;
            if (cachedLocation == null || cachedLocation.isEmpty()) {
                throw new UsercentricsException("Unable to find user current location.", null, 2, null);
            }
            location = cachedLocation;
        }
        RuleSet ruleSet = (RuleSet)fetchedRuleSet.getFirst();
        GeoRule targetRule = this.findRuleForLocation(ruleSet, location);
        String settingsId = null;
        boolean noShow = false;
        if (targetRule == null) {
            noShow = ruleSet.getDefaultRule().getNoShow();
            settingsId = ruleSet.getDefaultRule().getSettingsId();
        } else {
            settingsId = targetRule.getSettingsId();
        }
        return new SessionGeoRule(settingsId, noShow, location);
    }

    private final GeoRule findRuleForLocation(RuleSet ruleSet, UsercentricsLocation location) {
        Object v0;
        GeoRule rule;
        Iterable iterable;
        List<GeoRule> rules;
        block3: {
            rules = ruleSet.getRules();
            iterable = rules;
            for (Object t : iterable) {
                rule = (GeoRule)t;
                boolean bl = false;
                if (!rule.getLocations().contains(location.getRegionCode())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        GeoRule targetRule = v0;
        if (targetRule == null) {
            Object v1;
            block4: {
                iterable = rules;
                for (Object t : iterable) {
                    rule = (GeoRule)t;
                    boolean bl = false;
                    if (!rule.getLocations().contains(location.getCountryCode())) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            targetRule = v1;
        }
        return targetRule;
    }
}

