/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.settings.api;

import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.settings.api.AggregatorApi;
import com.usercentrics.sdk.v2.settings.api.IAggregatorApi;
import com.usercentrics.sdk.v2.settings.data.BasicConsentTemplate;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/usercentrics/sdk/v2/settings/api/AggregatorApi;", "Lcom/usercentrics/sdk/v2/settings/api/IAggregatorApi;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "restClient", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/domain/api/http/HttpRequests;)V", "createAggregatorJsonUrl", "", "language", "services", "", "Lcom/usercentrics/sdk/v2/settings/data/BasicConsentTemplate;", "getServices", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "headers", "", "usercentrics_release"})
public final class AggregatorApi
implements IAggregatorApi {
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final HttpRequests restClient;

    public AggregatorApi(@NotNull UsercentricsLogger logger2, @NotNull NetworkResolver networkResolver2, @NotNull HttpRequests restClient) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this.logger = logger2;
        this.networkResolver = networkResolver2;
        this.restClient = restClient;
    }

    @Override
    @NotNull
    public HttpResponse getServices(@NotNull String language, @NotNull List<BasicConsentTemplate> services, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String url = this.createAggregatorJsonUrl(language, services);
        try {
            return this.restClient.getSync(url, headers);
        }
        catch (Exception ex) {
            this.logger.error("Failed while fetching services", ex);
            throw new UsercentricsException("Something went wrong while fetching the data processing services.", ex);
        }
    }

    private final String createAggregatorJsonUrl(String language, List<BasicConsentTemplate> services) {
        String templatesValue2 = CollectionsKt.joinToString$default((Iterable)services, (CharSequence)",", null, null, (int)0, null, (Function1)createAggregatorJsonUrl.templatesValue.1.INSTANCE, (int)30, null);
        String baseUrl = this.networkResolver.aggregatorBaseUrl();
        return baseUrl + "/aggregate/" + language + "?templates=" + templatesValue2;
    }
}

