/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.settings.service;

import com.usercentrics.sdk.v2.settings.data.BasicConsentTemplate;
import com.usercentrics.sdk.v2.settings.data.ConsentTemplate;
import com.usercentrics.sdk.v2.settings.data.NewSettingsData;
import com.usercentrics.sdk.v2.settings.data.ServiceConsentTemplate;
import com.usercentrics.sdk.v2.settings.data.SubConsentTemplate;
import com.usercentrics.sdk.v2.settings.data.UsercentricsCategory;
import com.usercentrics.sdk.v2.settings.data.UsercentricsService;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.settings.repository.IAggregatorRepository;
import com.usercentrics.sdk.v2.settings.repository.ISettingsRepository;
import com.usercentrics.sdk.v2.settings.service.ISettingsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J>\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u001dH\u0002J \u0010\t\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J \u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J$\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u0012H\u0002J\u0010\u0010%\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u001dH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0007\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/usercentrics/sdk/v2/settings/service/SettingsService;", "Lcom/usercentrics/sdk/v2/settings/service/ISettingsService;", "settingsRepository", "Lcom/usercentrics/sdk/v2/settings/repository/ISettingsRepository;", "aggregatorRepository", "Lcom/usercentrics/sdk/v2/settings/repository/IAggregatorRepository;", "(Lcom/usercentrics/sdk/v2/settings/repository/ISettingsRepository;Lcom/usercentrics/sdk/v2/settings/repository/IAggregatorRepository;)V", "settings", "Lcom/usercentrics/sdk/v2/settings/data/NewSettingsData;", "getSettings", "()Lcom/usercentrics/sdk/v2/settings/data/NewSettingsData;", "setSettings", "(Lcom/usercentrics/sdk/v2/settings/data/NewSettingsData;)V", "basicConsentTemplate", "Lcom/usercentrics/sdk/v2/settings/data/BasicConsentTemplate;", "service", "Lcom/usercentrics/sdk/v2/settings/data/ConsentTemplate;", "fillServiceWithTransientProperties", "", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsService;", "consentTemplates", "Lcom/usercentrics/sdk/v2/settings/data/ServiceConsentTemplate;", "services", "essentialCategoryAndHiddenFlagSlugs", "", "", "", "getServices", "jsonFileLanguage", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "settingsId", "jsonFileVersion", "loadSettings", "", "mapEssentialCategoryAndHiddenFlag", "categories", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsCategory;", "removeDeactivatedServices", "servicesAndSubServicesFromSettings", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsService.kt\ncom/usercentrics/sdk/v2/settings/service/SettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n766#2:101\n857#2,2:102\n1179#2,2:104\n1253#2,4:106\n1549#2:110\n1620#2,2:111\n1622#2:114\n819#2:115\n847#2,2:116\n1855#2:118\n1855#2,2:119\n1856#2:121\n1045#2:122\n1#3:113\n*S KotlinDebug\n*F\n+ 1 SettingsService.kt\ncom/usercentrics/sdk/v2/settings/service/SettingsService\n*L\n40#1:101\n40#1:102,2\n41#1:104,2\n41#1:106,4\n51#1:110\n51#1:111,2\n51#1:114\n80#1:115\n80#1:116,2\n89#1:118\n91#1:119,2\n89#1:121\n93#1:122\n*E\n"})
public final class SettingsService
implements ISettingsService {
    @NotNull
    private final ISettingsRepository settingsRepository;
    @NotNull
    private final IAggregatorRepository aggregatorRepository;
    @Nullable
    private NewSettingsData settings;

    public SettingsService(@NotNull ISettingsRepository settingsRepository, @NotNull IAggregatorRepository aggregatorRepository) {
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)aggregatorRepository, (String)"aggregatorRepository");
        this.settingsRepository = settingsRepository;
        this.aggregatorRepository = aggregatorRepository;
    }

    @Override
    @Nullable
    public NewSettingsData getSettings() {
        return this.settings;
    }

    public void setSettings(@Nullable NewSettingsData newSettingsData) {
        this.settings = newSettingsData;
    }

    @Override
    public void loadSettings(@NotNull String settingsId, @NotNull String jsonFileVersion, @NotNull String jsonFileLanguage) {
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        Intrinsics.checkNotNullParameter((Object)jsonFileVersion, (String)"jsonFileVersion");
        Intrinsics.checkNotNullParameter((Object)jsonFileLanguage, (String)"jsonFileLanguage");
        UsercentricsSettings settingsValue = this.getSettings(settingsId, jsonFileVersion, jsonFileLanguage);
        List<UsercentricsService> servicesValue = this.getServices(jsonFileLanguage, settingsValue);
        this.setSettings(new NewSettingsData(settingsValue, servicesValue));
    }

    private final UsercentricsSettings getSettings(String settingsId, String jsonFileVersion, String jsonFileLanguage) {
        UsercentricsSettings rawSettings = this.settingsRepository.fetchSettings(settingsId, jsonFileVersion, jsonFileLanguage);
        return this.removeDeactivatedServices(rawSettings);
    }

    private final List<UsercentricsService> getServices(String jsonFileLanguage, UsercentricsSettings settings) {
        List<BasicConsentTemplate> allServices = this.servicesAndSubServicesFromSettings(settings);
        if (allServices.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<UsercentricsService> services = this.aggregatorRepository.fetchServices(jsonFileLanguage, allServices);
        Map<String, Boolean> essentialCategoryAndHiddenFlagSlugs = this.mapEssentialCategoryAndHiddenFlag(settings.getCategories$usercentrics_release());
        return this.fillServiceWithTransientProperties(settings.getConsentTemplates$usercentrics_release(), services, essentialCategoryAndHiddenFlagSlugs);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Boolean> mapEssentialCategoryAndHiddenFlag(List<UsercentricsCategory> categories) {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        if (categories == null) {
            return MapsKt.emptyMap();
        }
        Iterable $this$filter$iv = categories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UsercentricsCategory it = (UsercentricsCategory)element$iv$iv;
            boolean bl = false;
            if (!it.isEssential()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List essential = (List)destination$iv$iv;
        Iterable $this$associate$iv = essential;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            UsercentricsCategory it = (UsercentricsCategory)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getCategorySlug(), (Object)it.isHidden());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UsercentricsService> fillServiceWithTransientProperties(List<ServiceConsentTemplate> consentTemplates, List<UsercentricsService> services, Map<String, Boolean> essentialCategoryAndHiddenFlagSlugs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = services;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UsercentricsService usercentricsService;
            Object v0;
            void service;
            Collection collection;
            block4: {
                UsercentricsService usercentricsService2 = (UsercentricsService)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = consentTemplates;
                for (Object t : iterable2) {
                    ServiceConsentTemplate it = (ServiceConsentTemplate)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)service.getTemplateId(), (Object)it.getTemplateId())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            ServiceConsentTemplate consentTemplate = v0;
            if (consentTemplate == null) {
                usercentricsService = service;
            } else {
                String categorySlug = consentTemplate.getCategorySlug();
                Boolean isHiddenFlagInCategoryFieldFromSettings = essentialCategoryAndHiddenFlagSlugs.get(categorySlug);
                boolean isPresentInCategorySlugsMap = isHiddenFlagInCategoryFieldFromSettings != null;
                boolean isHidden = Intrinsics.areEqual((Object)isHiddenFlagInCategoryFieldFromSettings, (Object)true) || consentTemplate.isHidden();
                List<String> list = consentTemplate.getLegalBasisList();
                List<String> list2 = (list != null ? !list.isEmpty() : false) ? consentTemplate.getLegalBasisList() : service.getLegalBasisList();
                Boolean bl = consentTemplate.isDeactivated();
                Boolean bl3 = consentTemplate.isAutoUpdateAllowed();
                Boolean bl4 = consentTemplate.getDisableLegalBasis();
                usercentricsService = UsercentricsService.copy$default((UsercentricsService)service, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, list2, null, null, null, null, null, null, null, null, null, null, categorySlug, null, null, null, null, null, null, null, null, null, null, null, null, null, null, isHidden, null, bl, bl3, bl4, isPresentInCategorySlugsMap, -67141633, 1535, null);
            }
            collection.add(usercentricsService);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final UsercentricsSettings removeDeactivatedServices(UsercentricsSettings settings) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = settings.getConsentTemplates$usercentrics_release();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ServiceConsentTemplate it = (ServiceConsentTemplate)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.isDeactivated(), (Object)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activeServices = (List)destination$iv$iv;
        return UsercentricsSettings.copy$default(settings, null, null, null, null, null, null, null, null, null, null, false, false, false, false, null, null, null, null, null, null, null, null, null, false, false, false, false, null, null, null, null, activeServices, null, Integer.MAX_VALUE, 1, null);
    }

    private final List<BasicConsentTemplate> servicesAndSubServicesFromSettings(UsercentricsSettings settings) {
        List result = new ArrayList();
        Iterable $this$forEach$iv = settings.getConsentTemplates$usercentrics_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServiceConsentTemplate service = (ServiceConsentTemplate)element$iv;
            boolean bl = false;
            result.add(this.basicConsentTemplate(service));
            Iterable $this$forEach$iv2 = service.getSubConsents();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SubConsentTemplate it = (SubConsentTemplate)element$iv2;
                boolean bl2 = false;
                result.add(this.basicConsentTemplate(it));
            }
        }
        Iterable $this$sortedBy$iv = result;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BasicConsentTemplate it = (BasicConsentTemplate)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getTemplateId());
                it = (BasicConsentTemplate)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTemplateId())));
            }
        });
    }

    private final BasicConsentTemplate basicConsentTemplate(ConsentTemplate service) {
        return new BasicConsentTemplate(service.getTemplateId(), service.getVersion());
    }
}

