/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.tcf.api;

import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.tcf.api.ITCFDeclarationsApi;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/usercentrics/sdk/v2/tcf/api/TCFDeclarationsApi;", "Lcom/usercentrics/sdk/v2/tcf/api/ITCFDeclarationsApi;", "restClient", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;)V", "buildDeclarationsUrl", "", "language", "getDeclarations", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "headers", "", "usercentrics_release"})
public final class TCFDeclarationsApi
implements ITCFDeclarationsApi {
    @NotNull
    private final HttpRequests restClient;
    @NotNull
    private final NetworkResolver networkResolver;

    public TCFDeclarationsApi(@NotNull HttpRequests restClient, @NotNull NetworkResolver networkResolver2) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        this.restClient = restClient;
        this.networkResolver = networkResolver2;
    }

    @Override
    @NotNull
    public HttpResponse getDeclarations(@NotNull String language, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String url = this.buildDeclarationsUrl(language);
        return this.restClient.getSync(url, headers);
    }

    private final String buildDeclarationsUrl(String language) {
        String baseUrl = this.networkResolver.cdnBaseUrl();
        return baseUrl + "/gvl/v3/" + language + ".json";
    }
}

