/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core;

import com.usercentrics.tcf.core.TCModel;
import com.usercentrics.tcf.core.encoder.Base64Url;
import com.usercentrics.tcf.core.encoder.BitLength;
import com.usercentrics.tcf.core.encoder.SegmentEncoder;
import com.usercentrics.tcf.core.encoder.SemanticPreEncoder;
import com.usercentrics.tcf.core.encoder.field.IntEncoder;
import com.usercentrics.tcf.core.encoder.sequence.SegmentSequence;
import com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType;
import com.usercentrics.tcf.core.errors.DecodingError;
import com.usercentrics.tcf.core.errors.EncodingError;
import com.usercentrics.tcf.core.model.Segment;
import com.usercentrics.tcf.core.model.SegmentIDs;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/tcf/core/TCString;", "", "()V", "Companion", "usercentrics_release"})
public final class TCString {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/usercentrics/tcf/core/TCString$Companion;", "", "()V", "decode", "Lcom/usercentrics/tcf/core/TCModel;", "encodedTCString", "", "tcModel", "decode$usercentrics_release", "encode", "encode$usercentrics_release", "usercentrics_release"})
    @SourceDebugExtension(value={"SMAP\nTCString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCString.kt\ncom/usercentrics/tcf/core/TCString$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1864#2,3:102\n*S KotlinDebug\n*F\n+ 1 TCString.kt\ncom/usercentrics/tcf/core/TCString$Companion\n*L\n41#1:102,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String encode$usercentrics_release(@NotNull TCModel tcModel) {
            Intrinsics.checkNotNullParameter((Object)tcModel, (String)"tcModel");
            TCModel internalTCModel = SemanticPreEncoder.Companion.process(tcModel);
            int version = internalTCModel.getVersion();
            if (version != 2) {
                throw new EncodingError("Unsupported TCF version: " + version);
            }
            String out = null;
            out = "";
            SequenceVersionMapType sequenceVersionMapType = new SegmentSequence(internalTCModel).getTwo();
            Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.List");
            List<Segment> sequence = ((SequenceVersionMapType.List)sequenceVersionMapType).getValue();
            Iterable $this$forEachIndexed$iv = sequence;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void segment;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Segment segment2 = (Segment)((Object)item$iv);
                int index = n;
                boolean bl = false;
                String dotMaybe = "";
                if (index < sequence.size() - 1) {
                    dotMaybe = ".";
                }
                out = out + SegmentEncoder.Companion.encode$usercentrics_release(internalTCModel, (Segment)segment) + dotMaybe;
            }
            return out;
        }

        @NotNull
        public final TCModel decode$usercentrics_release(@NotNull String encodedTCString, @NotNull TCModel tcModel) {
            Intrinsics.checkNotNullParameter((Object)encodedTCString, (String)"encodedTCString");
            Intrinsics.checkNotNullParameter((Object)tcModel, (String)"tcModel");
            int version = tcModel.getVersion();
            if (version != 2) {
                throw new DecodingError("Unable TCF String with version " + version);
            }
            String[] stringArray = new String[]{"."};
            List segments = StringsKt.split$default((CharSequence)encodedTCString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            int len = segments.size();
            TCModel tempTcModel = tcModel;
            TCModel retrTCModel = null;
            for (int i = 0; i < len; ++i) {
                String segTypeBits;
                String segString = (String)segments.get(i);
                String firstChar = Base64Url.Companion.decode(String.valueOf(segString.charAt(0)));
                Intrinsics.checkNotNullExpressionValue((Object)firstChar.substring(0, BitLength.segmentType.getInteger()), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String segment = SegmentIDs.Companion.getID_TO_KEY().get((int)IntEncoder.Companion.decode(segTypeBits, BitLength.segmentType.getInteger())).getType();
                retrTCModel = SegmentEncoder.Companion.decode(segString, tempTcModel, segment);
            }
            if (retrTCModel != null) {
                return retrTCModel;
            }
            throw new DecodingError("Unable to decode given TCModel");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

