/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder;

import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.TCFKeys;
import com.usercentrics.tcf.core.TCModel;
import com.usercentrics.tcf.core.TCModelPropType;
import com.usercentrics.tcf.core.encoder.BitLength;
import com.usercentrics.tcf.core.encoder.SegmentEncoder;
import com.usercentrics.tcf.core.encoder.SemanticPreEncoder;
import com.usercentrics.tcf.core.encoder.field.BooleanEncoder;
import com.usercentrics.tcf.core.encoder.field.DateEncoder;
import com.usercentrics.tcf.core.encoder.field.FixedVectorEncoder;
import com.usercentrics.tcf.core.encoder.field.IntEncoder;
import com.usercentrics.tcf.core.encoder.field.PublisherRestrictionsEncoder;
import com.usercentrics.tcf.core.encoder.sequence.SegmentSequence;
import com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType;
import com.usercentrics.tcf.core.errors.EncodingError;
import com.usercentrics.tcf.core.model.Segment;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b0\n\u0002\u0010$\n\u0002\b)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010a\u001a\u00020bJ\u0010\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020fH\u0002J\u0018\u0010g\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010h2\u0006\u0010e\u001a\u00020fH\u0002R\u001e\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u0016R\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0014\"\u0004\b!\u0010\u0016R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016R\u001e\u0010%\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\rR\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0014\"\u0004\b-\u0010\u0016R\u001a\u0010.\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0014\"\u0004\b0\u0010\u0016R\u001a\u00101\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0014\"\u0004\b3\u0010\u0016R\u001a\u00104\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0014\"\u0004\b6\u0010\u0016R&\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000508X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0014\"\u0004\b?\u0010\u0016R\u001a\u0010@\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0014\"\u0004\bB\u0010\u0016R\u001e\u0010C\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\bD\u0010\u000b\"\u0004\bE\u0010\rR\u001a\u0010F\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u0014\"\u0004\bH\u0010\u0016R\u001a\u0010I\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0014\"\u0004\bK\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010L\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\bM\u0010\u000b\"\u0004\bN\u0010\rR\u001a\u0010O\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0014\"\u0004\bQ\u0010\u0016R\u001a\u0010R\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u0014\"\u0004\bT\u0010\u0016R\u001a\u0010U\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\u0014\"\u0004\bW\u0010\u0016R\u001a\u0010X\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010\u0014\"\u0004\bZ\u0010\u0016R\u001a\u0010[\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u0014\"\u0004\b]\u0010\u0016R\u001e\u0010^\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b_\u0010\u000b\"\u0004\b`\u0010\r\u00a8\u0006i"}, d2={"Lcom/usercentrics/tcf/core/encoder/TCFKeysEncoder;", "", "tcModel", "Lcom/usercentrics/tcf/core/TCModel;", "tcString", "", "gdprApplies", "", "(Lcom/usercentrics/tcf/core/TCModel;Ljava/lang/String;I)V", "cmpIdEncoded", "getCmpIdEncoded", "()Ljava/lang/Integer;", "setCmpIdEncoded", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "cmpVersionEncoded", "getCmpVersionEncoded", "setCmpVersionEncoded", "consentLanguageEncoded", "getConsentLanguageEncoded", "()Ljava/lang/String;", "setConsentLanguageEncoded", "(Ljava/lang/String;)V", "consentScreenEncoded", "getConsentScreenEncoded", "setConsentScreenEncoded", "createdEncoded", "getCreatedEncoded", "setCreatedEncoded", "isServiceSpecificEncoded", "setServiceSpecificEncoded", "lastUpdatedEncoded", "getLastUpdatedEncoded", "setLastUpdatedEncoded", "numCustomPurposesEncoded", "getNumCustomPurposesEncoded", "setNumCustomPurposesEncoded", "policyVersionEncoded", "getPolicyVersionEncoded", "setPolicyVersionEncoded", "publisherConsentsEncoded", "getPublisherConsentsEncoded", "setPublisherConsentsEncoded", "publisherCountryCodeEncoded", "getPublisherCountryCodeEncoded", "setPublisherCountryCodeEncoded", "publisherCustomConsentsEncoded", "getPublisherCustomConsentsEncoded", "setPublisherCustomConsentsEncoded", "publisherCustomLegitimateInterestsEncoded", "getPublisherCustomLegitimateInterestsEncoded", "setPublisherCustomLegitimateInterestsEncoded", "publisherLegitimateInterestsEncoded", "getPublisherLegitimateInterestsEncoded", "setPublisherLegitimateInterestsEncoded", "publisherRestrictionsEncoded", "", "getPublisherRestrictionsEncoded", "()Ljava/util/Map;", "setPublisherRestrictionsEncoded", "(Ljava/util/Map;)V", "purposeConsentsEncoded", "getPurposeConsentsEncoded", "setPurposeConsentsEncoded", "purposeLegitimateInterestsEncoded", "getPurposeLegitimateInterestsEncoded", "setPurposeLegitimateInterestsEncoded", "purposeOneTreatmentEncoded", "getPurposeOneTreatmentEncoded", "setPurposeOneTreatmentEncoded", "segmentTypeEncoded", "getSegmentTypeEncoded", "setSegmentTypeEncoded", "specialFeatureOptinsEncoded", "getSpecialFeatureOptinsEncoded", "setSpecialFeatureOptinsEncoded", "useNonStandardStacksEncoded", "getUseNonStandardStacksEncoded", "setUseNonStandardStacksEncoded", "vendorConsentsEncoded", "getVendorConsentsEncoded", "setVendorConsentsEncoded", "vendorLegitimateInterestsEncoded", "getVendorLegitimateInterestsEncoded", "setVendorLegitimateInterestsEncoded", "vendorListVersionEncoded", "getVendorListVersionEncoded", "setVendorListVersionEncoded", "vendorsAllowedEncoded", "getVendorsAllowedEncoded", "setVendorsAllowedEncoded", "vendorsDisclosedEncoded", "getVendorsDisclosedEncoded", "setVendorsDisclosedEncoded", "versionEncoded", "getVersionEncoded", "setVersionEncoded", "encode", "Lcom/usercentrics/tcf/core/TCFKeys;", "encodeSegment", "", "segment", "Lcom/usercentrics/tcf/core/model/Segment;", "getSequenceForSegment", "", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nTCFKeysEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCFKeysEncoder.kt\ncom/usercentrics/tcf/core/encoder/TCFKeysEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n1855#2,2:247\n1855#2,2:249\n*S KotlinDebug\n*F\n+ 1 TCFKeysEncoder.kt\ncom/usercentrics/tcf/core/encoder/TCFKeysEncoder\n*L\n56#1:247,2\n83#1:249,2\n*E\n"})
public final class TCFKeysEncoder {
    @NotNull
    private final TCModel tcModel;
    @NotNull
    private final String tcString;
    private final int gdprApplies;
    @Nullable
    private Integer cmpIdEncoded;
    @Nullable
    private Integer cmpVersionEncoded;
    @Nullable
    private Integer policyVersionEncoded;
    @NotNull
    private String publisherCountryCodeEncoded;
    @Nullable
    private Integer purposeOneTreatmentEncoded;
    @Nullable
    private Integer useNonStandardStacksEncoded;
    @NotNull
    private String vendorConsentsEncoded;
    @NotNull
    private String vendorLegitimateInterestsEncoded;
    @NotNull
    private String purposeConsentsEncoded;
    @NotNull
    private String purposeLegitimateInterestsEncoded;
    @NotNull
    private String specialFeatureOptinsEncoded;
    @NotNull
    private Map<Integer, String> publisherRestrictionsEncoded;
    @NotNull
    private String publisherConsentsEncoded;
    @NotNull
    private String publisherLegitimateInterestsEncoded;
    @NotNull
    private String publisherCustomConsentsEncoded;
    @NotNull
    private String publisherCustomLegitimateInterestsEncoded;
    @Nullable
    private Integer versionEncoded;
    @NotNull
    private String numCustomPurposesEncoded;
    @NotNull
    private String consentScreenEncoded;
    @NotNull
    private String vendorListVersionEncoded;
    @NotNull
    private String segmentTypeEncoded;
    @NotNull
    private String createdEncoded;
    @NotNull
    private String lastUpdatedEncoded;
    @NotNull
    private String consentLanguageEncoded;
    @NotNull
    private String isServiceSpecificEncoded;
    @NotNull
    private String vendorsDisclosedEncoded;
    @NotNull
    private String vendorsAllowedEncoded;

    public TCFKeysEncoder(@NotNull TCModel tcModel, @NotNull String tcString, int gdprApplies) {
        Intrinsics.checkNotNullParameter((Object)tcModel, (String)"tcModel");
        Intrinsics.checkNotNullParameter((Object)tcString, (String)"tcString");
        this.tcModel = tcModel;
        this.tcString = tcString;
        this.gdprApplies = gdprApplies;
        this.publisherCountryCodeEncoded = "AA";
        this.vendorConsentsEncoded = "";
        this.vendorLegitimateInterestsEncoded = "";
        this.purposeConsentsEncoded = "";
        this.purposeLegitimateInterestsEncoded = "";
        this.specialFeatureOptinsEncoded = "";
        this.publisherRestrictionsEncoded = MapsKt.emptyMap();
        this.publisherConsentsEncoded = "";
        this.publisherLegitimateInterestsEncoded = "";
        this.publisherCustomConsentsEncoded = "";
        this.publisherCustomLegitimateInterestsEncoded = "";
        this.numCustomPurposesEncoded = "";
        this.consentScreenEncoded = "";
        this.vendorListVersionEncoded = "";
        this.segmentTypeEncoded = "";
        this.createdEncoded = "";
        this.lastUpdatedEncoded = "";
        this.consentLanguageEncoded = "";
        this.isServiceSpecificEncoded = "";
        this.vendorsDisclosedEncoded = "";
        this.vendorsAllowedEncoded = "";
    }

    @Nullable
    public final Integer getCmpIdEncoded() {
        return this.cmpIdEncoded;
    }

    public final void setCmpIdEncoded(@Nullable Integer n) {
        this.cmpIdEncoded = n;
    }

    @Nullable
    public final Integer getCmpVersionEncoded() {
        return this.cmpVersionEncoded;
    }

    public final void setCmpVersionEncoded(@Nullable Integer n) {
        this.cmpVersionEncoded = n;
    }

    @Nullable
    public final Integer getPolicyVersionEncoded() {
        return this.policyVersionEncoded;
    }

    public final void setPolicyVersionEncoded(@Nullable Integer n) {
        this.policyVersionEncoded = n;
    }

    @NotNull
    public final String getPublisherCountryCodeEncoded() {
        return this.publisherCountryCodeEncoded;
    }

    public final void setPublisherCountryCodeEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.publisherCountryCodeEncoded = string;
    }

    @Nullable
    public final Integer getPurposeOneTreatmentEncoded() {
        return this.purposeOneTreatmentEncoded;
    }

    public final void setPurposeOneTreatmentEncoded(@Nullable Integer n) {
        this.purposeOneTreatmentEncoded = n;
    }

    @Nullable
    public final Integer getUseNonStandardStacksEncoded() {
        return this.useNonStandardStacksEncoded;
    }

    public final void setUseNonStandardStacksEncoded(@Nullable Integer n) {
        this.useNonStandardStacksEncoded = n;
    }

    @NotNull
    public final String getVendorConsentsEncoded() {
        return this.vendorConsentsEncoded;
    }

    public final void setVendorConsentsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.vendorConsentsEncoded = string;
    }

    @NotNull
    public final String getVendorLegitimateInterestsEncoded() {
        return this.vendorLegitimateInterestsEncoded;
    }

    public final void setVendorLegitimateInterestsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.vendorLegitimateInterestsEncoded = string;
    }

    @NotNull
    public final String getPurposeConsentsEncoded() {
        return this.purposeConsentsEncoded;
    }

    public final void setPurposeConsentsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.purposeConsentsEncoded = string;
    }

    @NotNull
    public final String getPurposeLegitimateInterestsEncoded() {
        return this.purposeLegitimateInterestsEncoded;
    }

    public final void setPurposeLegitimateInterestsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.purposeLegitimateInterestsEncoded = string;
    }

    @NotNull
    public final String getSpecialFeatureOptinsEncoded() {
        return this.specialFeatureOptinsEncoded;
    }

    public final void setSpecialFeatureOptinsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.specialFeatureOptinsEncoded = string;
    }

    @NotNull
    public final Map<Integer, String> getPublisherRestrictionsEncoded() {
        return this.publisherRestrictionsEncoded;
    }

    public final void setPublisherRestrictionsEncoded(@NotNull Map<Integer, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.publisherRestrictionsEncoded = map2;
    }

    @NotNull
    public final String getPublisherConsentsEncoded() {
        return this.publisherConsentsEncoded;
    }

    public final void setPublisherConsentsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.publisherConsentsEncoded = string;
    }

    @NotNull
    public final String getPublisherLegitimateInterestsEncoded() {
        return this.publisherLegitimateInterestsEncoded;
    }

    public final void setPublisherLegitimateInterestsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.publisherLegitimateInterestsEncoded = string;
    }

    @NotNull
    public final String getPublisherCustomConsentsEncoded() {
        return this.publisherCustomConsentsEncoded;
    }

    public final void setPublisherCustomConsentsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.publisherCustomConsentsEncoded = string;
    }

    @NotNull
    public final String getPublisherCustomLegitimateInterestsEncoded() {
        return this.publisherCustomLegitimateInterestsEncoded;
    }

    public final void setPublisherCustomLegitimateInterestsEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.publisherCustomLegitimateInterestsEncoded = string;
    }

    @Nullable
    public final Integer getVersionEncoded() {
        return this.versionEncoded;
    }

    public final void setVersionEncoded(@Nullable Integer n) {
        this.versionEncoded = n;
    }

    @NotNull
    public final String getNumCustomPurposesEncoded() {
        return this.numCustomPurposesEncoded;
    }

    public final void setNumCustomPurposesEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.numCustomPurposesEncoded = string;
    }

    @NotNull
    public final String getConsentScreenEncoded() {
        return this.consentScreenEncoded;
    }

    public final void setConsentScreenEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.consentScreenEncoded = string;
    }

    @NotNull
    public final String getVendorListVersionEncoded() {
        return this.vendorListVersionEncoded;
    }

    public final void setVendorListVersionEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.vendorListVersionEncoded = string;
    }

    @NotNull
    public final String getSegmentTypeEncoded() {
        return this.segmentTypeEncoded;
    }

    public final void setSegmentTypeEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.segmentTypeEncoded = string;
    }

    @NotNull
    public final String getCreatedEncoded() {
        return this.createdEncoded;
    }

    public final void setCreatedEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.createdEncoded = string;
    }

    @NotNull
    public final String getLastUpdatedEncoded() {
        return this.lastUpdatedEncoded;
    }

    public final void setLastUpdatedEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lastUpdatedEncoded = string;
    }

    @NotNull
    public final String getConsentLanguageEncoded() {
        return this.consentLanguageEncoded;
    }

    public final void setConsentLanguageEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.consentLanguageEncoded = string;
    }

    @NotNull
    public final String isServiceSpecificEncoded() {
        return this.isServiceSpecificEncoded;
    }

    public final void setServiceSpecificEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.isServiceSpecificEncoded = string;
    }

    @NotNull
    public final String getVendorsDisclosedEncoded() {
        return this.vendorsDisclosedEncoded;
    }

    public final void setVendorsDisclosedEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.vendorsDisclosedEncoded = string;
    }

    @NotNull
    public final String getVendorsAllowedEncoded() {
        return this.vendorsAllowedEncoded;
    }

    public final void setVendorsAllowedEncoded(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.vendorsAllowedEncoded = string;
    }

    @NotNull
    public final TCFKeys encode() {
        TCModel internalTCModel = SemanticPreEncoder.Companion.process(this.tcModel);
        int version = internalTCModel.getVersion();
        if (version != 2) {
            throw new EncodingError("Error encoding TCF String. Invalid version: " + version);
        }
        SequenceVersionMapType sequenceVersionMapType = new SegmentSequence(internalTCModel).getTwo();
        Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.List");
        List<Segment> sequence = ((SequenceVersionMapType.List)sequenceVersionMapType).getValue();
        Iterable $this$forEach$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Segment segment = (Segment)((Object)element$iv);
            boolean bl = false;
            this.encodeSegment(segment);
        }
        String string = this.tcString;
        int n = this.gdprApplies;
        Integer n2 = this.cmpIdEncoded;
        Integer n3 = this.cmpVersionEncoded;
        Integer n4 = this.policyVersionEncoded;
        String string2 = this.publisherCountryCodeEncoded;
        Integer n5 = this.purposeOneTreatmentEncoded;
        Integer n6 = this.useNonStandardStacksEncoded;
        String string3 = this.vendorConsentsEncoded;
        String string4 = this.vendorLegitimateInterestsEncoded;
        String string5 = this.purposeConsentsEncoded;
        String string6 = this.purposeLegitimateInterestsEncoded;
        String string7 = this.specialFeatureOptinsEncoded;
        Map<Integer, String> map2 = this.publisherRestrictionsEncoded;
        String string8 = this.publisherConsentsEncoded;
        String string9 = this.publisherLegitimateInterestsEncoded;
        String string10 = this.publisherCustomConsentsEncoded;
        String string11 = this.publisherCustomLegitimateInterestsEncoded;
        return new TCFKeys(n2, n3, n4, n, string2, n5, n6, string, string3, string4, string5, string6, string7, map2, string8, string9, string10, string11);
    }

    private final void encodeSegment(Segment segment) {
        block93: {
            List<String> list = this.getSequenceForSegment(segment);
            if (list == null) break block93;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            block51: for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                TCModelPropType value = this.tcModel.getFieldByName(key);
                BitLength bitLength = BitLength.Companion.getByName(key);
                int numBits = 0;
                if (bitLength == null) {
                    if (SegmentEncoder.Companion.isPublisherCustom(key)) {
                        Object numCustomPurposes = this.tcModel.getNumCustomPurposes();
                        if (numCustomPurposes instanceof StringOrNumber.Int) {
                            numBits = ((StringOrNumber.Int)numCustomPurposes).getValue();
                        }
                        if (numCustomPurposes instanceof StringOrNumber.String) {
                            numBits = Integer.parseInt(((StringOrNumber.String)numCustomPurposes).getValue());
                        }
                    }
                } else {
                    numBits = bitLength.getInteger();
                }
                try {
                    switch (key) {
                        case "numCustomPurposes": 
                        case "version": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Int");
                            TCModelPropType.Int cfr_ignored_0 = (TCModelPropType.Int)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"version")) {
                                this.versionEncoded = ((TCModelPropType.Int)value).getValue();
                                continue block51;
                            }
                            this.numCustomPurposesEncoded = IntEncoder.Companion.encode(new StringOrNumber.Int(((TCModelPropType.Int)value).getValue()), numBits);
                            continue block51;
                        }
                        case "policyVersion": 
                        case "cmpVersion": 
                        case "vendorListVersion": 
                        case "cmpId": 
                        case "consentScreen": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.StringOrNumber");
                            TCModelPropType.StringOrNumber cfr_ignored_1 = (TCModelPropType.StringOrNumber)value;
                            StringOrNumber internalValue = ((TCModelPropType.StringOrNumber)value).getValue();
                            Intrinsics.checkNotNull((Object)internalValue, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.StringOrNumber.Int");
                            StringOrNumber.Int cfr_ignored_2 = (StringOrNumber.Int)internalValue;
                            if (Intrinsics.areEqual((Object)key, (Object)"cmpId")) {
                                this.cmpIdEncoded = ((StringOrNumber.Int)internalValue).getValue();
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"cmpVersion")) {
                                this.cmpVersionEncoded = ((StringOrNumber.Int)internalValue).getValue();
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"consentScreen")) {
                                this.consentScreenEncoded = IntEncoder.Companion.encode(new StringOrNumber.Int(((StringOrNumber.Int)internalValue).getValue()), numBits);
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"vendorListVersion")) {
                                this.vendorListVersionEncoded = IntEncoder.Companion.encode(new StringOrNumber.Int(((StringOrNumber.Int)internalValue).getValue()), numBits);
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"policyVersion")) continue block51;
                            this.policyVersionEncoded = ((StringOrNumber.Int)internalValue).getValue();
                            continue block51;
                        }
                        case "segmentType": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.StringOrNumber");
                            TCModelPropType.StringOrNumber cfr_ignored_3 = (TCModelPropType.StringOrNumber)value;
                            this.segmentTypeEncoded = IntEncoder.Companion.encode(((TCModelPropType.StringOrNumber)value).getValue(), numBits);
                            continue block51;
                        }
                        case "lastUpdated": 
                        case "created": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Date");
                            TCModelPropType.Date cfr_ignored_4 = (TCModelPropType.Date)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"created")) {
                                Long l = ((TCModelPropType.Date)value).getValue();
                                Intrinsics.checkNotNull((Object)l);
                                this.createdEncoded = DateEncoder.Companion.encode(l, numBits);
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"lastUpdated")) continue block51;
                            Long l = ((TCModelPropType.Date)value).getValue();
                            Intrinsics.checkNotNull((Object)l);
                            this.lastUpdatedEncoded = DateEncoder.Companion.encode(l, numBits);
                            continue block51;
                        }
                        case "consentLanguage": 
                        case "publisherCountryCode": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.String");
                            TCModelPropType.String cfr_ignored_5 = (TCModelPropType.String)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"consentLanguage")) {
                                this.consentLanguageEncoded = ((TCModelPropType.String)value).getValue();
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"publisherCountryCode")) continue block51;
                            this.publisherCountryCodeEncoded = ((TCModelPropType.String)value).getValue();
                            continue block51;
                        }
                        case "isServiceSpecific": 
                        case "useNonStandardStacks": 
                        case "purposeOneTreatment": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Boolean");
                            TCModelPropType.Boolean cfr_ignored_6 = (TCModelPropType.Boolean)value;
                            if (Intrinsics.areEqual((Object)key, (Object)"isServiceSpecific")) {
                                this.isServiceSpecificEncoded = BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue());
                            }
                            if (Intrinsics.areEqual((Object)key, (Object)"useNonStandardStacks")) {
                                this.useNonStandardStacksEncoded = Integer.parseInt(BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue()));
                            }
                            if (!Intrinsics.areEqual((Object)key, (Object)"purposeOneTreatment")) continue block51;
                            this.purposeOneTreatmentEncoded = Integer.parseInt(BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue()));
                            continue block51;
                        }
                        case "specialFeatureOptins": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_7 = (TCModelPropType.Vector)value;
                            this.specialFeatureOptinsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "purposeConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_8 = (TCModelPropType.Vector)value;
                            this.purposeConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "purposeLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_9 = (TCModelPropType.Vector)value;
                            this.purposeLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_10 = (TCModelPropType.Vector)value;
                            this.publisherConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_11 = (TCModelPropType.Vector)value;
                            this.publisherLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherCustomConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_12 = (TCModelPropType.Vector)value;
                            this.publisherCustomConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherCustomLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_13 = (TCModelPropType.Vector)value;
                            this.publisherCustomLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorConsents": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_14 = (TCModelPropType.Vector)value;
                            this.vendorConsentsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorLegitimateInterests": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_15 = (TCModelPropType.Vector)value;
                            this.vendorLegitimateInterestsEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorsDisclosed": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_16 = (TCModelPropType.Vector)value;
                            this.vendorsDisclosedEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "vendorsAllowed": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                            TCModelPropType.Vector cfr_ignored_17 = (TCModelPropType.Vector)value;
                            this.vendorsAllowedEncoded = FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), null);
                            continue block51;
                        }
                        case "publisherRestrictions": {
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.PurposeRestrictionVector");
                            TCModelPropType.PurposeRestrictionVector cfr_ignored_18 = (TCModelPropType.PurposeRestrictionVector)value;
                            this.publisherRestrictionsEncoded = PublisherRestrictionsEncoder.Companion.encode(((TCModelPropType.PurposeRestrictionVector)value).getValue());
                            continue block51;
                        }
                        default: {
                            throw new EncodingError("Error encoding " + (Object)((Object)segment) + "->" + key + ", value: " + value);
                        }
                    }
                }
                catch (Throwable error) {
                    throw new EncodingError("Error encoding " + (Object)((Object)segment) + "->" + key + ": " + error.getMessage());
                }
            }
        }
    }

    private final List<String> getSequenceForSegment(Segment segment) {
        SequenceVersionMapType sequenceVersionMapType = SegmentEncoder.Companion.getFieldSequence().getTwo();
        Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.SVMItemMap");
        return ((SequenceVersionMapType.SVMItemMap)sequenceVersionMapType).getMap().get((Object)segment);
    }
}

