/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder.field;

import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.encoder.field.IntEncoder;
import com.usercentrics.tcf.core.errors.DecodingError;
import com.usercentrics.tcf.core.errors.EncodingError;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/tcf/core/encoder/field/LangEncoder;", "", "()V", "Companion", "usercentrics_release"})
public final class LangEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/usercentrics/tcf/core/encoder/field/LangEncoder$Companion;", "", "()V", "decode", "", "value", "numBits", "", "encode", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String encode(@NotNull String value, int numBits) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String internalValue = string;
            int ASCII_START = 65;
            int firstLetter = (byte)internalValue.charAt(0) - ASCII_START;
            int secondLetter = (byte)internalValue.charAt(1) - ASCII_START;
            if (firstLetter < 0 || firstLetter > 25 || secondLetter < 0 || secondLetter > 25) {
                throw new EncodingError("Invalid Language Code: " + internalValue);
            }
            if (numBits % 2 == 1) {
                throw new EncodingError("numBits must be even, " + numBits + " is not valid");
            }
            int singleCharacterNumBits = numBits / 2;
            String firstLetterBString = IntEncoder.Companion.encode(new StringOrNumber.Int(firstLetter), singleCharacterNumBits);
            String secondLetterBString = IntEncoder.Companion.encode(new StringOrNumber.Int(secondLetter), singleCharacterNumBits);
            return firstLetterBString + secondLetterBString;
        }

        @NotNull
        public final String decode(@NotNull String value, int numBits) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String retr = null;
            if (numBits != value.length() || value.length() % 2 != 0) {
                throw new DecodingError("Invalid bit length for language");
            }
            int ASCII_START = 65;
            int mid = value.length() / 2;
            long firstLetter = IntEncoder.Companion.decode(StringsKt.slice((String)value, (IntRange)new IntRange(0, mid - 1)), mid) + (long)ASCII_START;
            long secondLetter = IntEncoder.Companion.decode(StringsKt.slice((String)value, (IntRange)new IntRange(mid, value.length() - 1)), mid) + (long)ASCII_START;
            retr = "" + (char)firstLetter + (char)secondLetter;
            return retr;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

