/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.core.time;

import com.usercentrics.sdk.core.time.DateParseException;
import com.usercentrics.sdk.core.time.DateTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\rJ\u0018\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\rH\u0002J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010&\u001a\u00020\u0000J\u0011\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0000J\u0013\u0010+\u001a\u00020,2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010-\u001a\u00020\u0007J\b\u0010.\u001a\u00020\rH\u0016J\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u001b\u0010\u0015\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0011\u001a\u0004\b\u0016\u0010\u000fR\u001b\u0010\u0018\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0011\u001a\u0004\b\u0019\u0010\u000fR\u001b\u0010\u001b\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0011\u001a\u0004\b\u001c\u0010\u000fR\u001b\u0010\u001e\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0011\u001a\u0004\b\u001f\u0010\u000f\u00a8\u00060"}, d2={"Lcom/usercentrics/sdk/core/time/DateTime;", "", "()V", "timestamp", "", "(J)V", "utcISOString", "", "(Ljava/lang/String;)V", "calendar", "Ljava/util/Calendar;", "(Ljava/util/Calendar;)V", "day", "", "getDay", "()I", "day$delegate", "Lkotlin/Lazy;", "hours", "getHours", "hours$delegate", "minutes", "getMinutes", "minutes$delegate", "month", "getMonth", "month$delegate", "seconds", "getSeconds", "seconds$delegate", "year", "getYear", "year$delegate", "addDays", "amount", "addField", "field", "addMonths", "atMidnight", "compareTo", "other", "diffInDays", "dateTime", "equals", "", "formatLocalTimezone", "hashCode", "Companion", "usercentrics_release"})
public final class DateTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy year$delegate;
    @NotNull
    private final Lazy month$delegate;
    @NotNull
    private final Lazy day$delegate;
    @NotNull
    private final Lazy hours$delegate;
    @NotNull
    private final Lazy minutes$delegate;
    @NotNull
    private final Lazy seconds$delegate;
    @NotNull
    private final Calendar calendar;
    @Nullable
    private static DateTime nowMocked;
    private static final TimeZone utcTimeZone;
    @NotNull
    private static final Lazy<SimpleDateFormat> utcISODateFormat$delegate;
    @NotNull
    private static final Lazy<SimpleDateFormat> localDateFormat$delegate;

    public final int getYear() {
        Lazy lazy = this.year$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getMonth() {
        Lazy lazy = this.month$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getDay() {
        Lazy lazy = this.day$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getHours() {
        Lazy lazy = this.hours$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getMinutes() {
        Lazy lazy = this.minutes$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public final int getSeconds() {
        Lazy lazy = this.seconds$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public DateTime() {
        this(DateTime.Companion.now());
    }

    public DateTime(long timestamp) {
        this(DateTime.Companion.calendarFromTimestamp(timestamp));
    }

    public DateTime(@NotNull String utcISOString) {
        Intrinsics.checkNotNullParameter((Object)utcISOString, (String)"utcISOString");
        this(DateTime.Companion.calendarFromUtcISOString(utcISOString));
    }

    public DateTime(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        this.year$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DateTime.access$getCalendar$p(this.this$0).get(1);
            }
        }));
        this.month$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DateTime.access$getCalendar$p(this.this$0).get(2) + 1;
            }
        }));
        this.day$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DateTime.access$getCalendar$p(this.this$0).get(5);
            }
        }));
        this.hours$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DateTime.access$getCalendar$p(this.this$0).get(11);
            }
        }));
        this.minutes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DateTime.access$getCalendar$p(this.this$0).get(12);
            }
        }));
        this.seconds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ DateTime this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return DateTime.access$getCalendar$p(this.this$0).get(13);
            }
        }));
        this.calendar = calendar;
    }

    public final long timestamp() {
        return this.calendar.getTime().getTime();
    }

    @NotNull
    public final DateTime addMonths(int amount) {
        return this.addField(2, amount);
    }

    @NotNull
    public final DateTime addDays(int amount) {
        return this.addField(5, amount);
    }

    private final DateTime addField(int field, int amount) {
        Calendar calendar;
        Calendar $this$addField_u24lambda_u240 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$addField_u24lambda_u240.setTime(this.calendar.getTime());
        Calendar newCalendar = calendar;
        newCalendar.add(field, amount);
        Intrinsics.checkNotNull((Object)newCalendar);
        return new DateTime(newCalendar);
    }

    public final int diffInDays(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        long diff = this.timestamp() - dateTime.timestamp();
        return (int)TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public final String formatLocalTimezone() {
        String string = DateTime.Companion.getLocalDateFormat().format(this.calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final DateTime atMidnight() {
        Calendar calendar;
        Calendar $this$atMidnight_u24lambda_u241 = calendar = Calendar.getInstance(utcTimeZone);
        boolean bl = false;
        $this$atMidnight_u24lambda_u241.setTime(this.calendar.getTime());
        Calendar newCalendar = calendar;
        newCalendar.set(11, 0);
        newCalendar.set(12, 0);
        newCalendar.set(13, 0);
        newCalendar.set(14, 0);
        Intrinsics.checkNotNull((Object)newCalendar);
        return new DateTime(newCalendar);
    }

    public final int compareTo(@NotNull DateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.timestamp(), (long)other.timestamp());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.usercentrics.sdk.core.time.DateTime");
        DateTime cfr_ignored_0 = (DateTime)other;
        return this.timestamp() == ((DateTime)other).timestamp();
    }

    public int hashCode() {
        return Long.hashCode(this.timestamp());
    }

    public static final /* synthetic */ Calendar access$getCalendar$p(DateTime $this) {
        return $this.calendar;
    }

    static {
        utcTimeZone = TimeZone.getTimeZone("UTC");
        utcISODateFormat$delegate = LazyKt.lazy((Function0)Companion.utcISODateFormat.2.INSTANCE);
        localDateFormat$delegate = LazyKt.lazy((Function0)Companion.localDateFormat.2.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/usercentrics/sdk/core/time/DateTime$Companion;", "", "()V", "localDateFormat", "Ljava/text/SimpleDateFormat;", "getLocalDateFormat", "()Ljava/text/SimpleDateFormat;", "localDateFormat$delegate", "Lkotlin/Lazy;", "nowMocked", "Lcom/usercentrics/sdk/core/time/DateTime;", "getNowMocked", "()Lcom/usercentrics/sdk/core/time/DateTime;", "setNowMocked", "(Lcom/usercentrics/sdk/core/time/DateTime;)V", "utcISODateFormat", "getUtcISODateFormat", "utcISODateFormat$delegate", "utcTimeZone", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "calendarFromDate", "Ljava/util/Calendar;", "date", "Ljava/util/Date;", "calendarFromTimestamp", "timestamp", "", "calendarFromUtcISOString", "utcISOString", "", "now", "usercentrics_release"})
    @SourceDebugExtension(value={"SMAP\nDateTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTime.kt\ncom/usercentrics/sdk/core/time/DateTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DateTime getNowMocked() {
            return nowMocked;
        }

        public final void setNowMocked(@Nullable DateTime dateTime) {
            nowMocked = dateTime;
        }

        private final SimpleDateFormat getUtcISODateFormat() {
            Lazy lazy = utcISODateFormat$delegate;
            return (SimpleDateFormat)lazy.getValue();
        }

        private final SimpleDateFormat getLocalDateFormat() {
            Lazy lazy = localDateFormat$delegate;
            return (SimpleDateFormat)lazy.getValue();
        }

        private final Calendar now() {
            Object object;
            block3: {
                block2: {
                    object = this.getNowMocked();
                    if (object == null) break block2;
                    DateTime it = object;
                    boolean bl = false;
                    Calendar calendar = Companion.calendarFromTimestamp(it.timestamp());
                    object = calendar;
                    if (calendar != null) break block3;
                }
                Calendar calendar = Calendar.getInstance(utcTimeZone);
                object = calendar;
                Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
            }
            return object;
        }

        private final Calendar calendarFromTimestamp(long timestamp) {
            return this.calendarFromDate(new Date(timestamp));
        }

        private final Calendar calendarFromDate(Date date) {
            Calendar calendar;
            Calendar $this$calendarFromDate_u24lambda_u241 = calendar = Calendar.getInstance(utcTimeZone);
            boolean bl = false;
            $this$calendarFromDate_u24lambda_u241.setTime(date);
            Calendar calendar2 = calendar;
            Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"apply(...)");
            return calendar2;
        }

        private final Calendar calendarFromUtcISOString(String utcISOString) {
            try {
                Date date = this.getUtcISODateFormat().parse(utcISOString);
                Intrinsics.checkNotNull((Object)date);
                Date date2 = date;
                return this.calendarFromDate(date2);
            }
            catch (Exception ex) {
                throw new DateParseException();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

