/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.data;

import com.usercentrics.sdk.mediation.data.MediationGranularConsent;
import com.usercentrics.sdk.mediation.data.TCFConsentValue;
import com.usercentrics.sdk.services.tcf.interfaces.TCFPurpose;
import com.usercentrics.sdk.services.tcf.interfaces.TCFVendor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 #2\u00020\u0001:\u0001#B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0003J\u001c\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\f2\n\u0010\u001b\u001a\u00020\u001c\"\u00020\u000bH\u0002J?\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u000bH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/usercentrics/sdk/mediation/data/TCFConsentPayload;", "", "eea", "", "purposes", "", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFPurpose;", "vendors", "Lcom/usercentrics/sdk/services/tcf/interfaces/TCFVendor;", "(ZLjava/util/List;Ljava/util/List;)V", "", "", "Lcom/usercentrics/sdk/mediation/data/TCFConsentValue;", "(ZLjava/util/Map;Ljava/util/Map;)V", "getEea", "()Z", "getPurposes", "()Ljava/util/Map;", "getVendors", "buildGranularConsent", "Lcom/usercentrics/sdk/mediation/data/MediationGranularConsent;", "vendorId", "component1", "component2", "component3", "consentForPurposes", "vendorConsentValue", "purposeIds", "", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nTCFConsentPayload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TCFConsentPayload.kt\ncom/usercentrics/sdk/mediation/data/TCFConsentPayload\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n1179#2,2:74\n1253#2,4:76\n1179#2,2:80\n1253#2,4:82\n12313#3,2:86\n*S KotlinDebug\n*F\n+ 1 TCFConsentPayload.kt\ncom/usercentrics/sdk/mediation/data/TCFConsentPayload\n*L\n14#1:74,2\n14#1:76,4\n20#1:80,2\n20#1:82,4\n43#1:86,2\n*E\n"})
public final class TCFConsentPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean eea;
    @NotNull
    private final Map<Integer, TCFConsentValue> purposes;
    @NotNull
    private final Map<Integer, TCFConsentValue> vendors;

    public TCFConsentPayload(boolean eea, @NotNull Map<Integer, TCFConsentValue> purposes2, @NotNull Map<Integer, TCFConsentValue> vendors) {
        Intrinsics.checkNotNullParameter(purposes2, (String)"purposes");
        Intrinsics.checkNotNullParameter(vendors, (String)"vendors");
        this.eea = eea;
        this.purposes = purposes2;
        this.vendors = vendors;
    }

    public final boolean getEea() {
        return this.eea;
    }

    @NotNull
    public final Map<Integer, TCFConsentValue> getPurposes() {
        return this.purposes;
    }

    @NotNull
    public final Map<Integer, TCFConsentValue> getVendors() {
        return this.vendors;
    }

    public TCFConsentPayload(boolean eea, @NotNull List<TCFPurpose> purposes2, @NotNull List<TCFVendor> vendors) {
        Map map2;
        Iterable $this$associateTo$iv$iv;
        Iterable $this$associate$iv;
        Intrinsics.checkNotNullParameter(purposes2, (String)"purposes");
        Intrinsics.checkNotNullParameter(vendors, (String)"vendors");
        Iterable iterable = purposes2;
        boolean bl = eea;
        TCFConsentPayload tCFConsentPayload = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map2 = destination$iv$iv;
            TCFPurpose purpose = (TCFPurpose)element$iv$iv;
            boolean bl2 = false;
            purpose = TuplesKt.to((Object)purpose.getId(), (Object)new TCFConsentValue(TCFConsentPayload.Companion.valueAwareOfToggleVisibility(purpose.getConsent(), purpose.getShowConsentToggle()), TCFConsentPayload.Companion.valueAwareOfToggleVisibility(purpose.getLegitimateInterestConsent(), purpose.getShowLegitimateInterestToggle())));
            map2.put(purpose.getFirst(), purpose.getSecond());
        }
        Map map3 = destination$iv$iv;
        $this$associate$iv = vendors;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$associateTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map2 = destination$iv$iv;
            TCFVendor vendor = (TCFVendor)element$iv$iv;
            boolean bl3 = false;
            Pair pair = TuplesKt.to((Object)vendor.getId(), (Object)new TCFConsentValue(TCFConsentPayload.Companion.valueAwareOfToggleVisibility(vendor.getConsent(), vendor.getShowConsentToggle()), TCFConsentPayload.Companion.valueAwareOfToggleVisibility(vendor.getLegitimateInterestConsent(), vendor.getShowLegitimateInterestToggle())));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map4 = destination$iv$iv;
        tCFConsentPayload(bl, map3, map4);
    }

    @Nullable
    public final MediationGranularConsent buildGranularConsent(int vendorId) {
        TCFConsentValue tCFConsentValue = this.vendors.get(vendorId);
        if (tCFConsentValue == null) {
            return null;
        }
        TCFConsentValue vendorConsentValue = tCFConsentValue;
        int[] nArray = new int[]{9, 10};
        boolean bl = this.consentForPurposes(vendorConsentValue, nArray);
        nArray = new int[]{1};
        boolean bl2 = this.consentForPurposes(vendorConsentValue, nArray);
        nArray = new int[]{1, 7};
        boolean bl3 = this.consentForPurposes(vendorConsentValue, nArray);
        nArray = new int[]{3, 4};
        return new MediationGranularConsent(this.eea, bl, bl2, bl3, this.consentForPurposes(vendorConsentValue, nArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean consentForPurposes(TCFConsentValue vendorConsentValue, int ... purposeIds) {
        int[] $this$all$iv = purposeIds;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            boolean bl;
            TCFConsentValue purposeConsentValue;
            int element$iv;
            int it = element$iv = $this$all$iv[n];
            boolean bl2 = false;
            if (this.purposes.get(it) == null) {
                return false;
            }
            if (purposeConsentValue.getConsent() != null) {
                if (vendorConsentValue.getConsent() != null) {
                    if (vendorConsentValue.getConsent() == false) return false;
                    if (purposeConsentValue.getConsent() == false) return false;
                    bl = true;
                } else {
                    bl = purposeConsentValue.getConsent();
                }
            } else {
                if (purposeConsentValue.getLegitimateInterest() == null) return false;
                if (vendorConsentValue.getLegitimateInterest() == null) return purposeConsentValue.getLegitimateInterest();
                if (vendorConsentValue.getLegitimateInterest() == false) return false;
                if (purposeConsentValue.getLegitimateInterest() == false) return false;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean component1() {
        return this.eea;
    }

    @NotNull
    public final Map<Integer, TCFConsentValue> component2() {
        return this.purposes;
    }

    @NotNull
    public final Map<Integer, TCFConsentValue> component3() {
        return this.vendors;
    }

    @NotNull
    public final TCFConsentPayload copy(boolean eea, @NotNull Map<Integer, TCFConsentValue> purposes2, @NotNull Map<Integer, TCFConsentValue> vendors) {
        Intrinsics.checkNotNullParameter(purposes2, (String)"purposes");
        Intrinsics.checkNotNullParameter(vendors, (String)"vendors");
        return new TCFConsentPayload(eea, purposes2, vendors);
    }

    public static /* synthetic */ TCFConsentPayload copy$default(TCFConsentPayload tCFConsentPayload, boolean bl, Map map2, Map map3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = tCFConsentPayload.eea;
        }
        if ((n & 2) != 0) {
            map2 = tCFConsentPayload.purposes;
        }
        if ((n & 4) != 0) {
            map3 = tCFConsentPayload.vendors;
        }
        return tCFConsentPayload.copy(bl, map2, map3);
    }

    @NotNull
    public String toString() {
        return "TCFConsentPayload(eea=" + this.eea + ", purposes=" + this.purposes + ", vendors=" + this.vendors + ')';
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.eea);
        result = result * 31 + ((Object)this.purposes).hashCode();
        result = result * 31 + ((Object)this.vendors).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TCFConsentPayload)) {
            return false;
        }
        TCFConsentPayload tCFConsentPayload = (TCFConsentPayload)other;
        if (this.eea != tCFConsentPayload.eea) {
            return false;
        }
        if (!Intrinsics.areEqual(this.purposes, tCFConsentPayload.purposes)) {
            return false;
        }
        return Intrinsics.areEqual(this.vendors, tCFConsentPayload.vendors);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/usercentrics/sdk/mediation/data/TCFConsentPayload$Companion;", "", "()V", "valueAwareOfToggleVisibility", "", "consent", "showToggle", "(Ljava/lang/Boolean;Z)Ljava/lang/Boolean;", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Boolean valueAwareOfToggleVisibility(Boolean consent, boolean showToggle) {
            if (showToggle) {
                return consent;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

