/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.facade;

import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.mediation.data.ConsentApplied;
import com.usercentrics.sdk.mediation.data.ConsentApplyResult;
import com.usercentrics.sdk.mediation.data.ConsentMediationPayload;
import com.usercentrics.sdk.mediation.data.MediationResultPayload;
import com.usercentrics.sdk.mediation.data.MediationResultPayloadDTO;
import com.usercentrics.sdk.mediation.facade.IMediationFacade;
import com.usercentrics.sdk.mediation.service.IMediationService;
import com.usercentrics.sdk.v2.settings.data.UsercentricsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/usercentrics/sdk/mediation/facade/MediationFacade;", "Lcom/usercentrics/sdk/mediation/facade/IMediationFacade;", "mediationService", "Lcom/usercentrics/sdk/mediation/service/IMediationService;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "(Lcom/usercentrics/sdk/mediation/service/IMediationService;Lcom/usercentrics/sdk/log/UsercentricsLogger;)V", "logInitialState", "", "services", "", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsService;", "mediateConsents", "Lcom/usercentrics/sdk/mediation/data/MediationResultPayload;", "consentMediationPayload", "Lcom/usercentrics/sdk/mediation/data/ConsentMediationPayload;", "mediationLogMessage", "", "applyResult", "Lcom/usercentrics/sdk/mediation/data/ConsentApplyResult;", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMediationFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediationFacade.kt\ncom/usercentrics/sdk/mediation/facade/MediationFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1855#2,2:68\n1855#2,2:70\n1549#2:72\n1620#2,3:73\n*S KotlinDebug\n*F\n+ 1 MediationFacade.kt\ncom/usercentrics/sdk/mediation/facade/MediationFacade\n*L\n23#1:68,2\n36#1:70,2\n42#1:72\n42#1:73,3\n*E\n"})
public final class MediationFacade
implements IMediationFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMediationService mediationService;
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private static final String MEDIATION_TAG = "[Mediation]";

    public MediationFacade(@NotNull IMediationService mediationService, @NotNull UsercentricsLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)mediationService, (String)"mediationService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.mediationService = mediationService;
        this.logger = logger2;
    }

    @Override
    public void logInitialState(@NotNull List<UsercentricsService> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, "Consent Mediation is Enabled", null, 2, null);
        List servicesNamesSupported = new ArrayList();
        Iterable $this$forEach$iv = services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String templateId;
            UsercentricsService service = (UsercentricsService)element$iv;
            boolean bl = false;
            if (service.getTemplateId() == null || !this.mediationService.isSDKSupported(templateId)) continue;
            String string = service.getDataProcessor();
            if (string == null) {
                string = "";
            }
            servicesNamesSupported.add(string);
        }
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, "[Mediation] " + servicesNamesSupported.size() + '/' + services.size() + " Services are supported: " + CollectionsKt.joinToString$default((Iterable)servicesNamesSupported, (CharSequence)" | ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MediationResultPayload mediateConsents(@NotNull ConsentMediationPayload consentMediationPayload) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)consentMediationPayload, (String)"consentMediationPayload");
        MediationResultPayloadDTO result = this.mediationService.applyConsents(consentMediationPayload);
        Iterable $this$forEach$iv = result.getApplied();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsentApplyResult it = (ConsentApplyResult)element$iv;
            boolean bl = false;
            String message = this.mediationLogMessage(it);
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, message, null, 2, null);
        }
        Iterable $this$map$iv = result.getApplied();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConsentApplyResult consentApplyResult = (ConsentApplyResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            String string2 = it.getTemplateId();
            if (string2 == null) {
                string2 = "";
            }
            Boolean bl2 = it.getConsent();
            collection.add(new ConsentApplied(string, string2, bl2 != null ? bl2 : false, it.getMediated()));
        }
        List list = (List)destination$iv$iv;
        return new MediationResultPayload(list);
    }

    private final String mediationLogMessage(ConsentApplyResult applyResult) {
        boolean hasGranularConsent;
        boolean bl = hasGranularConsent = applyResult.getGranularConsent() != null;
        if (!applyResult.getMediated()) {
            return "[Mediation] " + applyResult.getName() + " - Unable to pass" + (hasGranularConsent ? "Granular" : "") + " consent. Please, report this issue to Usercentrics. https://usercentricssupport.zendesk.com/hc/en-us/requests/new";
        }
        if (hasGranularConsent) {
            return "[Mediation] Applied Granular Consent to " + applyResult.getName() + " - " + applyResult.getGranularConsent();
        }
        StringBuilder stringBuilder = new StringBuilder().append("[Mediation] Applied ").append(applyResult.getName()).append(" - Consent is ");
        String string = String.valueOf(applyResult.getConsent()).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return stringBuilder.append(string).toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/mediation/facade/MediationFacade$Companion;", "", "()V", "MEDIATION_TAG", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

