/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.service;

import com.usercentrics.sdk.mediation.MediationSDK;
import com.usercentrics.sdk.mediation.data.AdjustMediationResult;
import com.usercentrics.sdk.mediation.data.ConsentApplyResult;
import com.usercentrics.sdk.mediation.data.ConsentMediationPayload;
import com.usercentrics.sdk.mediation.data.MediationGranularConsent;
import com.usercentrics.sdk.mediation.data.MediationResultPayloadDTO;
import com.usercentrics.sdk.mediation.data.TCFConsentPayload;
import com.usercentrics.sdk.mediation.sdk.AdjustMediation;
import com.usercentrics.sdk.mediation.service.IMediationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001f\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/usercentrics/sdk/mediation/service/MediationService;", "Lcom/usercentrics/sdk/mediation/service/IMediationService;", "sdks", "", "", "Lcom/usercentrics/sdk/mediation/MediationSDK;", "granularSDKs", "", "adjust", "Lcom/usercentrics/sdk/mediation/sdk/AdjustMediation;", "(Ljava/util/Map;Ljava/util/List;Lcom/usercentrics/sdk/mediation/sdk/AdjustMediation;)V", "applyConsents", "Lcom/usercentrics/sdk/mediation/data/MediationResultPayloadDTO;", "payload", "Lcom/usercentrics/sdk/mediation/data/ConsentMediationPayload;", "isSDKSupported", "", "templateId", "mediateDPSConsents", "Lcom/usercentrics/sdk/mediation/data/ConsentApplyResult;", "adjustInDPSList", "mediateGranularConsents", "tcfPayload", "Lcom/usercentrics/sdk/mediation/data/TCFConsentPayload;", "serviceConsentValue", "ccpaOptedOut", "serviceConsent", "(Ljava/lang/Boolean;Z)Z", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMediationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediationService.kt\ncom/usercentrics/sdk/mediation/service/MediationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,90:1\n1855#2,2:91\n215#3,2:93\n*S KotlinDebug\n*F\n+ 1 MediationService.kt\ncom/usercentrics/sdk/mediation/service/MediationService\n*L\n39#1:91,2\n62#1:93,2\n*E\n"})
public final class MediationService
implements IMediationService {
    @NotNull
    private final Map<String, MediationSDK> sdks;
    @NotNull
    private final List<MediationSDK> granularSDKs;
    @NotNull
    private final AdjustMediation adjust;

    public MediationService(@NotNull Map<String, ? extends MediationSDK> sdks, @NotNull List<? extends MediationSDK> granularSDKs, @NotNull AdjustMediation adjust) {
        Intrinsics.checkNotNullParameter(sdks, (String)"sdks");
        Intrinsics.checkNotNullParameter(granularSDKs, (String)"granularSDKs");
        Intrinsics.checkNotNullParameter((Object)adjust, (String)"adjust");
        this.sdks = sdks;
        this.granularSDKs = granularSDKs;
        this.adjust = adjust;
    }

    public /* synthetic */ MediationService(Map map2, List list, AdjustMediation adjustMediation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(map2, list, adjustMediation);
    }

    @Override
    public boolean isSDKSupported(@NotNull String templateId) {
        Intrinsics.checkNotNullParameter((Object)templateId, (String)"templateId");
        return this.sdks.containsKey(templateId) || Intrinsics.areEqual((Object)this.adjust.getTemplateId(), (Object)templateId);
    }

    @Override
    @NotNull
    public MediationResultPayloadDTO applyConsents(@NotNull ConsentMediationPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        List applied = new ArrayList();
        Set<String> consentedTemplateIds = payload.getDps().keySet();
        boolean isAdjustInDPSList = this.adjust.isAvailable(consentedTemplateIds);
        if (payload.getTcf() != null) {
            applied.addAll((Collection)this.mediateGranularConsents(isAdjustInDPSList, payload.getTcf()));
        }
        applied.addAll((Collection)this.mediateDPSConsents(isAdjustInDPSList, payload));
        return new MediationResultPayloadDTO(applied);
    }

    private final List<ConsentApplyResult> mediateGranularConsents(boolean adjustInDPSList, TCFConsentPayload tcfPayload) {
        List applied = new ArrayList();
        Set vendorsAppliedInAdjust = new LinkedHashSet();
        Iterable $this$forEach$iv = this.granularSDKs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MediationGranularConsent granularConsent;
            MediationSDK mediationSDK = (MediationSDK)element$iv;
            boolean bl = false;
            Integer n = mediationSDK.getVendorId();
            if (n == null) {
                continue;
            }
            int vendorId = n;
            if (tcfPayload.buildGranularConsent(vendorId) == null) continue;
            boolean mediated = mediationSDK.applyGranular(granularConsent);
            applied.add(new ConsentApplyResult(mediationSDK.getName() + " (Granular Signal)", mediated, null, null, granularConsent, 12, null));
            if (!adjustInDPSList || vendorsAppliedInAdjust.contains(vendorId)) continue;
            boolean signaledToAdjust = this.adjust.signalGranularConsent(vendorId, granularConsent);
            applied.add(new ConsentApplyResult(mediationSDK.getName() + " (Adjust Signal)", signaledToAdjust, null, null, granularConsent, 12, null));
            vendorsAppliedInAdjust.add(vendorId);
        }
        return applied;
    }

    private final List<ConsentApplyResult> mediateDPSConsents(boolean adjustInDPSList, ConsentMediationPayload payload) {
        List results = new ArrayList();
        Map<String, Boolean> $this$forEach$iv = payload.getDps();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Boolean>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            MediationSDK mediationSDK;
            Map.Entry<String, Boolean> element$iv;
            Map.Entry<String, Boolean> dpsConsent = element$iv = iterator2.next();
            boolean bl = false;
            String templateId = dpsConsent.getKey();
            boolean consent = this.serviceConsentValue(payload.getCcpaOptedOut(), dpsConsent.getValue());
            if (adjustInDPSList && this.adjust.canMediate(templateId)) {
                AdjustMediationResult adjustSettings = this.adjust.apply(templateId, consent);
                String string = adjustSettings.getName();
                boolean bl2 = adjustSettings.getMediated();
                results.add(new ConsentApplyResult(string, bl2, templateId, consent, null, 16, null));
                continue;
            }
            if (this.sdks.get(templateId) == null) continue;
            boolean mediated = mediationSDK.apply(consent, payload.getCcpaOptedOut() != null);
            String string = mediationSDK.getName();
            results.add(new ConsentApplyResult(string, mediated, templateId, consent, null, 16, null));
        }
        return results;
    }

    private final boolean serviceConsentValue(Boolean ccpaOptedOut, boolean serviceConsent) {
        if (ccpaOptedOut == null) {
            return serviceConsent;
        }
        if (serviceConsent) {
            return true;
        }
        return ccpaOptedOut == false;
    }
}

