/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.ccpa;

import com.usercentrics.ccpa.CCPAData;
import com.usercentrics.ccpa.CcpaApi;
import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.services.ccpa.ICcpa;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0017\u0010\u0018\u001a\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0019H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/usercentrics/sdk/services/ccpa/Ccpa;", "Lcom/usercentrics/sdk/services/ccpa/ICcpa;", "storage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "(Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/log/UsercentricsLogger;)V", "ccpaInstance", "Lcom/usercentrics/ccpa/CcpaApi;", "ccpaVersion", "", "iabAgreementExists", "", "getIabAgreementExists", "()Ljava/lang/Boolean;", "setIabAgreementExists", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "isOptedOut", "setOptedOut", "getCCPAData", "Lcom/usercentrics/ccpa/CCPAData;", "getCCPADataAsString", "", "initialize", "", "setCcpaStorage", "isNoticeGiven", "(ZLjava/lang/Boolean;)V", "setNotApplicable", "usercentrics_release"})
public final class Ccpa
implements ICcpa {
    @NotNull
    private final DeviceStorage storage;
    @NotNull
    private final UsercentricsLogger logger;
    private final int ccpaVersion;
    @Nullable
    private Boolean isOptedOut;
    @Nullable
    private Boolean iabAgreementExists;
    @NotNull
    private final CcpaApi ccpaInstance;

    public Ccpa(@NotNull DeviceStorage storage, @NotNull UsercentricsLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.storage = storage;
        this.logger = logger2;
        this.ccpaVersion = 1;
        this.ccpaInstance = new CcpaApi(this.storage.toCcpaStorage(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Ccpa this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String debugMsg) {
                Intrinsics.checkNotNullParameter((Object)debugMsg, (String)"debugMsg");
                UsercentricsLogger.DefaultImpls.debug$default(Ccpa.access$getLogger$p(this.this$0), debugMsg, null, 2, null);
            }
        }));
    }

    @Nullable
    public final Boolean isOptedOut() {
        return this.isOptedOut;
    }

    public final void setOptedOut(@Nullable Boolean bl) {
        this.isOptedOut = bl;
    }

    @Nullable
    public final Boolean getIabAgreementExists() {
        return this.iabAgreementExists;
    }

    public final void setIabAgreementExists(@Nullable Boolean bl) {
        this.iabAgreementExists = bl;
    }

    @Override
    public void initialize(@Nullable Boolean iabAgreementExists) {
        this.iabAgreementExists = iabAgreementExists;
        CCPAData uspData = this.getCCPAData();
        this.isOptedOut = uspData.getOptedOut();
    }

    @Override
    @NotNull
    public CCPAData getCCPAData() {
        return this.ccpaInstance.getPrivacyData(this.ccpaVersion);
    }

    @Override
    @NotNull
    public String getCCPADataAsString() {
        return this.ccpaInstance.getPrivacyDataAsString(this.ccpaVersion);
    }

    @Override
    public void setCcpaStorage(boolean isOptedOut, @Nullable Boolean isNoticeGiven) {
        this.isOptedOut = isOptedOut;
        this.storage.setCcpaTimestampInMillis(new DateTime().timestamp());
        CCPAData ccpaData = new CCPAData(this.ccpaVersion, isNoticeGiven, isOptedOut, this.iabAgreementExists);
        this.ccpaInstance.setPrivacyData(this.ccpaVersion, ccpaData);
    }

    @Override
    public void setNotApplicable() {
        this.isOptedOut = null;
        this.storage.setCcpaTimestampInMillis(0L);
        CCPAData ccpaData = new CCPAData(this.ccpaVersion, null, null, null);
        this.ccpaInstance.setPrivacyData(this.ccpaVersion, ccpaData);
    }

    public static final /* synthetic */ UsercentricsLogger access$getLogger$p(Ccpa $this) {
        return $this.logger;
    }
}

