/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage;

import android.content.SharedPreferences;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0016J!\u0010\u0018\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00140\u001aH\u0017\u00a2\u0006\u0002\b\u001bJ!\u0010\u0018\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001aH\u0017\u00a2\u0006\u0002\b\u001cJ\u001c\u0010\u001d\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/SharedPreferencesKeyValueStorage;", "Lcom/usercentrics/sdk/services/deviceStorage/KeyValueStorage;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "deleteAll", "", "deleteKey", "key", "", "deleteKeysThatDoNotMatch", "pattern", "values", "", "getBoolean", "", "defaultValue", "getLong", "", "getNumber", "", "getString", "hasKey", "purgeStorage", "put", "value", "", "putIntegerMap", "putStringMap", "putValuesMap", "", "usercentrics_release"})
public final class SharedPreferencesKeyValueStorage
implements KeyValueStorage {
    @NotNull
    private final SharedPreferences sharedPreferences;

    public SharedPreferencesKeyValueStorage(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    public void deleteKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().remove(key).apply();
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getString(key, defaultValue);
    }

    @Override
    public int getNumber(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getInt(key, defaultValue);
    }

    @Override
    public long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getLong(key, defaultValue);
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.getBoolean(key, defaultValue);
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.sharedPreferences.edit().putString(key, value).apply();
    }

    @Override
    public void put(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().putInt(key, value).apply();
    }

    @Override
    public void put(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().putLong(key, value).apply();
    }

    @Override
    public void put(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.sharedPreferences.edit().putBoolean(key, value).apply();
    }

    @Override
    public boolean hasKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.sharedPreferences.contains(key);
    }

    @Override
    public void purgeStorage() {
    }

    @Override
    @JvmName(name="putStringMap")
    public void putStringMap(@NotNull Map<String, String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.putValuesMap(values);
    }

    @Override
    @JvmName(name="putIntegerMap")
    public void putIntegerMap(@NotNull Map<String, Integer> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.putValuesMap(values);
    }

    @Override
    public void putValuesMap(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                editor.putString(entry.getKey(), (String)value);
                continue;
            }
            if (value instanceof Integer) {
                editor.putInt(entry.getKey(), ((Number)value).intValue());
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            editor.putBoolean(entry.getKey(), ((Boolean)value).booleanValue());
        }
        editor.apply();
    }

    @Override
    public void deleteKeysThatDoNotMatch(@NotNull String pattern, @NotNull Set<String> values) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (String key : this.sharedPreferences.getAll().keySet()) {
            Intrinsics.checkNotNull((Object)key);
            if (!StringsKt.startsWith$default((String)key, (String)pattern, (boolean)false, (int)2, null) || values.contains(StringsKt.removePrefix((String)key, (CharSequence)pattern))) continue;
            editor.remove(key);
        }
        editor.apply();
    }

    @Override
    public void deleteAll() {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        for (String key : this.sharedPreferences.getAll().keySet()) {
            editor.remove(key);
        }
        editor.apply();
    }
}

