/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.initialValues.variants;

import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.InitialView;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.initialValues.variants.TCFStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u001f\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/usercentrics/sdk/services/initialValues/variants/TCFStrategyImpl;", "Lcom/usercentrics/sdk/services/initialValues/variants/TCFStrategy;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "deviceStorage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;)V", "getInitialView", "Lcom/usercentrics/sdk/models/common/InitialView;", "resurfacePurposeChanged", "", "resurfaceVendorAdded", "versionChangeRequiresReshow", "noGDPRConsentActionPerformed", "resurfacePeriodEnded", "settingsTCFPolicyVersion", "", "storedTcStringPolicyVersion", "resurfaceATPChanged", "lastServiceInteractionTimestamp", "", "()Ljava/lang/Long;", "shouldAcceptAllImplicitlyOnInit", "gdprAppliesOnTCF", "timeToReshowHasPassed", "reshowCMP", "lastTimestamp", "(ZLjava/lang/Long;)Z", "usercentrics_release"})
public final class TCFStrategyImpl
implements TCFStrategy {
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final DeviceStorage deviceStorage;

    public TCFStrategyImpl(@NotNull UsercentricsLogger logger2, @NotNull DeviceStorage deviceStorage) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)deviceStorage, (String)"deviceStorage");
        this.logger = logger2;
        this.deviceStorage = deviceStorage;
    }

    @Override
    public boolean shouldAcceptAllImplicitlyOnInit(boolean gdprAppliesOnTCF) {
        return !gdprAppliesOnTCF;
    }

    @Override
    @NotNull
    public InitialView getInitialView(boolean resurfacePurposeChanged, boolean resurfaceVendorAdded, boolean versionChangeRequiresReshow, boolean noGDPRConsentActionPerformed, boolean resurfacePeriodEnded, int settingsTCFPolicyVersion, int storedTcStringPolicyVersion, boolean resurfaceATPChanged) {
        InitialView initialView;
        boolean tcStringOnPolicyVersion2AndSettingsOnPolicyVersion4 = storedTcStringPolicyVersion == 2 && settingsTCFPolicyVersion == 4;
        boolean noChangesMadeOnVendorsList = !resurfacePurposeChanged && !resurfaceVendorAdded;
        if (tcStringOnPolicyVersion2AndSettingsOnPolicyVersion4 && versionChangeRequiresReshow && noChangesMadeOnVendorsList) {
            initialView = InitialView.NONE;
        } else if (versionChangeRequiresReshow) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: Settings version has changed", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (noGDPRConsentActionPerformed) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [TCF] This user has not yet provided consent (not even on GDPR services)", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (resurfacePurposeChanged) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [TCF] The 'Resurface UI' option is enabled and selected vendors include undisclosed or changes in their declared Legal Basis", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (resurfaceVendorAdded) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [TCF] The 'Resurface UI' option is enabled and a new vendor was added from the GVL", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (this.timeToReshowHasPassed(resurfacePeriodEnded, this.lastServiceInteractionTimestamp())) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [TCF] The 'Resurface UI' option is enabled configured time has passed", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (resurfaceATPChanged) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [TCF] The 'Resurface ATP list' option is enabled and Ad Technology Providers changed", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else {
            initialView = InitialView.NONE;
        }
        return initialView;
    }

    private final Long lastServiceInteractionTimestamp() {
        return this.deviceStorage.tcfServiceLastInteractionTimestamp();
    }

    private final boolean timeToReshowHasPassed(boolean reshowCMP, Long lastTimestamp) {
        if (!reshowCMP || lastTimestamp == null) {
            return false;
        }
        DateTime currentDateTime = new DateTime();
        DateTime lastInteractionDateTime = new DateTime(lastTimestamp);
        int daysSinceLastInteraction = currentDateTime.diffInDays(lastInteractionDateTime);
        return daysSinceLastInteraction >= 390;
    }
}

