/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.analytics.api;

import com.usercentrics.sdk.UsercentricsAnalyticsEventType;
import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.analytics.api.IAnalyticsApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/usercentrics/sdk/v2/analytics/api/AnalyticsApi;", "Lcom/usercentrics/sdk/v2/analytics/api/IAnalyticsApi;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "restClient", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "appId", "", "(Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Ljava/lang/String;)V", "buildUrl", "eventType", "Lcom/usercentrics/sdk/UsercentricsAnalyticsEventType;", "settingsId", "abTestingVariant", "cacheBuster", "report", "", "usercentrics_release"})
public final class AnalyticsApi
implements IAnalyticsApi {
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final HttpRequests restClient;
    @NotNull
    private final String appId;

    public AnalyticsApi(@NotNull NetworkResolver networkResolver2, @NotNull HttpRequests restClient, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.networkResolver = networkResolver2;
        this.restClient = restClient;
        this.appId = appId;
    }

    @Override
    public void report(@NotNull UsercentricsAnalyticsEventType eventType, @NotNull String settingsId, @Nullable String abTestingVariant, @NotNull String cacheBuster) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        Intrinsics.checkNotNullParameter((Object)cacheBuster, (String)"cacheBuster");
        String url = this.buildUrl(eventType, settingsId, abTestingVariant, cacheBuster);
        this.restClient.postSync(url, "", null);
    }

    private final String buildUrl(UsercentricsAnalyticsEventType eventType, String settingsId, String abTestingVariant, String cacheBuster) {
        String baseUrl = this.networkResolver.analyticsBaseUrl();
        StringBuilder stringBuilder = new StringBuilder().append(baseUrl).append("/uct?v=1&sid=").append(settingsId).append("&t=").append(eventType.getValue()).append("&r=").append(this.appId).append("&abv=");
        String string = abTestingVariant;
        if (string == null) {
            string = "";
        }
        return stringBuilder.append(string).append("&cb=").append(cacheBuster).toString();
    }
}

