/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo;

import com.usercentrics.sdk.CommonKt;
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent;
import com.usercentrics.sdk.models.settings.PredefinedUIServiceContentSection;
import com.usercentrics.sdk.models.settings.PredefinedUIStorageInformationButtonInfo;
import com.usercentrics.sdk.models.settings.PredefinedUIStorageInformationServiceContent;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.DeviceStorageMapper;
import com.usercentrics.sdk.v2.banner.service.mapper.tcf.storageinfo.TCFStorageInformationHolder;
import com.usercentrics.sdk.v2.settings.data.ConsentDisclosureObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/storageinfo/TCFStorageInformationMapper;", "", "holder", "Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/storageinfo/TCFStorageInformationHolder;", "showShortDescription", "", "(Lcom/usercentrics/sdk/v2/banner/service/mapper/tcf/storageinfo/TCFStorageInformationHolder;Z)V", "appendCookiesInformation", "", "content", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "map", "Lcom/usercentrics/sdk/models/settings/PredefinedUIServiceContentSection;", "mapDeviceStorageContent", "", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDeviceStorageContent;", "deviceStorage", "Lcom/usercentrics/sdk/v2/settings/data/ConsentDisclosureObject;", "storageInformationButtonInfo", "Lcom/usercentrics/sdk/models/settings/PredefinedUIStorageInformationButtonInfo;", "usercentrics_release"})
public final class TCFStorageInformationMapper {
    @NotNull
    private final TCFStorageInformationHolder holder;
    private final boolean showShortDescription;

    public TCFStorageInformationMapper(@NotNull TCFStorageInformationHolder holder, boolean showShortDescription) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
        this.showShortDescription = showShortDescription;
    }

    @NotNull
    public final PredefinedUIServiceContentSection map() {
        Boolean usesCookies;
        StringBuilder content2 = new StringBuilder();
        if (this.showShortDescription) {
            content2.append(this.holder.getCookieInformationLabels().getStorageInformationDescription());
            content2.append("\n\n");
        }
        Boolean bl = usesCookies = this.holder.getUsesCookies();
        if (bl != null) {
            boolean it = bl;
            boolean bl2 = false;
            String cookieStorage = it ? this.holder.getCookieInformationLabels().getYes() : this.holder.getCookieInformationLabels().getNo();
            content2.append("\u2022 " + this.holder.getCookieInformationLabels().getCookieStorage() + ": " + cookieStorage + '\n');
        }
        this.appendCookiesInformation(content2);
        String nonCookieStorage = Intrinsics.areEqual((Object)this.holder.getUsesNonCookieAccess(), (Object)true) ? this.holder.getCookieInformationLabels().getYes() : this.holder.getCookieInformationLabels().getNo();
        content2.append("\u2022 " + this.holder.getCookieInformationLabels().getNonCookieStorage() + ": " + nonCookieStorage);
        String string = this.holder.getCookieInformationLabels().getTitle();
        String string2 = content2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new PredefinedUIServiceContentSection(string, new PredefinedUIStorageInformationServiceContent(string2, this.storageInformationButtonInfo()));
    }

    private final void appendCookiesInformation(StringBuilder content2) {
        Boolean cookieRefresh;
        Long cookieMaxAgeInSeconds = this.holder.getCookieMaxAgeSeconds();
        if (cookieMaxAgeInSeconds != null) {
            String cookieAge = this.holder.getCookieInformationLabels().cookieMaxAgeLabel(cookieMaxAgeInSeconds.longValue());
            content2.append("\u2022 " + this.holder.getCookieInformationLabels().getMaximumAge() + ": " + cookieAge);
            content2.append("\n");
        }
        if ((cookieRefresh = this.holder.getCookieRefresh()) != null) {
            String cookieRefreshLabel = cookieRefresh != false ? this.holder.getCookieInformationLabels().getYes() : this.holder.getCookieInformationLabels().getNo();
            content2.append("\u2022 " + this.holder.getCookieInformationLabels().getCookieRefresh() + ": " + cookieRefreshLabel);
            content2.append("\n");
        }
    }

    private final PredefinedUIStorageInformationButtonInfo storageInformationButtonInfo() {
        boolean hideStorageInfoButton;
        CharSequence charSequence;
        ConsentDisclosureObject deviceStorage = this.holder.getDeviceStorage();
        String string = this.holder.getDeviceStorageDisclosureUrl();
        String deviceStorageDisclosureUrl = string != null ? CommonKt.forceHttps(string) : null;
        Object object = deviceStorage;
        boolean bl = (object != null && (object = ((ConsentDisclosureObject)object).getDisclosures()) != null ? object.isEmpty() : true) && ((charSequence = (CharSequence)deviceStorageDisclosureUrl) == null || StringsKt.isBlank((CharSequence)charSequence)) ? true : (hideStorageInfoButton = false);
        if (hideStorageInfoButton) {
            return null;
        }
        return new PredefinedUIStorageInformationButtonInfo(this.holder.getCookieInformationLabels().getTitleDetailed(), deviceStorageDisclosureUrl, this.mapDeviceStorageContent(deviceStorage));
    }

    private final List<PredefinedUIDeviceStorageContent> mapDeviceStorageContent(ConsentDisclosureObject deviceStorage) {
        if (deviceStorage == null) {
            return null;
        }
        return new DeviceStorageMapper(deviceStorage, this.holder.getCookieInformationLabels(), MapsKt.emptyMap()).map();
    }
}

