/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.consent.api;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.core.settings.SettingsOrchestrator;
import com.usercentrics.sdk.domain.api.http.HttpErrorResponse;
import com.usercentrics.sdk.domain.api.http.HttpRequests;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.services.api.NetworkResolver;
import com.usercentrics.sdk.v2.consent.api.GetConsentsApi;
import com.usercentrics.sdk.v2.consent.api.GetConsentsApiImplKt;
import com.usercentrics.sdk.v2.consent.data.ConsentsDataDto;
import com.usercentrics.sdk.v2.consent.data.GetConsentsData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0002J8\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100\u00142\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J8\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00100\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/usercentrics/sdk/v2/consent/api/GetConsentsApiImpl;", "Lcom/usercentrics/sdk/v2/consent/api/GetConsentsApi;", "requests", "Lcom/usercentrics/sdk/domain/api/http/HttpRequests;", "networkResolver", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "settingsOrchestrator", "Lcom/usercentrics/sdk/core/settings/SettingsOrchestrator;", "(Lcom/usercentrics/sdk/domain/api/http/HttpRequests;Lcom/usercentrics/sdk/services/api/NetworkResolver;Lcom/usercentrics/sdk/core/json/JsonParser;Lcom/usercentrics/sdk/core/settings/SettingsOrchestrator;)V", "createUrl", "", "settingsId", "controllerId", "errorResponse", "", "httpResponse", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "onError", "Lkotlin/Function1;", "Lcom/usercentrics/sdk/errors/UsercentricsException;", "getUserConsents", "onSuccess", "Lcom/usercentrics/sdk/v2/consent/data/GetConsentsData;", "onResponse", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nGetConsentsApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetConsentsApiImpl.kt\ncom/usercentrics/sdk/v2/consent/api/GetConsentsApiImpl\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n*L\n1#1,74:1\n28#2:75\n28#2:76\n*S KotlinDebug\n*F\n+ 1 GetConsentsApiImpl.kt\ncom/usercentrics/sdk/v2/consent/api/GetConsentsApiImpl\n*L\n43#1:75\n48#1:76\n*E\n"})
public final class GetConsentsApiImpl
implements GetConsentsApi {
    @NotNull
    private final HttpRequests requests;
    @NotNull
    private final NetworkResolver networkResolver;
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final SettingsOrchestrator settingsOrchestrator;

    public GetConsentsApiImpl(@NotNull HttpRequests requests, @NotNull NetworkResolver networkResolver2, @NotNull JsonParser jsonParser, @NotNull SettingsOrchestrator settingsOrchestrator2) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Intrinsics.checkNotNullParameter((Object)networkResolver2, (String)"networkResolver");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)settingsOrchestrator2, (String)"settingsOrchestrator");
        this.requests = requests;
        this.networkResolver = networkResolver2;
        this.jsonParser = jsonParser;
        this.settingsOrchestrator = settingsOrchestrator2;
    }

    @Override
    public void getUserConsents(@NotNull String controllerId, @NotNull Function1<? super GetConsentsData, Unit> onSuccess2, @NotNull Function1<? super UsercentricsException, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.settingsOrchestrator.getSettingsIdObservable().subscribe((Function1<String, Unit>)((Function1)new Function1<String, Unit>(this, controllerId, onError2, onSuccess2){
            final /* synthetic */ GetConsentsApiImpl this$0;
            final /* synthetic */ String $controllerId;
            final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
            final /* synthetic */ Function1<GetConsentsData, Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$controllerId = $controllerId;
                this.$onError = $onError;
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull String settingsId) {
                Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
                GetConsentsApiImpl.access$getRequests$p(this.this$0).get(GetConsentsApiImpl.access$createUrl(this.this$0, settingsId, this.$controllerId), null, (Function1<? super HttpResponse, Unit>)((Function1)new Function1<HttpResponse, Unit>(this.this$0, this.$onError, this.$onSuccess){
                    final /* synthetic */ GetConsentsApiImpl this$0;
                    final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
                    final /* synthetic */ Function1<GetConsentsData, Unit> $onSuccess;
                    {
                        this.this$0 = $receiver;
                        this.$onError = $onError;
                        this.$onSuccess = $onSuccess;
                        super(1);
                    }

                    public final void invoke(@NotNull HttpResponse httpResponse) {
                        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
                        GetConsentsApiImpl.access$onResponse(this.this$0, httpResponse, this.$onError, this.$onSuccess);
                    }
                }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$onError){
                    final /* synthetic */ Function1<UsercentricsException, Unit> $onError;
                    {
                        this.$onError = $onError;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$onError.invoke((Object)new UsercentricsException("Failed to get user consents: " + it.getMessage(), it));
                    }
                }));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void onResponse(HttpResponse httpResponse, Function1<? super UsercentricsException, Unit> onError2, Function1<? super GetConsentsData, Unit> onSuccess2) {
        void deserializer$iv;
        if (httpResponse.getStatusCode() != 200) {
            this.errorResponse(httpResponse, onError2);
            return;
        }
        JsonParser jsonParser = this.jsonParser;
        DeserializationStrategy deserializationStrategy = (DeserializationStrategy)ConsentsDataDto.Companion.serializer();
        String str$iv = httpResponse.getBody();
        boolean $i$f$decodeFromString = false;
        ConsentsDataDto response2 = (ConsentsDataDto)JsonParserKt.access$getJson$p().decodeFromString((DeserializationStrategy)deserializer$iv, str$iv);
        onSuccess2.invoke((Object)GetConsentsApiImplKt.mapToGetConsentsData(response2, this.jsonParser));
    }

    /*
     * WARNING - void declaration
     */
    private final void errorResponse(HttpResponse httpResponse, Function1<? super UsercentricsException, Unit> onError2) {
        void deserializer$iv;
        JsonParser jsonParser = this.jsonParser;
        DeserializationStrategy deserializationStrategy = (DeserializationStrategy)HttpErrorResponse.Companion.serializer();
        String str$iv = httpResponse.getBody();
        boolean $i$f$decodeFromString = false;
        HttpErrorResponse response2 = (HttpErrorResponse)JsonParserKt.access$getJson$p().decodeFromString((DeserializationStrategy)deserializer$iv, str$iv);
        String string = response2.getMessage();
        if (string == null) {
            string = "";
        }
        onError2.invoke((Object)new UsercentricsException(string, null, 2, null));
    }

    private final String createUrl(String settingsId, String controllerId) {
        return this.networkResolver.getConsentsBaseUrl() + "/?settingsId=" + settingsId + "&controllerId=" + controllerId;
    }

    public static final /* synthetic */ HttpRequests access$getRequests$p(GetConsentsApiImpl $this) {
        return $this.requests;
    }

    public static final /* synthetic */ String access$createUrl(GetConsentsApiImpl $this, String settingsId, String controllerId) {
        return $this.createUrl(settingsId, controllerId);
    }

    public static final /* synthetic */ void access$onResponse(GetConsentsApiImpl $this, HttpResponse httpResponse, Function1 onError2, Function1 onSuccess2) {
        $this.onResponse(httpResponse, (Function1<? super UsercentricsException, Unit>)onError2, (Function1<? super GetConsentsData, Unit>)onSuccess2);
    }
}

