/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.consent.service;

import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.settings.UsercentricsConsentAction;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.deviceStorage.models.ConsentsBuffer;
import com.usercentrics.sdk.services.deviceStorage.models.ConsentsBufferEntry;
import com.usercentrics.sdk.services.deviceStorage.models.StorageTCF;
import com.usercentrics.sdk.services.settings.ISettingsLegacy;
import com.usercentrics.sdk.v2.async.dispatcher.Dispatcher;
import com.usercentrics.sdk.v2.async.dispatcher.DispatcherScope;
import com.usercentrics.sdk.v2.consent.api.GetConsentsApi;
import com.usercentrics.sdk.v2.consent.api.SaveConsentsApi;
import com.usercentrics.sdk.v2.consent.data.ConsentStringObject;
import com.usercentrics.sdk.v2.consent.data.DataTransferObject;
import com.usercentrics.sdk.v2.consent.data.GetConsentsData;
import com.usercentrics.sdk.v2.consent.data.SaveConsentsData;
import com.usercentrics.sdk.v2.consent.service.ConsentsService;
import com.usercentrics.sdk.v2.settings.data.NewSettingsData;
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings;
import com.usercentrics.sdk.v2.settings.service.ISettingsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J8\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001c0,2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001c0,H\u0016J\b\u00100\u001a\u00020\u001cH\u0016J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u00062"}, d2={"Lcom/usercentrics/sdk/v2/consent/service/ConsentsServiceImpl;", "Lcom/usercentrics/sdk/v2/consent/service/ConsentsService;", "dispatcher", "Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "getConsentsApi", "Lcom/usercentrics/sdk/v2/consent/api/GetConsentsApi;", "saveConsentsApi", "Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsApi;", "deviceStorage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "settingsService", "Lcom/usercentrics/sdk/v2/settings/service/ISettingsService;", "settingsLegacyInstance", "Lcom/usercentrics/sdk/services/settings/ISettingsLegacy;", "(Lcom/usercentrics/sdk/v2/async/dispatcher/Dispatcher;Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/v2/consent/api/GetConsentsApi;Lcom/usercentrics/sdk/v2/consent/api/SaveConsentsApi;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/v2/settings/service/ISettingsService;Lcom/usercentrics/sdk/services/settings/ISettingsLegacy;)V", "analyticsFlag", "", "getAnalyticsFlag", "()Z", "settings", "Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "getSettings", "()Lcom/usercentrics/sdk/v2/settings/data/UsercentricsSettings;", "xdeviceFlag", "getXdeviceFlag", "addConsentsToBuffer", "", "consentsData", "Lcom/usercentrics/sdk/v2/consent/data/SaveConsentsData;", "clearConsentsFromBuffer", "createConsentStringState", "Lcom/usercentrics/sdk/v2/consent/data/ConsentStringObject;", "createState", "cause", "Lcom/usercentrics/sdk/models/settings/UsercentricsConsentAction;", "createStateForGDPR", "createStateForTCF", "doSaveConsents", "getRemoteUserConsents", "controllerId", "", "onSuccess", "Lkotlin/Function1;", "Lcom/usercentrics/sdk/v2/consent/data/GetConsentsData;", "onError", "Lcom/usercentrics/sdk/errors/UsercentricsException;", "processConsentsBuffer", "saveConsentsState", "usercentrics_release"})
public final class ConsentsServiceImpl
implements ConsentsService {
    @NotNull
    private final Dispatcher dispatcher;
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final GetConsentsApi getConsentsApi;
    @NotNull
    private final SaveConsentsApi saveConsentsApi;
    @NotNull
    private final DeviceStorage deviceStorage;
    @NotNull
    private final ISettingsService settingsService;
    @NotNull
    private final ISettingsLegacy settingsLegacyInstance;

    public ConsentsServiceImpl(@NotNull Dispatcher dispatcher2, @NotNull UsercentricsLogger logger2, @NotNull GetConsentsApi getConsentsApi, @NotNull SaveConsentsApi saveConsentsApi, @NotNull DeviceStorage deviceStorage, @NotNull ISettingsService settingsService2, @NotNull ISettingsLegacy settingsLegacyInstance) {
        Intrinsics.checkNotNullParameter((Object)dispatcher2, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)getConsentsApi, (String)"getConsentsApi");
        Intrinsics.checkNotNullParameter((Object)saveConsentsApi, (String)"saveConsentsApi");
        Intrinsics.checkNotNullParameter((Object)deviceStorage, (String)"deviceStorage");
        Intrinsics.checkNotNullParameter((Object)settingsService2, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)settingsLegacyInstance, (String)"settingsLegacyInstance");
        this.dispatcher = dispatcher2;
        this.logger = logger2;
        this.getConsentsApi = getConsentsApi;
        this.saveConsentsApi = saveConsentsApi;
        this.deviceStorage = deviceStorage;
        this.settingsService = settingsService2;
        this.settingsLegacyInstance = settingsLegacyInstance;
    }

    private final UsercentricsSettings getSettings() {
        Object object = this.settingsService.getSettings();
        if (object == null || (object = ((NewSettingsData)object).getData()) == null) {
            throw new IllegalStateException("Consents Service requires a valid Settings state");
        }
        return object;
    }

    private final boolean getAnalyticsFlag() {
        return this.getSettings().getConsentAnalytics();
    }

    private final boolean getXdeviceFlag() {
        return this.getSettings().getConsentXDevice();
    }

    @Override
    public void getRemoteUserConsents(@NotNull String controllerId, @NotNull Function1<? super GetConsentsData, Unit> onSuccess2, @NotNull Function1<? super UsercentricsException, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.getConsentsApi.getUserConsents(controllerId, onSuccess2, onError2);
    }

    @Override
    public void saveConsentsState(@NotNull UsercentricsConsentAction cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, cause, null){
            int label;
            final /* synthetic */ ConsentsServiceImpl this$0;
            final /* synthetic */ UsercentricsConsentAction $cause;
            {
                this.this$0 = $receiver;
                this.$cause = $cause;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SaveConsentsData consentsData = ConsentsServiceImpl.access$createState(this.this$0, this.$cause);
                        ConsentsServiceImpl.access$doSaveConsents(this.this$0, consentsData);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void doSaveConsents(SaveConsentsData consentsData) {
        this.saveConsentsApi.saveConsents(consentsData, this.getAnalyticsFlag(), this.getXdeviceFlag(), (Function0<Unit>)((Function0)new Function0<Unit>(this, consentsData){
            final /* synthetic */ ConsentsServiceImpl this$0;
            final /* synthetic */ SaveConsentsData $consentsData;
            {
                this.this$0 = $receiver;
                this.$consentsData = $consentsData;
                super(0);
            }

            public final void invoke() {
                ConsentsServiceImpl.access$clearConsentsFromBuffer(this.this$0, this.$consentsData);
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, consentsData){
            final /* synthetic */ ConsentsServiceImpl this$0;
            final /* synthetic */ SaveConsentsData $consentsData;
            {
                this.this$0 = $receiver;
                this.$consentsData = $consentsData;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ConsentsServiceImpl.access$getLogger$p(this.this$0).error("Failed while trying to save consents", it);
                ConsentsServiceImpl.access$addConsentsToBuffer(this.this$0, this.$consentsData);
            }
        }));
    }

    private final SaveConsentsData createState(UsercentricsConsentAction cause) {
        return cause == UsercentricsConsentAction.TCF_STRING_CHANGE ? this.createStateForTCF(cause) : this.createStateForGDPR(cause);
    }

    private final SaveConsentsData createStateForGDPR(UsercentricsConsentAction cause) {
        DataTransferObject dataTransferObject = DataTransferObject.Companion.create$default(DataTransferObject.Companion, this.getSettings(), this.settingsLegacyInstance.getSettings().getControllerId(), this.settingsLegacyInstance.getSettings().getServices(), cause, cause.getType(), null, 32, null);
        return new SaveConsentsData(dataTransferObject, null, null, 4, null);
    }

    private final SaveConsentsData createStateForTCF(UsercentricsConsentAction cause) {
        DataTransferObject dataTransferObject = DataTransferObject.Companion.create$default(DataTransferObject.Companion, this.getSettings(), this.settingsLegacyInstance.getSettings().getControllerId(), CollectionsKt.emptyList(), cause, cause.getType(), null, 32, null);
        String acString = this.deviceStorage.getACString();
        return new SaveConsentsData(dataTransferObject, this.createConsentStringState(), acString);
    }

    private final ConsentStringObject createConsentStringState() {
        StorageTCF tcfData = this.deviceStorage.getTCFData();
        String tcString = tcfData.getTcString();
        if (!StringsKt.isBlank((CharSequence)tcString)) {
            return new ConsentStringObject(tcString, tcfData.getVendorsDisclosedMap());
        }
        String uspString = this.deviceStorage.fetchCcpaString();
        if (!StringsKt.isBlank((CharSequence)uspString)) {
            return new ConsentStringObject(uspString, null, 2, null);
        }
        return null;
    }

    private final void clearConsentsFromBuffer(SaveConsentsData consentsData) {
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, consentsData, null){
            int label;
            final /* synthetic */ ConsentsServiceImpl this$0;
            final /* synthetic */ SaveConsentsData $consentsData;
            {
                this.this$0 = $receiver;
                this.$consentsData = $consentsData;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        ResultKt.throwOnFailure((Object)object);
                        ConsentsBuffer buffer = ConsentsServiceImpl.access$getDeviceStorage$p(this.this$0).getConsentBuffer();
                        Iterable iterable = buffer.getEntries();
                        SaveConsentsData saveConsentsData = this.$consentsData;
                        boolean $i$f$filter = false;
                        void var7_6 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            ConsentsBufferEntry it = (ConsentsBufferEntry)element$iv$iv;
                            boolean bl = false;
                            if (!(it.getTimestampInSeconds() != saveConsentsData.getTimestampInSeconds())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List newBufferEntries = (List)destination$iv$iv;
                        ConsentsServiceImpl.access$getDeviceStorage$p(this.this$0).setConsentBuffer(new ConsentsBuffer(newBufferEntries));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void addConsentsToBuffer(SaveConsentsData consentsData) {
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, consentsData, null){
            int label;
            final /* synthetic */ ConsentsServiceImpl this$0;
            final /* synthetic */ SaveConsentsData $consentsData;
            {
                this.this$0 = $receiver;
                this.$consentsData = $consentsData;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ConsentsBuffer buffer = ConsentsServiceImpl.access$getDeviceStorage$p(this.this$0).getConsentBuffer();
                        ConsentsBufferEntry entryToAdd = new ConsentsBufferEntry(this.$consentsData.getTimestampInSeconds(), this.$consentsData);
                        if (!buffer.getEntries().contains(entryToAdd)) {
                            List newBufferEntries = CollectionsKt.toMutableList((Collection)buffer.getEntries());
                            newBufferEntries.add(entryToAdd);
                            ConsentsServiceImpl.access$getDeviceStorage$p(this.this$0).setConsentBuffer(new ConsentsBuffer(newBufferEntries));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void processConsentsBuffer() {
        this.dispatcher.dispatch((Function2)new Function2<DispatcherScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ConsentsServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ConsentsBuffer buffer = ConsentsServiceImpl.access$getDeviceStorage$p(this.this$0).getConsentBuffer();
                        Iterable $this$sortedBy$iv = buffer.getEntries();
                        boolean $i$f$sortedBy = false;
                        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b) {
                                ConsentsBufferEntry it = (ConsentsBufferEntry)a;
                                boolean bl = false;
                                Comparable comparable = Long.valueOf(it.getTimestampInSeconds());
                                it = (ConsentsBufferEntry)b;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestampInSeconds()));
                            }
                        });
                        ConsentsServiceImpl consentsServiceImpl = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ConsentsBufferEntry it = (ConsentsBufferEntry)element$iv;
                            boolean bl = false;
                            ConsentsServiceImpl.access$doSaveConsents(consentsServiceImpl, it.getConsents());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull DispatcherScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ SaveConsentsData access$createState(ConsentsServiceImpl $this, UsercentricsConsentAction cause) {
        return $this.createState(cause);
    }

    public static final /* synthetic */ void access$doSaveConsents(ConsentsServiceImpl $this, SaveConsentsData consentsData) {
        $this.doSaveConsents(consentsData);
    }

    public static final /* synthetic */ void access$clearConsentsFromBuffer(ConsentsServiceImpl $this, SaveConsentsData consentsData) {
        $this.clearConsentsFromBuffer(consentsData);
    }

    public static final /* synthetic */ UsercentricsLogger access$getLogger$p(ConsentsServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$addConsentsToBuffer(ConsentsServiceImpl $this, SaveConsentsData consentsData) {
        $this.addConsentsToBuffer(consentsData);
    }

    public static final /* synthetic */ DeviceStorage access$getDeviceStorage$p(ConsentsServiceImpl $this) {
        return $this.deviceStorage;
    }
}

