/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.etag.repository;

import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b \u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fJ\u0006\u0010\u0010\u001a\u00020\bJ\b\u0010\u0011\u001a\u00020\bH\u0002J\u001c\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/usercentrics/sdk/v2/etag/repository/EtagRepository;", "", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "etagCacheStorage", "Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;)V", "etagKey", "", "getEtagKey", "()Ljava/lang/String;", "getApiBody", "response", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "getApiHeaders", "", "getEtagFile", "getEtagFromCache", "getEtagFromResponse", "headers", "isEtagValid", "", "responseStatusCode", "", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nEtagRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EtagRepository.kt\ncom/usercentrics/sdk/v2/etag/repository/EtagRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public abstract class EtagRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final IEtagCacheStorage etagCacheStorage;
    @NotNull
    private static final String etagQueryHeaderEntryKey = "If-None-Match";
    @NotNull
    private static final String etagResponseHeaderEntryKey = "etag";
    private static final int etagValidStatusCode = 304;

    public EtagRepository(@NotNull UsercentricsLogger logger2, @NotNull IEtagCacheStorage etagCacheStorage2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)etagCacheStorage2, (String)"etagCacheStorage");
        this.logger = logger2;
        this.etagCacheStorage = etagCacheStorage2;
    }

    @NotNull
    protected abstract String getEtagKey();

    @NotNull
    public final Map<String, String> getApiHeaders() {
        String etagValue = this.getEtagFromCache();
        return StringsKt.isBlank((CharSequence)etagValue) ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)etagQueryHeaderEntryKey, (Object)etagValue));
    }

    @NotNull
    public final String getApiBody(@NotNull HttpResponse response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        if (this.isEtagValid(response2.getStatusCode())) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "Valid ETAG cache: key=" + this.getEtagKey(), null, 2, null);
            return this.getEtagFile();
        }
        String etagValue = this.getEtagFromResponse(response2.getHeaders());
        if (!StringsKt.isBlank((CharSequence)etagValue)) {
            this.etagCacheStorage.storeFileAndEtag(this.getEtagKey(), etagValue, response2.getBody());
        }
        return response2.getBody();
    }

    @NotNull
    public final String getEtagFile() {
        return this.etagCacheStorage.getStoredFile(this.getEtagKey(), this.getEtagFromCache());
    }

    private final String getEtagFromCache() {
        String string = this.etagCacheStorage.getEtag(this.getEtagKey());
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getEtagFromResponse(Map<String, String> headers) {
        Object object;
        Object v0;
        block2: {
            Iterable iterable = headers.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)etagResponseHeaderEntryKey)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Map.Entry)v0) == null || (object = (String)object.getValue()) == null) {
            object = "";
        }
        return object;
    }

    private final boolean isEtagValid(int responseStatusCode) {
        return responseStatusCode == 304;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/usercentrics/sdk/v2/etag/repository/EtagRepository$Companion;", "", "()V", "etagQueryHeaderEntryKey", "", "etagResponseHeaderEntryKey", "etagValidStatusCode", "", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

