/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.language.service;

import com.usercentrics.sdk.DeviceLanguage;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.v2.language.repository.ILanguageRepository;
import com.usercentrics.sdk.v2.language.service.ILanguageService;
import com.usercentrics.sdk.v2.language.service.LanguageService;
import com.usercentrics.sdk.v2.location.data.LocationAwareResponse;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/usercentrics/sdk/v2/language/service/LanguageService;", "Lcom/usercentrics/sdk/v2/language/service/ILanguageService;", "languageRepository", "Lcom/usercentrics/sdk/v2/language/repository/ILanguageRepository;", "storage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "(Lcom/usercentrics/sdk/v2/language/repository/ILanguageRepository;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/log/UsercentricsLogger;)V", "platformLanguage", "Lcom/usercentrics/sdk/DeviceLanguage;", "<set-?>", "", "selectedLanguage", "getSelectedLanguage", "()Ljava/lang/String;", "Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "userLocation", "getUserLocation", "()Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "loadSelectedLanguage", "", "settingsId", "version", "defaultLanguage", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matchAvailableLanguage", "availableLanguages", "", "Companion", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nLanguageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageService.kt\ncom/usercentrics/sdk/v2/language/service/LanguageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1549#2:71\n1620#2,3:72\n*S KotlinDebug\n*F\n+ 1 LanguageService.kt\ncom/usercentrics/sdk/v2/language/service/LanguageService\n*L\n26#1:71\n26#1:72,3\n*E\n"})
public final class LanguageService
implements ILanguageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ILanguageRepository languageRepository;
    @NotNull
    private final DeviceStorage storage;
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final DeviceLanguage platformLanguage;
    @Nullable
    private String selectedLanguage;
    @Nullable
    private UsercentricsLocation userLocation;
    @NotNull
    private static final String fallbackDefaultLanguage = "en";
    @NotNull
    private static final String fallbackLanguageMessage = "The language has been set to the default one, English.";
    @NotNull
    private static final String deviceLanguageMessage = "The language has been set to the device language.";

    public LanguageService(@NotNull ILanguageRepository languageRepository, @NotNull DeviceStorage storage, @NotNull UsercentricsLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)languageRepository, (String)"languageRepository");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.languageRepository = languageRepository;
        this.storage = storage;
        this.logger = logger2;
        this.platformLanguage = new DeviceLanguage();
    }

    @Override
    @Nullable
    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }

    @Override
    @Nullable
    public UsercentricsLocation getUserLocation() {
        return this.userLocation;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object loadSelectedLanguage(@NotNull String var1_1, @NotNull String var2_2, @NotNull String var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof loadSelectedLanguage.1)) ** GOTO lbl-1000
        var18_5 = var4_4;
        if ((var18_5.label & -2147483648) != 0) {
            var18_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ LanguageService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadSelectedLanguage(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = defaultLanguage;
                $continuation.label = 1;
                v0 = this.languageRepository.fetchAvailableLanguages((String)settingsId, (String)version, (Continuation<? super LocationAwareResponse<List<String>>>)$continuation);
                if (v0 == var19_7) {
                    return var19_7;
                }
                ** GOTO lbl24
            }
            case 1: {
                defaultLanguage = (String)$continuation.L$1;
                this = (LanguageService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                locationAwareResponse = (LocationAwareResponse)v0;
                this.userLocation = locationAwareResponse.getLocation();
                $this$map$iv = (Iterable)locationAwareResponse.getData();
                $i$f$map = false;
                var9_11 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_16 = (String)item$iv$iv;
                    var16_18 = destination$iv$iv;
                    $i$a$-map-LanguageService$loadSelectedLanguage$availableLanguages$1 = false;
                    v1 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                    var16_18.add(v1);
                }
                availableLanguages = (List)destination$iv$iv;
                this.selectedLanguage = this.matchAvailableLanguage(defaultLanguage, availableLanguages);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String matchAvailableLanguage(String defaultLanguage, List<String> availableLanguages) {
        String deviceLanguage;
        String storageLanguage = this.storage.getSettingsLanguage();
        if (!StringsKt.isBlank((CharSequence)storageLanguage) && availableLanguages.contains(storageLanguage)) {
            return storageLanguage;
        }
        if (!StringsKt.isBlank((CharSequence)defaultLanguage) && availableLanguages.contains(defaultLanguage)) {
            return defaultLanguage;
        }
        String string = deviceLanguage = this.platformLanguage.matchLanguage(this.platformLanguage.deviceLocale(), availableLanguages);
        boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
        if (bl) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, deviceLanguageMessage, null, 2, null);
            return deviceLanguage;
        }
        String firstAvailableLanguage = (String)CollectionsKt.firstOrNull(availableLanguages);
        CharSequence charSequence = firstAvailableLanguage;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, LanguageService.Companion.firstAvailableLanguageMessage(firstAvailableLanguage), null, 2, null);
            return firstAvailableLanguage;
        }
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, fallbackLanguageMessage, null, 2, null);
        return fallbackDefaultLanguage;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/usercentrics/sdk/v2/language/service/LanguageService$Companion;", "", "()V", "deviceLanguageMessage", "", "fallbackDefaultLanguage", "fallbackLanguageMessage", "firstAvailableLanguageMessage", "language", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String firstAvailableLanguageMessage(String language) {
            return "The language has been set to the first of those available, " + language + '.';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

