/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.location.service;

import com.usercentrics.sdk.core.application.INetworkStrategy;
import com.usercentrics.sdk.v2.location.data.LocationData;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import com.usercentrics.sdk.v2.location.repository.ILocationRepository;
import com.usercentrics.sdk.v2.location.service.ILocationService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/usercentrics/sdk/v2/location/service/LocationService;", "Lcom/usercentrics/sdk/v2/location/service/ILocationService;", "locationRepository", "Lcom/usercentrics/sdk/v2/location/repository/ILocationRepository;", "networkStrategy", "Lcom/usercentrics/sdk/core/application/INetworkStrategy;", "(Lcom/usercentrics/sdk/v2/location/repository/ILocationRepository;Lcom/usercentrics/sdk/core/application/INetworkStrategy;)V", "location", "Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "getLocation", "()Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "setLocation", "(Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;)V", "isInvalidLocation", "", "loadLocation", "set", "", "usercentrics_release"})
public final class LocationService
implements ILocationService {
    @NotNull
    private final ILocationRepository locationRepository;
    @NotNull
    private final INetworkStrategy networkStrategy;
    @NotNull
    private UsercentricsLocation location;

    public LocationService(@NotNull ILocationRepository locationRepository2, @NotNull INetworkStrategy networkStrategy2) {
        Intrinsics.checkNotNullParameter((Object)locationRepository2, (String)"locationRepository");
        Intrinsics.checkNotNullParameter((Object)networkStrategy2, (String)"networkStrategy");
        this.locationRepository = locationRepository2;
        this.networkStrategy = networkStrategy2;
        this.location = new UsercentricsLocation(null, null, 3, null);
    }

    @Override
    @NotNull
    public UsercentricsLocation getLocation() {
        return this.location;
    }

    public void setLocation(@NotNull UsercentricsLocation usercentricsLocation) {
        Intrinsics.checkNotNullParameter((Object)usercentricsLocation, (String)"<set-?>");
        this.location = usercentricsLocation;
    }

    @Override
    public boolean loadLocation() {
        UsercentricsLocation location;
        LocationData locationData = this.locationRepository.getInjectedLocation();
        UsercentricsLocation usercentricsLocation = location = locationData != null ? locationData.getClientLocation() : null;
        if (this.isInvalidLocation(location) && this.networkStrategy.isOffline()) {
            LocationData locationData2 = this.locationRepository.getCachedLocation();
            UsercentricsLocation usercentricsLocation2 = location = locationData2 != null ? locationData2.getClientLocation() : null;
        }
        if (this.isInvalidLocation(location)) {
            return false;
        }
        UsercentricsLocation usercentricsLocation3 = location;
        Intrinsics.checkNotNull((Object)usercentricsLocation3);
        this.set(usercentricsLocation3);
        return true;
    }

    private final boolean isInvalidLocation(UsercentricsLocation location) {
        return location == null || location.isEmpty();
    }

    @Override
    public void set(@NotNull UsercentricsLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.setLocation(location);
        this.locationRepository.storeLocation(location);
    }
}

