/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder;

import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.TCModel;
import com.usercentrics.tcf.core.TCModelPropType;
import com.usercentrics.tcf.core.encoder.Base64Url;
import com.usercentrics.tcf.core.encoder.BitLength;
import com.usercentrics.tcf.core.encoder.field.BooleanEncoder;
import com.usercentrics.tcf.core.encoder.field.DateEncoder;
import com.usercentrics.tcf.core.encoder.field.FixedVectorEncoder;
import com.usercentrics.tcf.core.encoder.field.IntEncoder;
import com.usercentrics.tcf.core.encoder.field.LangEncoder;
import com.usercentrics.tcf.core.encoder.field.PurposeRestrictionVectorEncoder;
import com.usercentrics.tcf.core.encoder.field.VendorVectorEncoder;
import com.usercentrics.tcf.core.encoder.sequence.FieldSequence;
import com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType;
import com.usercentrics.tcf.core.errors.DecodingError;
import com.usercentrics.tcf.core.errors.EncodingError;
import com.usercentrics.tcf.core.model.PurposeRestrictionVector;
import com.usercentrics.tcf.core.model.Segment;
import com.usercentrics.tcf.core.model.SegmentIDs;
import com.usercentrics.tcf.core.model.Vector;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/tcf/core/encoder/SegmentEncoder;", "", "()V", "Companion", "usercentrics_release"})
public final class SegmentEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FieldSequence fieldSequence = new FieldSequence();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u001d\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/usercentrics/tcf/core/encoder/SegmentEncoder$Companion;", "", "()V", "fieldSequence", "Lcom/usercentrics/tcf/core/encoder/sequence/FieldSequence;", "getFieldSequence", "()Lcom/usercentrics/tcf/core/encoder/sequence/FieldSequence;", "decode", "Lcom/usercentrics/tcf/core/TCModel;", "encodedString", "", "tcModel", "segment", "encode", "Lcom/usercentrics/tcf/core/model/Segment;", "encode$usercentrics_release", "isPublisherCustom", "", "key", "usercentrics_release"})
    @SourceDebugExtension(value={"SMAP\nSegmentEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentEncoder.kt\ncom/usercentrics/tcf/core/encoder/SegmentEncoder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,354:1\n1855#2,2:355\n1855#2,2:357\n*S KotlinDebug\n*F\n+ 1 SegmentEncoder.kt\ncom/usercentrics/tcf/core/encoder/SegmentEncoder$Companion\n*L\n52#1:355,2\n168#1:357,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FieldSequence getFieldSequence() {
            return fieldSequence;
        }

        @NotNull
        public final String encode$usercentrics_release(@NotNull TCModel tcModel, @NotNull Segment segment) {
            String bitField;
            block81: {
                Intrinsics.checkNotNullParameter((Object)tcModel, (String)"tcModel");
                Intrinsics.checkNotNullParameter((Object)((Object)segment), (String)"segment");
                int version = tcModel.getVersion();
                if (version != 2) {
                    throw new EncodingError("Unsupported TCF version: " + version);
                }
                List<String> sequence = null;
                try {
                    SequenceVersionMapType sequenceVersionMapType = this.getFieldSequence().getTwo();
                    Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.SVMItemMap");
                    sequence = ((SequenceVersionMapType.SVMItemMap)sequenceVersionMapType).getMap().get((Object)segment);
                }
                catch (Throwable _) {
                    throw new EncodingError("Unable to encode version " + version + ", segment: " + (Object)((Object)segment));
                }
                bitField = null;
                bitField = "";
                if (segment != Segment.CORE) {
                    Integer segmentKeyId = SegmentIDs.Companion.getKEY_TO_ID().get((Object)segment);
                    if (segmentKeyId != null) {
                        StringOrNumber stringOrNumber = new StringOrNumber.Int(segmentKeyId);
                        BitLength bitLength = BitLength.Companion.getByName("segmentType");
                        Integer n = bitLength != null ? Integer.valueOf(bitLength.getInteger()) : null;
                        Intrinsics.checkNotNull((Object)n);
                        bitField = IntEncoder.Companion.encode(stringOrNumber, n);
                    } else {
                        throw new EncodingError("Unable to find segment key for " + (Object)((Object)segment));
                    }
                }
                List<String> list = sequence;
                if (list == null) break block81;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                block44: for (Object element$iv : $this$forEach$iv) {
                    String key = (String)element$iv;
                    boolean bl = false;
                    TCModelPropType value = tcModel.getFieldByName(key);
                    BitLength bitLength = BitLength.Companion.getByName(key);
                    int numBits = 0;
                    if (bitLength == null) {
                        if (Companion.isPublisherCustom(key)) {
                            Object numCustomPurposes = tcModel.getNumCustomPurposes();
                            if (numCustomPurposes instanceof StringOrNumber.Int) {
                                numBits = ((StringOrNumber.Int)numCustomPurposes).getValue();
                            }
                            if (numCustomPurposes instanceof StringOrNumber.String) {
                                numBits = Integer.parseInt(((StringOrNumber.String)numCustomPurposes).getValue());
                            }
                        }
                    } else {
                        numBits = bitLength.getInteger();
                    }
                    try {
                        switch (key) {
                            case "numCustomPurposes": 
                            case "version": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Int");
                                TCModelPropType.Int cfr_ignored_0 = (TCModelPropType.Int)value;
                                bitField = bitField + IntEncoder.Companion.encode(new StringOrNumber.Int(((TCModelPropType.Int)value).getValue()), numBits);
                                continue block44;
                            }
                            case "policyVersion": 
                            case "cmpVersion": 
                            case "vendorListVersion": 
                            case "cmpId": 
                            case "consentScreen": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.StringOrNumber");
                                TCModelPropType.StringOrNumber cfr_ignored_1 = (TCModelPropType.StringOrNumber)value;
                                StringOrNumber internalValue = ((TCModelPropType.StringOrNumber)value).getValue();
                                Intrinsics.checkNotNull((Object)internalValue, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.StringOrNumber.Int");
                                StringOrNumber.Int cfr_ignored_2 = (StringOrNumber.Int)internalValue;
                                bitField = bitField + IntEncoder.Companion.encode(new StringOrNumber.Int(((StringOrNumber.Int)internalValue).getValue()), numBits);
                                continue block44;
                            }
                            case "segmentType": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.StringOrNumber");
                                TCModelPropType.StringOrNumber cfr_ignored_3 = (TCModelPropType.StringOrNumber)value;
                                bitField = bitField + IntEncoder.Companion.encode(((TCModelPropType.StringOrNumber)value).getValue(), numBits);
                                continue block44;
                            }
                            case "lastUpdated": 
                            case "created": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Date");
                                TCModelPropType.Date cfr_ignored_4 = (TCModelPropType.Date)value;
                                StringBuilder stringBuilder = new StringBuilder().append(bitField);
                                Long l = ((TCModelPropType.Date)value).getValue();
                                Intrinsics.checkNotNull((Object)l);
                                bitField = stringBuilder.append(DateEncoder.Companion.encode(l, numBits)).toString();
                                continue block44;
                            }
                            case "consentLanguage": 
                            case "publisherCountryCode": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.String");
                                TCModelPropType.String cfr_ignored_5 = (TCModelPropType.String)value;
                                bitField = bitField + LangEncoder.Companion.encode(((TCModelPropType.String)value).getValue(), numBits);
                                continue block44;
                            }
                            case "isServiceSpecific": 
                            case "useNonStandardStacks": 
                            case "purposeOneTreatment": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Boolean");
                                TCModelPropType.Boolean cfr_ignored_6 = (TCModelPropType.Boolean)value;
                                bitField = bitField + BooleanEncoder.Companion.encode(((TCModelPropType.Boolean)value).getValue());
                                continue block44;
                            }
                            case "specialFeatureOptins": 
                            case "purposeLegitimateInterests": 
                            case "publisherLegitimateInterests": 
                            case "purposeConsents": 
                            case "publisherConsents": 
                            case "publisherCustomConsents": 
                            case "publisherCustomLegitimateInterests": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                                TCModelPropType.Vector cfr_ignored_7 = (TCModelPropType.Vector)value;
                                bitField = bitField + FixedVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue(), numBits);
                                continue block44;
                            }
                            case "vendorsAllowed": 
                            case "vendorsDisclosed": 
                            case "vendorConsents": 
                            case "vendorLegitimateInterests": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.Vector");
                                TCModelPropType.Vector cfr_ignored_8 = (TCModelPropType.Vector)value;
                                bitField = bitField + VendorVectorEncoder.Companion.encode(((TCModelPropType.Vector)value).getValue());
                                continue block44;
                            }
                            case "publisherRestrictions": {
                                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.TCModelPropType.PurposeRestrictionVector");
                                TCModelPropType.PurposeRestrictionVector cfr_ignored_9 = (TCModelPropType.PurposeRestrictionVector)value;
                                bitField = bitField + PurposeRestrictionVectorEncoder.Companion.encode(((TCModelPropType.PurposeRestrictionVector)value).getValue());
                                continue block44;
                            }
                            default: {
                                throw new EncodingError("Error encoding " + (Object)((Object)segment) + "->" + key + ", value: " + value);
                            }
                        }
                    }
                    catch (Throwable error) {
                        throw new EncodingError("Error encoding " + (Object)((Object)segment) + "->" + key + ": " + error.getMessage());
                    }
                }
            }
            return Base64Url.Companion.encode(bitField);
        }

        @NotNull
        public final TCModel decode(@NotNull String encodedString, @NotNull TCModel tcModel, @NotNull String segment) {
            Intrinsics.checkNotNullParameter((Object)encodedString, (String)"encodedString");
            Intrinsics.checkNotNullParameter((Object)tcModel, (String)"tcModel");
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            TCModel tempTCModel = tcModel;
            String bitField = Base64Url.Companion.decode(encodedString);
            int bStringIdx = 0;
            if (Intrinsics.areEqual((Object)segment, (Object)Segment.CORE.getType())) {
                String string = bitField.substring(bStringIdx, bStringIdx + BitLength.version.getInteger());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int encodedVersion = (int)IntEncoder.Companion.decode(string, BitLength.version.getInteger());
                tempTCModel.setVersion(new StringOrNumber.Int(encodedVersion));
            }
            if (!Intrinsics.areEqual((Object)segment, (Object)Segment.CORE.getType())) {
                bStringIdx += BitLength.segmentType.getInteger();
            }
            SequenceVersionMapType sequenceVersionMapType = this.getFieldSequence().getTwo();
            Intrinsics.checkNotNull((Object)sequenceVersionMapType, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.encoder.sequence.SequenceVersionMapType.SVMItemMap");
            SequenceVersionMapType.SVMItemMap fieldSequence = (SequenceVersionMapType.SVMItemMap)sequenceVersionMapType;
            List<String> list = fieldSequence.getMap().get((Object)Segment.Companion.getSegmentByType(segment));
            if (list == null) {
                throw new IllegalStateException("Unable to find fieldSequence".toString());
            }
            List<String> sequence = list;
            Iterable $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                Integer numBits;
                String key = (String)element$iv;
                boolean bl = false;
                BitLength bitLength = BitLength.Companion.getByName(key);
                Integer n2 = numBits = bitLength != null ? Integer.valueOf(bitLength.getInteger()) : null;
                if (numBits == null && Companion.isPublisherCustom(key)) {
                    StringOrNumber stringOrNumber = tempTCModel.getNumCustomPurposes();
                    Intrinsics.checkNotNull((Object)stringOrNumber, (String)"null cannot be cast to non-null type com.usercentrics.tcf.core.StringOrNumber.Int");
                    numBits = ((StringOrNumber.Int)stringOrNumber).getValue();
                }
                Integer n3 = numBits;
                if (n3 != null && n3 == 0) continue;
                int endPosition = numBits == null ? bitField.length() : numBits + bStringIdx;
                Intrinsics.checkNotNullExpressionValue((Object)bitField.substring(bStringIdx, endPosition), (String)"substring(...)");
                switch (key) {
                    case "version": {
                        String bits;
                        Integer n4 = numBits;
                        long decodedVersion = IntEncoder.Companion.decode(bits, n4 != null ? n4 : 0);
                        tempTCModel.setVersion(new StringOrNumber.Int((int)decodedVersion));
                        break;
                    }
                    case "created": {
                        String bits;
                        Integer n5 = numBits;
                        long decodedCreated = DateEncoder.Companion.decode(bits, n5 != null ? n5 : 0);
                        tempTCModel.setCreated(decodedCreated);
                        break;
                    }
                    case "lastUpdated": {
                        String bits;
                        Integer n6 = numBits;
                        long decodedCreated = DateEncoder.Companion.decode(bits, n6 != null ? n6 : 0);
                        tempTCModel.setLastUpdated(decodedCreated);
                        break;
                    }
                    case "cmpId": {
                        String bits;
                        Integer n7 = numBits;
                        long decodedCmpId = IntEncoder.Companion.decode(bits, n7 != null ? n7 : 0);
                        tempTCModel.setCmpId(new StringOrNumber.Int((int)decodedCmpId));
                        break;
                    }
                    case "cmpVersion": {
                        String bits;
                        Integer n8 = numBits;
                        long decodedCmpIdVersion = IntEncoder.Companion.decode(bits, n8 != null ? n8 : 0);
                        tempTCModel.setCmpVersion(new StringOrNumber.Int((int)decodedCmpIdVersion));
                        break;
                    }
                    case "consentScreen": {
                        String bits;
                        Integer n9 = numBits;
                        long decodedConsentScreen = IntEncoder.Companion.decode(bits, n9 != null ? n9 : 0);
                        tempTCModel.setConsentScreen(new StringOrNumber.Int((int)decodedConsentScreen));
                        break;
                    }
                    case "consentLanguage": {
                        String bits;
                        Integer n10 = numBits;
                        String decodedConsentLanguage = LangEncoder.Companion.decode(bits, n10 != null ? n10 : 0);
                        tempTCModel.setConsentLanguage(decodedConsentLanguage);
                        break;
                    }
                    case "vendorListVersion": {
                        String bits;
                        Integer n11 = numBits;
                        long decodedVendorListVersion = IntEncoder.Companion.decode(bits, n11 != null ? n11 : 0);
                        tempTCModel.setVendorListVersion(new StringOrNumber.Int((int)decodedVendorListVersion));
                        break;
                    }
                    case "purposeConsents": {
                        String bits;
                        Integer n12 = numBits;
                        Vector decodedPurposeConsents = FixedVectorEncoder.Companion.decode(bits, n12 != null ? n12 : 0);
                        tempTCModel.setPurposeConsents(decodedPurposeConsents);
                        break;
                    }
                    case "vendorConsents": {
                        String bits;
                        Vector decodedVendorConsents = VendorVectorEncoder.Companion.decode(bits);
                        tempTCModel.setVendorConsents(decodedVendorConsents);
                        break;
                    }
                    case "policyVersion": {
                        String bits;
                        Integer n13 = numBits;
                        long decodedPolicyVersion = IntEncoder.Companion.decode(bits, n13 != null ? n13 : 0);
                        tempTCModel.setPolicyVersion(new StringOrNumber.Int((int)decodedPolicyVersion));
                        break;
                    }
                    case "isServiceSpecific": {
                        String bits;
                        boolean decodedIsServiceSpecific = BooleanEncoder.Companion.decode(bits);
                        tempTCModel.setIsServiceSpecific(decodedIsServiceSpecific);
                        break;
                    }
                    case "useNonStandardStacks": {
                        String bits;
                        boolean decodedUseNonStandardStacks = BooleanEncoder.Companion.decode(bits);
                        tempTCModel.setUseNonStandardStacks(decodedUseNonStandardStacks);
                        break;
                    }
                    case "specialFeatureOptins": {
                        String bits;
                        Integer n14 = numBits;
                        Vector decodedSpecialFeatureOptins = FixedVectorEncoder.Companion.decode(bits, n14 != null ? n14 : 0);
                        tempTCModel.setSpecialFeatureOptins(decodedSpecialFeatureOptins);
                        break;
                    }
                    case "purposeLegitimateInterests": {
                        String bits;
                        Integer n15 = numBits;
                        Vector decodedPurposeLegitimateInterests = FixedVectorEncoder.Companion.decode(bits, n15 != null ? n15 : 0);
                        tempTCModel.setPurposeLegitimateInterests(decodedPurposeLegitimateInterests);
                        break;
                    }
                    case "purposeOneTreatment": {
                        String bits;
                        boolean decodedPurposeOneTreatment = BooleanEncoder.Companion.decode(bits);
                        tempTCModel.setPurposeOneTreatment(decodedPurposeOneTreatment);
                        break;
                    }
                    case "publisherCountryCode": {
                        String bits;
                        Integer n16 = numBits;
                        String decodedPublisherCountryCode = LangEncoder.Companion.decode(bits, n16 != null ? n16 : 0);
                        tempTCModel.setPublisherCountryCode(decodedPublisherCountryCode);
                        break;
                    }
                    case "vendorLegitimateInterests": {
                        String bits;
                        Vector decodedVendorLegitimateInterests = VendorVectorEncoder.Companion.decode(bits);
                        tempTCModel.setVendorLegitimateInterests(decodedVendorLegitimateInterests);
                        break;
                    }
                    case "publisherRestrictions": {
                        String bits;
                        PurposeRestrictionVector decodedPublisherRestrictions = PurposeRestrictionVectorEncoder.Companion.decode(bits);
                        tempTCModel.setPublisherRestrictions(decodedPublisherRestrictions);
                        break;
                    }
                    case "publisherConsents": {
                        String bits;
                        Integer n17 = numBits;
                        Vector decodedPublisherConsents = FixedVectorEncoder.Companion.decode(bits, n17 != null ? n17 : 0);
                        tempTCModel.setPublisherConsents(decodedPublisherConsents);
                        break;
                    }
                    case "publisherLegitimateInterests": {
                        String bits;
                        Integer n18 = numBits;
                        Vector decodedPublisherLegitimateInterests = FixedVectorEncoder.Companion.decode(bits, n18 != null ? n18 : 0);
                        tempTCModel.setPublisherLegitimateInterests(decodedPublisherLegitimateInterests);
                        break;
                    }
                    case "numCustomPurposes": {
                        String bits;
                        Integer n19 = numBits;
                        long decodedNumCustomPurposes = IntEncoder.Companion.decode(bits, n19 != null ? n19 : 0);
                        tempTCModel.setNumCustomPurposes(new StringOrNumber.Int((int)decodedNumCustomPurposes));
                        break;
                    }
                    case "publisherCustomConsents": {
                        String bits;
                        Integer n20 = numBits;
                        Vector decodedPublisherCustomConsents = FixedVectorEncoder.Companion.decode(bits, n20 != null ? n20 : 0);
                        tempTCModel.setPublisherCustomConsents(decodedPublisherCustomConsents);
                        break;
                    }
                    case "publisherCustomLegitimateInterests": {
                        String bits;
                        Integer n21 = numBits;
                        Vector decodedPublisherCustomLegitimateInterests = FixedVectorEncoder.Companion.decode(bits, n21 != null ? n21 : 0);
                        tempTCModel.setPublisherCustomLegitimateInterests(decodedPublisherCustomLegitimateInterests);
                        break;
                    }
                    case "vendorsAllowed": {
                        String bits;
                        Vector decodedVendorsAllowed = VendorVectorEncoder.Companion.decode(bits);
                        tempTCModel.setVendorsAllowed(decodedVendorsAllowed);
                        break;
                    }
                    case "vendorsDisclosed": {
                        String bits;
                        Vector decodedVendorsDisclosed = VendorVectorEncoder.Companion.decode(bits);
                        tempTCModel.setVendorsDisclosed(decodedVendorsDisclosed);
                        break;
                    }
                    default: {
                        throw new DecodingError("Unable to set decoded version of the key: " + key);
                    }
                }
                if (numBits != null) {
                    bStringIdx += numBits.intValue();
                    continue;
                }
                TCModelPropType tcModelKeyProperty = tcModel.getFieldByName(key);
                TCModelPropType tCModelPropType = tcModelKeyProperty;
                if (tCModelPropType instanceof TCModelPropType.Vector) {
                    n = ((TCModelPropType.Vector)tcModelKeyProperty).getValue().getBitLength();
                } else if (tCModelPropType instanceof TCModelPropType.PurposeRestrictionVector) {
                    n = ((TCModelPropType.PurposeRestrictionVector)tcModelKeyProperty).getValue().getBitLength();
                } else {
                    throw new DecodingError("Unable to increase bitLength for key: " + key);
                }
                bStringIdx += n;
            }
            return tempTCModel;
        }

        public final boolean isPublisherCustom(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return StringsKt.indexOf$default((CharSequence)key, (String)"publisherCustom", (int)0, (boolean)false, (int)6, null) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

