/* Generated By:JavaCC: Do not edit this line. FuzzerParser.java */
package com.uwemeding.fuzzer.parser;

import com.uwemeding.fuzzer.*;

import java.io.InputStream;
import java.util.StringJoiner;

public class FuzzerParser implements FuzzerParserConstants {

    public FuzzerParser() {
    }

    /** 
     * Parse a fuzzer program file.
     * @param in is the input stream
     * @return the program
     */
    public Program parse(InputStream in) {
        try {
            FuzzerParser parser = new FuzzerParser(in);
            return parser.FuzzerProgram();
        } catch(ParseException e) {
            throw new FuzzerException("Error parsing program definitions", e);
        }
    }

    public static void main(String...av) {
        Program program = new FuzzerParser().parse(System.in);
        program.dump(System.out);
    }

/*
 * FUZZER GRAMMAR
 */
  static final public Program FuzzerProgram() throws ParseException {
Program program = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PACKAGE:
      PackageDeclaration();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    program = ProgramDeclaration();
    jj_consume_token(0);
    {if (true) return program;}
    throw new Error("Missing return statement in function");
  }

  static final public void PackageDeclaration() throws ParseException {
    jj_consume_token(PACKAGE);
    Name();
    jj_consume_token(SEMICOLON);
  }

  static final public Program ProgramDeclaration() throws ParseException {
Program program;
String programName;
    jj_consume_token(PROGRAM);
    programName = VariableDeclarator();
    jj_consume_token(LBRACE);
    program = new Program(programName);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case HEDGE:
      case FUNCTION:
      case INPUT:
      case OUTPUT:
      case RULE:
      case REASONING:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      ProgramBodyDeclaration(program);
    }
    jj_consume_token(RBRACE);
    {if (true) return program;}
    throw new Error("Missing return statement in function");
  }

  static final public void ProgramBodyDeclaration(Program program) throws ParseException {
String name;
String expr;
String arg;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case HEDGE:
      jj_consume_token(HEDGE);
      name = VariableDeclarator();
      jj_consume_token(LPAREN);
      arg = VariableDeclarator();
      jj_consume_token(RPAREN);
      expr = Expression();
      jj_consume_token(SEMICOLON);
    program.addHedge(name, arg, expr);
      break;
    default:
      jj_la1[3] = jj_gen;
      if (jj_2_1(2147483647)) {
        jj_consume_token(FUNCTION);
        name = VariableDeclarator();
        jj_consume_token(LPAREN);
        arg = VariableDeclarator();
        jj_consume_token(RPAREN);
        jj_consume_token(PIECEWISE);
    PiecewiseFunction pwFunc = program.addPiecewiseFunction(name, arg);
        PiecewiseDeclaration(pwFunc);
        jj_consume_token(LBRACE);
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDENTIFIER:
          case RANGE:
            ;
            break;
          default:
            jj_la1[2] = jj_gen;
            break label_2;
          }
          PiecewiseRange(pwFunc);
        }
        jj_consume_token(RBRACE);
      } else if (jj_2_2(2147483647)) {
        jj_consume_token(FUNCTION);
        name = VariableDeclarator();
        jj_consume_token(LPAREN);
        arg = VariableDeclarator();
        jj_consume_token(RPAREN);
        jj_consume_token(EXTERNAL);
    ExternalFunction extFunc = program.addExternalFunction(name, arg);
        ExternalFunctionDeclaration(extFunc);
        jj_consume_token(SEMICOLON);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INPUT:
          jj_consume_token(INPUT);
          FuzzyVariableDeclaration(program, true);
          break;
        case OUTPUT:
          jj_consume_token(OUTPUT);
          FuzzyVariableDeclaration(program, false);
          break;
        case RULE:
          jj_consume_token(RULE);
          FuzzyRule(program);
          break;
        case REASONING:
          jj_consume_token(REASONING);
          FuzzyReasoning(program);
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/*
 * Extract the piecewise declarations
 */
  static final public void PiecewiseDeclaration(PiecewiseFunction pwFunc) throws ParseException {
String var;
    var = VariableDeclarator();
    pwFunc.addParameter(var);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      var = VariableDeclarator();
    pwFunc.addParameter(var);
    }
  }

  static final public void PiecewiseRange(PiecewiseFunction pwFunc) throws ParseException {
String from, to, expr;
    if (jj_2_3(2147483647)) {
      jj_consume_token(RANGE);
      to = VariableDeclarator();
      expr = Expression();
      jj_consume_token(SEMICOLON);
    pwFunc.add("<", to, expr);
    } else if (jj_2_4(2147483647)) {
      from = VariableDeclarator();
      jj_consume_token(RANGE);
      to = VariableDeclarator();
      expr = Expression();
      jj_consume_token(SEMICOLON);
    pwFunc.add(from, to, expr);
    } else if (jj_2_5(2147483647)) {
      from = VariableDeclarator();
      jj_consume_token(RANGE);
      expr = Expression();
      jj_consume_token(SEMICOLON);
    pwFunc.add(from, ">", expr);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * External function reference
 */
  static final public void ExternalFunctionDeclaration(ExternalFunction extFunc) throws ParseException {
String name;
String var;
    name = Name();
    jj_consume_token(LPAREN);
    var = VariableDeclarator();
    jj_consume_token(RPAREN);
    extFunc.setupClassReference(name, var);
  }

/*
 * Fuzzy variable delaration
 */
  static final public void FuzzyVariableDeclaration(Program program, boolean isInput) throws ParseException {
String name;
Number from, to, step;
Variable var;
    name = VariableDeclarator();
    jj_consume_token(LPAREN);
    from = NumberReference();
    jj_consume_token(RANGE);
    to = NumberReference();
    jj_consume_token(STEP);
    step = NumberReference();
    jj_consume_token(RPAREN);
    var = isInput ? program.addInput(name, from, to, step) : program.addOutput(name, from, to, step);
    jj_consume_token(LBRACE);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      MemberDefinition(program, var);
    }
    jj_consume_token(RBRACE);
  }

  static final public void MemberDefinition(Program program, Variable var) throws ParseException {
String memberName;
Member member;
    if (jj_2_6(2147483647)) {
      memberName = VariableDeclarator();
      jj_consume_token(49);
    member = var.addMember(memberName);
      label_5:
      while (true) {
        MemberStep(member);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LBRACE:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_5;
        }
      }
      jj_consume_token(SEMICOLON);
    } else if (jj_2_7(2147483647)) {
      memberName = VariableDeclarator();
      jj_consume_token(49);
      FunctionCall(program, var, memberName);
      jj_consume_token(SEMICOLON);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  static final public void MemberStep(Member member) throws ParseException {
Number x, y;
    jj_consume_token(LBRACE);
    x = NumberReference();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
    case COMMA:
    case 50:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      case 50:
        jj_consume_token(50);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    y = NumberReference();
    jj_consume_token(RBRACE);
    member.add(x, y);
  }

  static final public void FunctionCall(Program program, Variable var, String memberName) throws ParseException {
String functionName;
Function function;
FunctionCall call;
    functionName = VariableDeclarator();
    function = program.getFunction(functionName);
    call = new FunctionCall(function);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case 51:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_6;
        }
        FunctionCallParameters(program, var, memberName, call);
      }
      jj_consume_token(RBRACKET);
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(LPAREN);
    VariableDeclarator();
    jj_consume_token(RPAREN);
    Member member = var.addMember(memberName, call);
  }

  static final public void FunctionCallParameters(Program program, Variable var, String memberName, FunctionCall call) throws ParseException {
Number parameter;
    parameter = NumberReference();
    call.bindParameter(parameter);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      parameter = NumberReference();
      call.bindParameter(parameter);
    }
  }

/*
 * Parse a fuzzy rule.
 */
  static final public void FuzzyRule(Program program) throws ParseException {
String  ruleName;
Node condition;
Rule rule;
    ruleName = VariableDeclarator();
    jj_consume_token(LPAREN);
    condition = FuzzyCondition(program);
    jj_consume_token(RPAREN);
    rule = program.addRule(ruleName, condition);
    jj_consume_token(LBRACE);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_8;
      }
      FuzzyRuleAssignment(program, rule);
    }
    jj_consume_token(RBRACE);
  }

/*
 * the fuzzy conditions
 */
  static final public Node FuzzyCondition(Program program) throws ParseException {
Node condition;
    condition = FuzzyOrCondition(program);
    {if (true) return condition;}
    throw new Error("Missing return statement in function");
  }

/*
 * OR condition: left-to-right
 */
  static final public Node FuzzyOrCondition(Program program) throws ParseException {
Node left;
Node right;
    left = FuzzyAndCondition(program);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_9;
      }
      jj_consume_token(OR);
      right = FuzzyAndCondition(program);
      left=RuleConditions.createOrCondition(left, right);
    }
    {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

/*
 * AND condition: left-to-right
 */
  static final public Node FuzzyAndCondition(Program program) throws ParseException {
Node left;
Node right;
    left = FuzzyInSetCondition(program);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_10;
      }
      jj_consume_token(AND);
      right = FuzzyInSetCondition(program);
      left=RuleConditions.createAndCondition(left, right);
    }
    {if (true) return left;}
    throw new Error("Missing return statement in function");
  }

  static final public Node FuzzyInSetCondition(Program program) throws ParseException {
String varName;
String memberName;
String hedgeName = null;
Node node;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      node = FuzzyCondition(program);
      jj_consume_token(RPAREN);
    {if (true) return node;}
      break;
    default:
      jj_la1[16] = jj_gen;
      if (jj_2_8(4)) {
        varName = VariableDeclarator();
        jj_consume_token(IS);
        hedgeName = VariableDeclarator();
        memberName = VariableDeclarator();
    Variable var = program.getInput(varName);
    Member member;
    if(var.haveMember(hedgeName, memberName)) {
        // reuse an already hedged member
        member = var.getMember(hedgeName, memberName);
    } else {
        // hedge a new member
        Hedge hedge = program.getHedge(hedgeName);
        member = var.getMember(memberName);
        member = member.applyHedge(hedge);
        var.addMember(member);
    }
    member.incrReferenceCount();
    {if (true) return RuleConditions.createInCondition(var, member);}
      } else if (jj_2_9(3)) {
        varName = VariableDeclarator();
        jj_consume_token(IS);
        memberName = VariableDeclarator();
    Variable var = program.getInput(varName);
    Member member = var.getMember(memberName);
    member.incrReferenceCount();
    {if (true) return RuleConditions.createInCondition(var, member);}
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  static final public void FuzzyRuleAssignment(Program program, Rule rule) throws ParseException {
String varName;
String memberName;
    varName = VariableDeclarator();
    jj_consume_token(49);
    memberName = VariableDeclarator();
    jj_consume_token(SEMICOLON);
    Variable var = program.getOutput(varName);
    Member member = var.getMember(memberName);
    member.incrReferenceCount();
    rule.assign(var, member);
  }

/*
 * Set the fuzzy reasoning
 */
  static final public void FuzzyReasoning(Program program) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAXMIN:
      jj_consume_token(MAXMIN);
      jj_consume_token(SEMICOLON);
    program.setReasoningStrategy(ReasoningStrategy.MAXMIN);
      break;
    case MAXDOT:
      jj_consume_token(MAXDOT);
      jj_consume_token(SEMICOLON);
    program.setReasoningStrategy(ReasoningStrategy.MAXDOT);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * A variable name
 */
  static final public String VariableDeclarator() throws ParseException {
    jj_consume_token(IDENTIFIER);
    {if (true) return getToken(0).image;}
    throw new Error("Missing return statement in function");
  }

/*
 * A number reference
 */
  static final public Number NumberReference() throws ParseException {
boolean haveSign = false;
Number number;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 51:
      jj_consume_token(51);
      haveSign = true;
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    number = UnsignedNumberReference();
    {if (true) return haveSign ? -number.doubleValue() : number;}
    throw new Error("Missing return statement in function");
  }

  static final public Number UnsignedNumberReference() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
    {if (true) return Double.parseDouble(getToken(0).image);}
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
    {if (true) return Double.parseDouble(getToken(0).image);}
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/*
 * Parse an expression
 */
  static final public String Expression() throws ParseException {
    jj_consume_token(EXPRESSION);
    String expr = getToken(0).image.substring(2).trim();
    {if (true) return expr;}
    throw new Error("Missing return statement in function");
  }

/*
 * Extract a fully-qualified name
 */
  static final public String Name() throws ParseException {
String name;
StringJoiner sj = new StringJoiner(".");
    name = VariableDeclarator();
    sj.add(name);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_11;
      }
      jj_consume_token(DOT);
      name = VariableDeclarator();
      sj.add(name);
    }
    {if (true) return sj.toString();}
    throw new Error("Missing return statement in function");
  }

  static private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  static private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  static private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  static private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  static private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  static private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  static private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  static private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  static private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  static private boolean jj_3_5() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(RANGE)) return true;
    return false;
  }

  static private boolean jj_3_6() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(49)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  static private boolean jj_3_8() {
    if (jj_3R_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_3R_12()) return true;
    if (jj_3R_12()) return true;
    return false;
  }

  static private boolean jj_3_2() {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(EXTERNAL)) return true;
    return false;
  }

  static private boolean jj_3_4() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(RANGE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static private boolean jj_3R_12() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static private boolean jj_3_9() {
    if (jj_3R_12()) return true;
    if (jj_scan_token(IS)) return true;
    if (jj_3R_12()) return true;
    return false;
  }

  static private boolean jj_3_3() {
    if (jj_scan_token(RANGE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static private boolean jj_3_1() {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_12()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(PIECEWISE)) return true;
    return false;
  }

  static private boolean jj_3_7() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(49)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static private boolean jj_initialized_once = false;
  /** Generated Token Manager. */
  static public FuzzerParserTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  /** Current token. */
  static public Token token;
  /** Next token. */
  static public Token jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[21];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x200,0x459800,0x0,0x800,0x458000,0x0,0x0,0x0,0x0,0x0,0x22000000,0x0,0x0,0x0,0x200000,0x100000,0x0,0x1800000,0x0,0x22000000,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x8002,0x0,0x0,0x4000,0x2,0x200,0x46000,0x46000,0x80000,0x800,0x4000,0x2,0x0,0x0,0x80,0x0,0x80000,0x0,0x10000,};
   }
  static final private JJCalls[] jj_2_rtns = new JJCalls[9];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  /** Constructor with InputStream. */
  public FuzzerParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public FuzzerParser(java.io.InputStream stream, String encoding) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new FuzzerParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  static public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  static public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public FuzzerParser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser. ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new FuzzerParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public FuzzerParser(FuzzerParserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser. ");
      System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(FuzzerParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 21; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  static final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  static private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  static final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  static final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  static public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[52];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 21; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 52; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  static final public void enable_tracing() {
  }

  /** Disable tracing. */
  static final public void disable_tracing() {
  }

  static private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 9; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  static private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
