/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.FunctionCall;
import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.NameBearer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public abstract class Function
implements NameBearer {
    private final String name;
    private final String argumentName;
    private final List<String> parameters;

    public Function(String name, String argumentName) {
        this.name = name;
        this.argumentName = argumentName;
        this.parameters = new ArrayList<String>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public void addParameter(String ... paras) {
        for (String parameter : paras) {
            for (String knownDef : this.parameters) {
                if (!parameter.equals(knownDef)) continue;
                throw new FuzzerException(this.name + ": parameter '" + parameter + "' already defined");
            }
            this.parameters.add(parameter);
        }
    }

    public int parameterCount() {
        return this.parameters.size();
    }

    public String getNthParameter(int n) {
        return this.getNth(n, this.parameters, "parameters");
    }

    public Collection<String> parameters() {
        return this.parameters;
    }

    private String getNth(int n, List<String> list, String typeName) {
        if (n < 0) {
            throw new FuzzerException(this.name + ": " + n + ": " + typeName + " reference must be positive");
        }
        if (n >= list.size()) {
            throw new FuzzerException(this.name + ": " + n + " illegal " + typeName + " position");
        }
        return list.get(n);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Function other = (Function)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.argumentName).append(")");
        if (!this.parameters.isEmpty()) {
            StringJoiner sj = new StringJoiner(",", " with parameters (", ")");
            this.parameters.forEach(parameter -> sj.add((CharSequence)parameter));
        }
        return sb.toString();
    }

    public String toString() {
        return "Function{name=" + this.name + '}';
    }

    public abstract double call(FunctionCall var1, double var2);
}

