/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.Function;
import com.uwemeding.fuzzer.FuzzerException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FunctionCall {
    private final Function function;
    private final Map<String, Number> bindings;

    public FunctionCall(Function function) {
        if (function == null) {
            throw new NullPointerException("function cannot be null");
        }
        this.function = function;
        this.bindings = new HashMap<String, Number>();
    }

    public Function getFunction() {
        return this.function;
    }

    public FunctionCall bindParameter(Number number) {
        int pos = this.bindings.size();
        String parameterName = this.function.getNthParameter(pos);
        this.bindings.put(parameterName, number);
        return this;
    }

    public Collection<String> parameterNames() {
        return this.bindings.keySet();
    }

    public Number getParameter(String name) {
        Number number = this.bindings.get(name);
        if (number == null) {
            throw new FuzzerException(this.function.getName() + ": undefined parameter '" + name + "'");
        }
        return number;
    }

    public double invoke(double arg) {
        return this.function.call(this, arg);
    }

    public String toLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function.getName());
        String delim = " with ";
        for (String parameter : this.function.parameters()) {
            String n;
            try {
                n = String.valueOf(this.getParameter(parameter));
            }
            catch (FuzzerException r) {
                n = "<undefined>";
            }
            sb.append(delim).append(parameter).append("=").append(n);
            delim = ", ";
        }
        return sb.toString();
    }

    public String toString() {
        return "FuncRef{name=" + this.function.getName() + '}';
    }
}

