/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GetOpt {
    private final Map<String, Definition> longOpts = new HashMap<String, Definition>();
    private final Map<String, Definition> shortOpts = new HashMap<String, Definition>();
    private final List<Definition> definitions = new ArrayList<Definition>();
    private int optind = 0;

    public GetOpt add(String longName, String shortName, boolean hasArg, String helpText) {
        this.add(new Definition(longName, shortName, hasArg, helpText));
        return this;
    }

    public void add(Definition def) {
        this.definitions.add(def);
        if (this.longOpts.containsKey(def.getLongName())) {
            throw new IllegalArgumentException("Option '" + def.getLongName() + "' already defined");
        }
        if (this.shortOpts.containsKey(def.getShortName())) {
            throw new IllegalArgumentException("Option '" + def.getShortName() + "' already defined");
        }
        this.longOpts.put(def.getLongName(), def);
        this.shortOpts.put(def.getShortName(), def);
    }

    public Iterable<Definition> definitions() {
        return this.definitions::iterator;
    }

    public int getOptind() {
        return this.optind;
    }

    public Iterable<Option> parseOptions(String ... av) {
        this.optind = av.length;
        GetOpt go = this;
        return () -> new OptionIterator(go, av);
    }

    private static class OptionIterator
    implements Iterator<Option> {
        private final GetOpt getOpt;
        private final String[] av;
        private int pos;

        public OptionIterator(GetOpt getOpt, String ... av) {
            this.getOpt = getOpt;
            this.av = av;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            this.getOpt.optind = this.pos;
            return this.pos < this.av.length && this.av[this.pos].startsWith("-");
        }

        @Override
        public Option next() {
            Option opt;
            String arg;
            if ((arg = this.av[this.pos++]).startsWith("--")) {
                String value;
                String key;
                int sepPos = arg.indexOf("=");
                if (sepPos > 0) {
                    key = arg.substring(2, sepPos);
                    value = arg.substring(sepPos + 1);
                } else {
                    key = arg.substring(2);
                    value = null;
                }
                Definition def = (Definition)this.getOpt.longOpts.get(key);
                if (def == null) {
                    throw new IllegalArgumentException("Unexpected argument " + arg);
                }
                if (def.hasArg()) {
                    if (value == null) {
                        throw new IllegalArgumentException("Argument expected for " + arg);
                    }
                } else if (value != null) {
                    throw new IllegalArgumentException("Unexpected argument " + arg);
                }
                opt = new Option(def, value);
            } else if (arg.startsWith("-")) {
                String key = arg.substring(1);
                String value = null;
                Definition def = (Definition)this.getOpt.shortOpts.get(key);
                if (def == null) {
                    throw new IllegalArgumentException("Unexpected argument " + arg);
                }
                if (def.hasArg()) {
                    if (this.pos < this.av.length) {
                        if (this.av[this.pos].startsWith("-")) {
                            throw new IllegalArgumentException("Argument expected for " + arg);
                        }
                        value = this.av[this.pos++];
                    } else {
                        throw new IllegalArgumentException("Argument expected for " + arg);
                    }
                }
                opt = new Option(def, value);
            } else {
                throw new IllegalArgumentException("Unexpected argument " + arg);
            }
            return opt;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class Option {
        private final Definition arg;
        private final String value;

        public Option(Definition arg, String value) {
            this.arg = arg;
            this.value = value;
        }

        public String getLongName() {
            return this.arg.getLongName();
        }

        public String getShortName() {
            return this.arg.getShortName();
        }

        public String getValue() {
            if (this.value == null) {
                throw new IllegalArgumentException("Option " + this.arg + " has no value");
            }
            return this.value;
        }

        public String toString() {
            return this.value == null ? this.arg.toString() : this.arg.toString() + ": " + this.value;
        }
    }

    public static class Definition {
        private final String longName;
        private final String shortName;
        private final boolean hasArg;
        private final String helpText;

        public Definition(String longName, String shortName, boolean hasArg, String helpText) {
            this.longName = longName;
            this.shortName = shortName;
            this.hasArg = hasArg;
            this.helpText = helpText;
        }

        public boolean hasArg() {
            return this.hasArg;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String toString() {
            return this.hasArg ? "-" + this.shortName + " ARG | --" + this.longName + "=ARG" : "-" + this.shortName + "     | --" + this.longName;
        }
    }
}

