/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.ExpressionEvalFactory;
import com.uwemeding.fuzzer.NameBearer;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;

public class Hedge
implements NameBearer {
    private final String name;
    private String arg;
    private String expressionString;
    private Expression expression;

    public Hedge(String name) {
        this.name = name;
    }

    public Hedge(String name, String arg) {
        this(name);
        this.arg = arg;
    }

    public Hedge(String name, String arg, String expressionString) {
        this(name);
        this.arg = arg;
        this.expressionString = expressionString;
        this.expression = ExpressionEvalFactory.getInstance().createExpression(expressionString);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getArg() {
        return this.arg;
    }

    public void setArg(String arg) {
        this.arg = arg;
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public void setExpressionString(String expression) {
        this.expressionString = expression;
        this.expression = ExpressionEvalFactory.getInstance().createExpression(this.expressionString);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public double calculateValue(double value) {
        MapContext context = new MapContext();
        context.set(this.getArg(), (Object)value);
        return (Double)this.expression.evaluate((JexlContext)context);
    }

    public String toString() {
        return "Hedge{name=" + this.name + '}';
    }
}

