/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.Function;
import com.uwemeding.fuzzer.FunctionCall;
import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.Hedge;
import com.uwemeding.fuzzer.NameBearer;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Member
extends Node
implements NameBearer {
    private final String name;
    private final List<Point> points;
    private final FunctionCall functionCall;
    private final Hedge hedge;
    private final List<Double> exploded;
    private final List<Integer> normalized;
    private int referenceCount;

    protected Member(String name, FunctionCall functionCall, Hedge hedge) {
        this.name = name;
        this.functionCall = functionCall;
        this.hedge = hedge;
        this.points = new ArrayList<Point>();
        this.exploded = new ArrayList<Double>();
        this.normalized = new ArrayList<Integer>();
        this.referenceCount = 0;
    }

    public Member(String name, FunctionCall functionCall) {
        this(name, functionCall, null);
    }

    public Member(String name) {
        this(name, null);
    }

    public Member applyHedge(Hedge hedge) {
        String newMemberName = hedge.getName() + "$" + this.name;
        Member member = new Member(newMemberName, this.functionCall, hedge);
        this.points.stream().forEach(point -> member.points.add((Point)point));
        return member;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node.Type getNodeType() {
        return Node.Type.MEMBER;
    }

    public boolean haveFunctionCall() {
        return this.functionCall != null;
    }

    public FunctionCall getFunctionCall() {
        if (this.functionCall == null) {
            throw new FuzzerException(this.name + ": no function call found");
        }
        return this.functionCall;
    }

    public boolean haveHedge() {
        return this.hedge != null;
    }

    public Hedge getHedge() {
        if (this.hedge == null) {
            throw new FuzzerException(this.name + ": no hedge found");
        }
        return this.hedge;
    }

    public boolean isReferenced() {
        return this.referenceCount > 0;
    }

    public void incrReferenceCount() {
        ++this.referenceCount;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public Member add(Point p) {
        this.points.add(p);
        return this;
    }

    public Member add(Number x, Number y) {
        return this.add(new Point(x, y));
    }

    public int size() {
        return this.points.size();
    }

    public List<Point> points() {
        return this.points;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toLogString() {
        StringBuilder sb = new StringBuilder();
        if (this.haveFunctionCall()) {
            Function func = this.getFunctionCall().getFunction();
            sb.append(this.getFunctionCall().toLogString()).append(" -> ");
        }
        sb.append("[");
        String delim = "";
        for (Point p : this.points()) {
            sb.append(delim).append("{").append(p.getX()).append(",").append(p.getY()).append("}");
            delim = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return "Member{name=" + this.name + '}';
    }

    public void calculateEndPoints(double start, double stop) {
        int end;
        Point p2;
        Point p1 = this.points.get(0);
        if (p1.getX().doubleValue() != start) {
            this.points.add(0, new Point(start, p1.getY()));
        }
        if ((p2 = this.points.get((end = this.points.size()) - 1)).getY().doubleValue() != stop) {
            this.points.add(end, new Point(stop, p2.getY()));
        }
    }

    void calculateFunctionAt(double x) {
        if (this.functionCall == null) {
            throw new FuzzerException(this.name + ": no function defined");
        }
        double value = this.functionCall.invoke(x);
        this.exploded.add(value);
    }

    void calculateValueAt(double x) {
        int len = this.points.size();
        for (int i = 1; i < len; ++i) {
            Point p1 = this.points.get(i - 1);
            Point p2 = this.points.get(i);
            if (!(x >= p1.getX().doubleValue()) || !(x <= p2.getX().doubleValue())) continue;
            double m = (p2.getY().doubleValue() - p1.getY().doubleValue()) / (p2.getX().doubleValue() - p1.getX().doubleValue());
            double b = p1.getY().doubleValue() - m * p1.getX().doubleValue();
            double interpolated = m * x + b;
            if (this.haveHedge()) {
                interpolated = this.getHedge().calculateValue(interpolated);
            }
            this.exploded.add(interpolated);
            return;
        }
    }

    double findMax() {
        double max = this.exploded.stream().reduce(Double.MIN_VALUE, (x, y) -> x > y ? x : y);
        return max;
    }

    void normalizeY(double yMax, int normMax) {
        this.exploded.forEach(y -> {
            int norm = (int)Math.round(y / yMax * (double)normMax);
            this.normalized.add(norm);
        });
    }

    public Collection<Double> exploded() {
        return this.exploded;
    }

    public List<Integer> normalized() {
        return this.normalized;
    }
}

