/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.Function;
import com.uwemeding.fuzzer.FunctionCall;
import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.Range;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;

public class PiecewiseFunction
extends Function {
    private final List<Range> ranges = new ArrayList<Range>();

    public PiecewiseFunction(String name, String argumentName) {
        super(name, argumentName);
    }

    public PiecewiseFunction add(String from, String to, String func) {
        Range range = new Range(from, to, func);
        this.ranges.add(range);
        return this;
    }

    @Override
    public double call(FunctionCall call, double arg) {
        MapContext context = new MapContext();
        call.parameterNames().forEach(arg_0 -> PiecewiseFunction.lambda$call$9((JexlContext)context, call, arg_0));
        context.set(call.getFunction().getArgumentName(), (Object)arg);
        Expression funcBody = null;
        for (Range r : this.ranges) {
            Double fromValue = 0.0;
            boolean fromMatch = r.haveFromExpr() ? arg >= (fromValue = (Double)r.getFromExpr().evaluate((JexlContext)context)) : true;
            Double toValue = 0.0;
            boolean toMatch = r.haveToExpr() ? arg <= (toValue = (Double)r.getToExpr().evaluate((JexlContext)context)) : fromMatch;
            if (!fromMatch || !toMatch) continue;
            String from = r.getFromExpr() == null ? "<" : r.getFromExpr().getExpression();
            String to = r.getToExpr() == null ? ">" : r.getToExpr().getExpression();
            System.out.print("match " + from + "->" + fromValue + " .. " + to + "->" + toValue + " for " + arg);
            funcBody = r.getFuncBody();
            break;
        }
        if (funcBody == null) {
            throw new FuzzerException(call.getFunction().getName() + ": no range found for " + arg);
        }
        Object result = funcBody.evaluate((JexlContext)context);
        System.out.println(" " + funcBody.getExpression() + " -> " + result);
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        throw new FuzzerException(this.getName() + ": unable to evaluate to number '" + funcBody.getExpression() + "'");
    }

    private static /* synthetic */ void lambda$call$9(JexlContext jexlContext, FunctionCall functionCall, String parameterName) {
        jexlContext.set(parameterName, (Object)functionCall.getParameter(parameterName).doubleValue());
    }
}

