/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.ExternalFunction;
import com.uwemeding.fuzzer.Function;
import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.Hedge;
import com.uwemeding.fuzzer.IdentifierHelper;
import com.uwemeding.fuzzer.NameBearer;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.PiecewiseFunction;
import com.uwemeding.fuzzer.ReasoningStrategy;
import com.uwemeding.fuzzer.Rule;
import com.uwemeding.fuzzer.Variable;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class Program {
    private static final Double EPSILON = 0.001;
    private final String name;
    private final Map<String, Hedge> hedges;
    private final Map<String, Function> functions;
    private final Map<String, Variable> inputs;
    private final Map<String, Variable> outputs;
    private final Map<String, Rule> rules;
    private String packageName;
    private ReasoningStrategy reasoningStrategy;
    private Number epsilon;
    private static final String FMT = "  %-15s : %15s %s%n";

    public Program(String name) {
        if (!IdentifierHelper.isValid(name)) {
            throw new FuzzerException(name + ": identifier illegal");
        }
        this.name = name;
        this.hedges = new HashMap<String, Hedge>();
        this.functions = new HashMap<String, Function>();
        this.inputs = new HashMap<String, Variable>();
        this.outputs = new HashMap<String, Variable>();
        this.rules = new HashMap<String, Rule>();
        this.reasoningStrategy = ReasoningStrategy.getDefault();
        this.epsilon = EPSILON;
    }

    public String getName() {
        return this.name;
    }

    public ReasoningStrategy getReasoningStrategy() {
        return this.reasoningStrategy;
    }

    public void setReasoningStrategy(ReasoningStrategy reasoningStrategy) {
        this.reasoningStrategy = reasoningStrategy;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Number getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(Number epsilon) {
        this.epsilon = epsilon;
    }

    public Rule addRule(String name, Node condition) {
        Rule rule = new Rule(name, condition);
        this.rules.put(name, rule);
        return rule;
    }

    public Collection<Rule> rules() {
        return this.rules.values();
    }

    public Collection<String> ruleNames() {
        return this.rules.keySet();
    }

    public Rule getRule(String name) {
        Rule rule = this.rules.get(name);
        if (rule == null) {
            throw new FuzzerException(name + ": rule not found");
        }
        return rule;
    }

    public Collection<Hedge> hedges() {
        return this.hedges.values();
    }

    public Hedge getHedge(String hedgeName) {
        return this.getItem(hedgeName, this.hedges, "hedge");
    }

    public Hedge addHedge(Hedge hedge) {
        this.addItem(hedge, this.hedges, "hedges");
        return hedge;
    }

    public Hedge addHedge(String name, String arg, String expression) {
        return this.addHedge(new Hedge(name, arg, expression));
    }

    public Collection<Function> functions() {
        return this.functions.values();
    }

    public Function getFunction(String functionName) {
        return this.getItem(functionName, this.functions, "function");
    }

    public <T extends Function> T addFunction(T function) {
        this.addItem(function, this.functions, "functions");
        return function;
    }

    public ExternalFunction addExternalFunction(String name, String argumentName) {
        return this.addFunction(new ExternalFunction(name, argumentName));
    }

    public PiecewiseFunction addPiecewiseFunction(String name, String argumentName) {
        return this.addFunction(new PiecewiseFunction(name, argumentName));
    }

    public Collection<Variable> inputs() {
        return this.inputs.values();
    }

    public Variable getInput(String inputName) {
        return this.getItem(inputName, this.inputs, "input");
    }

    public Variable addInput(Variable var) {
        this.checkUnique(var);
        this.addItem(var, this.inputs, "inputs");
        return var;
    }

    public <T extends Number> Variable addInput(String name, T from, T to, T step) {
        return this.addInput(new Variable(name, from, to, step));
    }

    public Collection<Variable> outputs() {
        return this.outputs.values();
    }

    public Variable getOutput(String outputName) {
        return this.getItem(outputName, this.outputs, "output");
    }

    public Variable addOutput(Variable var) {
        this.checkUnique(var);
        this.addItem(var, this.outputs, "outputs");
        return var;
    }

    public <T extends Number> Variable addOutput(String name, T from, T to, T step) {
        return this.addOutput(new Variable(name, from, to, step));
    }

    private void checkUnique(Variable var) {
        if (this.inputs.containsKey(var.getName())) {
            throw new FuzzerException(var.getName() + ": already defined");
        }
        if (this.outputs.containsKey(var.getName())) {
            throw new FuzzerException(var.getName() + ": already defined");
        }
    }

    private <T> T getItem(String itemName, Map<String, T> items, String typeName) {
        T item = items.get(itemName);
        if (item == null) {
            throw new FuzzerException(this.name + ": " + typeName + " '" + itemName + "' not found");
        }
        return item;
    }

    private <T extends NameBearer> void addItem(T item, Map<String, T> items, String typeName) {
        String itemName = item.getName();
        if (items.containsKey(itemName)) {
            throw new FuzzerException(this.name + ": '" + itemName + "' already present in " + typeName);
        }
        items.put(itemName, item);
    }

    public void dump(PrintStream fp) {
        fp.println("Program " + this.name);
        String dashes = "----------------------------------------------------------------------";
        fp.println(dashes);
        fp.format(FMT, "Name", "Type", "Content");
        fp.println(dashes);
        fp.println();
        TreeSet<String> names = new TreeSet<String>(this.hedges.keySet());
        names.forEach(name -> fp.format(FMT, name, "<hedge>", this.hedges.get(name).getExpressionString()));
        names = new TreeSet<String>(this.functions.keySet());
        names.forEach(name -> fp.format(FMT, name, "<func def>", this.functions.get(name).toLogString()));
        names = new TreeSet<String>(this.inputs.keySet());
        names.forEach(name -> this.dump(fp, this.inputs.get(name), "input"));
        names = new TreeSet<String>(this.outputs.keySet());
        names.forEach(name -> this.dump(fp, this.outputs.get(name), "output"));
        names = new TreeSet<String>(this.rules.keySet());
        names.forEach(name -> fp.format(FMT, name, "<rule>", this.rules.get(name)));
        fp.println();
        fp.println(dashes);
        fp.println();
    }

    private void dump(PrintStream fp, Variable var, String varType) {
        fp.format(FMT, var.getName(), "<" + varType + " var>", var.toLogString());
        if (var.members().isEmpty()) {
            return;
        }
        var.members().forEach(member -> fp.format(FMT, var.getName() + "#" + member.getName(), "<member>", member.toLogString()));
    }
}

