/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.Member;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.Program;
import com.uwemeding.fuzzer.RuleExpression;

public class ProgramEvaluator {
    private final Program program;

    public ProgramEvaluator(Program program) {
        this.program = program;
    }

    public void compileProgram() {
        this.program.inputs().forEach(var -> var.calculateFuzzySpace());
        this.program.outputs().forEach(var -> var.calculateFuzzySpace());
        this.program.rules().forEach(rule -> {
            this.updateMemberReferenceCount(rule.getCondition());
            rule.assignmentMembers().forEach(member -> member.incrReferenceCount());
        });
    }

    private void updateMemberReferenceCount(Node node) {
        switch (node.getNodeType()) {
            case AND: 
            case IN: 
            case OR: {
                RuleExpression expr = (RuleExpression)node.cast();
                this.updateMemberReferenceCount(expr.getLeft());
                this.updateMemberReferenceCount(expr.getRight());
                break;
            }
            case VARIABLE: {
                break;
            }
            case MEMBER: {
                Member member = (Member)node.cast();
                member.incrReferenceCount();
            }
        }
    }
}

