/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.Member;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.RuleConditions;
import com.uwemeding.fuzzer.Variable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class Rule {
    private final String name;
    private final Node condition;
    private final Map<Variable, Member> assignments;

    public Rule(String name, Node condition) {
        RuleConditions.checkNode(condition, Node.Type.IN, Node.Type.AND, Node.Type.OR);
        this.name = name;
        this.condition = condition;
        this.assignments = new TreeMap<Variable, Member>();
    }

    public String getName() {
        return this.name;
    }

    public Node getCondition() {
        return this.condition;
    }

    public Rule assign(Variable var, Member m) {
        this.assignments.put(var, m);
        return this;
    }

    public int assignmentCount() {
        return this.assignments.size();
    }

    public Collection<Variable> assignmentVariables() {
        return this.assignments.keySet();
    }

    public Collection<Member> assignmentMembers() {
        return this.assignments.values();
    }

    public Member getMember(Variable var) {
        return this.assignments.get(var);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "Rule{name=" + this.name + " cond=" + this.condition + '}';
    }
}

