/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.Member;
import com.uwemeding.fuzzer.NameBearer;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.RuleExpression;
import com.uwemeding.fuzzer.Variable;
import java.util.StringJoiner;

public class RuleConditions {
    public static Node createInCondition(Variable var, Node cond) {
        Member member;
        RuleConditions.checkNode(cond, Node.Type.MEMBER);
        switch (cond.getNodeType()) {
            case MEMBER: {
                member = (Member)cond.cast();
                break;
            }
            default: {
                throw new FuzzerException(cond + ": unexpected IN condition");
            }
        }
        if (!var.haveMember(member.getName())) {
            throw new FuzzerException(member.getName() + ": not a member of " + var.getName());
        }
        return new Condition(Node.Type.IN, var, cond);
    }

    public static Node createAndCondition(Node left, Node right) {
        RuleConditions.checkNode(left, Node.Type.IN, Node.Type.AND, Node.Type.OR);
        RuleConditions.checkNode(right, Node.Type.IN, Node.Type.AND, Node.Type.OR);
        return new Condition(Node.Type.AND, left, right);
    }

    public static Node createOrCondition(Node left, Node right) {
        RuleConditions.checkNode(left, Node.Type.IN, Node.Type.AND, Node.Type.OR);
        RuleConditions.checkNode(right, Node.Type.IN, Node.Type.AND, Node.Type.OR);
        return new Condition(Node.Type.OR, left, right);
    }

    public static void checkNode(Node node, Node.Type ... validTypes) {
        for (Node.Type type : validTypes) {
            if (node.getNodeType() != type) continue;
            return;
        }
        StringJoiner sj = new StringJoiner(", ");
        for (Node.Type type : validTypes) {
            sj.add(type.toString());
        }
        String nodeName = node.getNodeType().name();
        if (node instanceof NameBearer) {
            nodeName = ((NameBearer)((Object)node)).getName();
        }
        throw new FuzzerException(nodeName + ": invalid, must be one of " + sj.toString());
    }

    private static class Condition
    extends RuleExpression {
        private final Node.Type nodeType;
        private final Node left;
        private final Node right;

        protected Condition(Node.Type type, Node left, Node right) {
            this.nodeType = type;
            this.left = left;
            this.right = right;
        }

        @Override
        public Node.Type getNodeType() {
            return this.nodeType;
        }

        @Override
        public Node getLeft() {
            return this.left;
        }

        @Override
        public Node getRight() {
            return this.right;
        }

        private String nodeName(Node node) {
            if (node == null) {
                return "null";
            }
            String nodeName = node.getNodeType().name();
            if (node instanceof NameBearer) {
                nodeName = ((NameBearer)((Object)node)).getName();
            }
            return nodeName;
        }

        public String toString() {
            String leftName = this.nodeName(this.left);
            String rightName = this.nodeName(this.right);
            return "Condition{nodeType=" + (Object)((Object)this.nodeType) + ", left=" + this.left + ", right=" + this.right + '}';
        }
    }
}

