/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer;

import com.uwemeding.fuzzer.FunctionCall;
import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.Member;
import com.uwemeding.fuzzer.NameBearer;
import com.uwemeding.fuzzer.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Variable
extends Node
implements NameBearer,
Comparable {
    private final String name;
    private final Class<? extends Number> type;
    private final Number from;
    private final Number to;
    private final Number step;
    private final List<Member> members;
    private boolean calculated;
    private int totalSteps;

    public <T extends Number> Variable(String name, T from, T to, T step) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (from == null) {
            throw new NullPointerException(name + ": 'from' cannot be null");
        }
        if (to == null) {
            throw new NullPointerException(name + ": 'to' cannot be null");
        }
        if (step == null) {
            throw new NullPointerException(name + ": 'step' cannot be null");
        }
        this.name = name;
        this.type = Number.class;
        this.from = from;
        this.to = to;
        this.step = step;
        this.members = new ArrayList<Member>();
        this.calculated = false;
    }

    public <T extends Number> Variable(String name, T from, T to) {
        this(name, from, to, 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getTotalSteps() {
        if (this.calculated) {
            return this.totalSteps;
        }
        throw new FuzzerException("Must first calculate the fuzzy space");
    }

    @Override
    public Node.Type getNodeType() {
        return Node.Type.VARIABLE;
    }

    public Class<? extends Number> getType() {
        return this.type;
    }

    public <T extends Number> T getFrom() {
        return (T)this.from;
    }

    public <T extends Number> T getTo() {
        return (T)this.to;
    }

    public <T extends Number> T getStep() {
        return (T)this.step;
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Variable other = (Variable)obj;
        return Objects.equals(this.name, other.name);
    }

    public int compareTo(Object o) {
        Variable other = (Variable)o;
        return this.getName().compareTo(other.getName());
    }

    public boolean haveMember(String memberName) {
        return this.members.stream().anyMatch(member -> member.getName().equals(memberName));
    }

    public Member getMember(String memberName) {
        for (Member member : this.members) {
            if (!member.getName().equals(memberName)) continue;
            return member;
        }
        throw new FuzzerException(this.name + ": member '" + memberName + "' not found");
    }

    public boolean haveMember(String hedgeName, String memberName) {
        String fullName = hedgeName + "$" + memberName;
        return this.haveMember(fullName);
    }

    public Member getMember(String hedgeName, String memberName) {
        String fullName = hedgeName + "$" + memberName;
        return this.getMember(fullName);
    }

    public Member addMember(Member member) {
        if (this.haveMember(member.getName())) {
            throw new FuzzerException(member.getName() + ": member already exists of variable '" + this.name + "'");
        }
        this.members.add(member);
        return member;
    }

    public Member addMember(String memberName, FunctionCall functionCall) {
        if (this.haveMember(memberName)) {
            throw new FuzzerException(memberName + ": member already exists of variable '" + this.name + "'");
        }
        Member member = new Member(memberName, functionCall);
        this.members.add(member);
        return member;
    }

    public Member addMember(String memberName) {
        return this.addMember(memberName, null);
    }

    public Collection<Member> members() {
        return this.members;
    }

    public String toLogString() {
        int pos = this.type.getName().lastIndexOf(46);
        String dataTypeName = this.type.getName().substring(pos + 1);
        return dataTypeName + " [" + this.from + ", " + this.to + "] step by " + this.step;
    }

    public String toString() {
        return "Variable{name=" + this.name + '}';
    }

    public void calculateFuzzySpace() {
        double start = ((Number)this.getFrom()).doubleValue();
        double stop = ((Number)this.getTo()).doubleValue();
        double step = ((Number)this.getStep()).doubleValue();
        this.members().forEach(member -> {
            if (member.haveFunctionCall()) {
                for (double i = start; i <= stop; i += step) {
                    member.calculateFunctionAt(i);
                }
            } else {
                member.calculateEndPoints(start, stop);
                for (double i = start; i <= stop; i += step) {
                    member.calculateValueAt(i);
                }
            }
        });
        double yMax = Double.MIN_VALUE;
        for (Member member2 : this.members()) {
            double memberMax = member2.findMax();
            yMax = memberMax > yMax ? memberMax : yMax;
        }
        for (Member member2 : this.members()) {
            member2.normalizeY(yMax, 255);
            this.totalSteps = Math.max(this.totalSteps, member2.normalized().size());
        }
        this.calculated = true;
    }
}

