/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer.java;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Java {
    private static final String OP = "{";
    private static final String CP = "}";
    public static final int STANDARD = 1;
    public static final int SEPARATE = 2;
    private static int mode;
    private static File baseDir;
    private static final String DATE;
    private static final String YEAR;
    private static String COPYRIGHT;
    private static final Object lock;

    public static void setIndentMode(int indentMode) {
        mode = indentMode;
    }

    public static void setBaseDirectory(File path) {
        baseDir = path;
    }

    public static CLASS createClass(String type, String name) {
        CLASS c = new CLASS(type, name);
        return c;
    }

    public static INTERFACE createInterface(String type, String name) {
        INTERFACE c = new INTERFACE(type, name);
        return c;
    }

    public static synchronized void createSource(_ClassBody clazz) throws IOException {
        if (baseDir == null) {
            throw new IOException("Base directory for output not set, use 'setBaseDirectory'");
        }
        String pkg = clazz.getPackage();
        if (pkg == null) {
            pkg = "";
        }
        pkg = pkg.replace('.', '/');
        File path = new File(baseDir, pkg);
        path.mkdirs();
        try (PrintWriter fp = new PrintWriter(new FileWriter(new File(path, clazz.getName() + ".java")));){
            clazz.emit(0, fp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emitCommentIndentN(PrintWriter fp, String text, int indent, boolean type) {
        Object object = lock;
        synchronized (object) {
            String cc = type ? "/**" : "/*";
            fp.println(cc);
            String comment = Java.emitCommentIndentNOnly(fp, text, indent);
            fp.println(comment + "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emitOneLineCommentIndentN(PrintWriter fp, String text, int indent) {
        Object object = lock;
        synchronized (object) {
            fp.println("// " + text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void emitFinishCommentIndentN(PrintWriter fp, int indent) {
        String spaces = "                                                                   ";
        Object object = lock;
        synchronized (object) {
            String comment = "                                                                   ".substring(0, indent) + " */";
            fp.println(comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String emitCommentIndentNOnly(PrintWriter fp, String text, int indent) {
        Object object = lock;
        synchronized (object) {
            return Java.emitCommentIndentNOnly(fp, text, indent, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String emitCommentIndentNOnly(PrintWriter fp, String text, int indent, boolean cooked) {
        String spaces = "                                                                   ";
        Object object = lock;
        synchronized (object) {
            boolean loop;
            String is = "                                                                   ".substring(0, indent);
            String comment = is + " *";
            boolean bl = loop = text.length() > 1;
            while (loop) {
                char start = text.charAt(0);
                int spos = 0;
                int count = 0;
                for (int i = 1; i < text.length(); ++i) {
                    if (start == text.charAt(i)) {
                        ++count;
                        continue;
                    }
                    if (count > 5) break;
                    start = text.charAt(i);
                    spos = i;
                    count = 0;
                }
                if (count > 5) {
                    String ntext = text.substring(0, spos);
                    text = ntext = ntext + text.substring(spos + count + 1);
                    continue;
                }
                loop = false;
            }
            int len = 2;
            fp.print(comment);
            StringTokenizer st = new StringTokenizer(text, " \r\n");
            String word = ".";
            while (st.hasMoreTokens()) {
                word = st.nextToken();
                if (len + word.length() > 60) {
                    fp.println();
                    fp.print(comment);
                    len = 2;
                }
                fp.print(" ");
                fp.print(word);
                len += word.length();
            }
            if (cooked && word.charAt(word.length() - 1) != '.') {
                fp.println(".");
            } else {
                fp.println();
            }
            return comment;
        }
    }

    static {
        lock = new Object();
        SimpleDateFormat DAY_FMT = new SimpleDateFormat("MM/dd/yyyy");
        DATE = DAY_FMT.format(new Date());
        SimpleDateFormat YEAR_FMT = new SimpleDateFormat("yyyy");
        YEAR = YEAR_FMT.format(new Date());
        COPYRIGHT = "Copyright (c) " + YEAR + " Meding Software Technik -- All Rights Reserved.";
        mode = 1;
    }

    public static class _ClassBody
    extends _ClassBlock
    implements _Statement,
    _NeedBlock {
        protected List<String> impls;
        private final String type;
        private final String name;
        private String comment;
        private String packageName;
        protected String extendName;
        private final Set<String> imports;
        private boolean topLevel;
        private String author;
        private String version;
        private String since;

        public _ClassBody(String type, String name) {
            this.type = type.trim();
            this.name = name.trim();
            this.impls = new ArrayList<String>();
            this.imports = new TreeSet<String>();
            this.topLevel = true;
        }

        public String getName() {
            return this.name;
        }

        public void setComment(String comment) {
            if (comment != null) {
                this.comment = comment.trim();
            }
        }

        public void setTopLevel(boolean topLevel) {
            this.topLevel = topLevel;
        }

        public void addIMPORT(String name) {
            if (name != null) {
                this.imports.add(name);
            }
        }

        public void addIMPORT(String[] names) {
            if (names == null) {
                return;
            }
            for (String name1 : names) {
                this.addIMPORT(name1);
            }
        }

        public void setPackage(String packageName) {
            this.packageName = packageName.trim();
        }

        public String getPackage() {
            return this.packageName;
        }

        public void setAuthor(String author) {
            this.author = author.trim();
        }

        public void setVersion(String version) {
            this.version = version.trim();
        }

        public void setSince(String since) {
            this.since = since.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (this.topLevel) {
                Java.emitCommentIndentN(fp, COPYRIGHT, 0, false);
                fp.println();
                if (this.packageName != null) {
                    fp.println("package " + this.packageName + ";");
                }
                fp.println();
                for (String i : this.imports) {
                    fp.println("import " + i + ";");
                }
                fp.println();
            }
            fp.println("/**");
            if (this.comment == null) {
                this.comment = "Description of the class.";
            }
            Java.emitCommentIndentNOnly(fp, this.comment, indent);
            if (this.version != null) {
                Java.emitCommentIndentNOnly(fp, "@version " + this.version, indent, false);
            }
            if (this.author != null) {
                Java.emitCommentIndentNOnly(fp, "@author " + this.author, indent, false);
            }
            if (this.since != null) {
                Java.emitCommentIndentNOnly(fp, "@since " + this.since, indent, false);
            }
            Java.emitFinishCommentIndentN(fp, indent);
            this.emitIndent(indent, fp);
            if (this instanceof _IsInterface) {
                fp.print(this.type + " interface " + this.name);
            } else {
                fp.print(this.type + " class " + this.name);
            }
            if (this.extendName != null) {
                fp.println();
                this.emitIndent(indent + 4, fp);
                fp.print("extends " + this.extendName);
            }
            if (this.impls.size() > 0) {
                fp.println();
                this.emitIndent(indent + 4, fp);
                if (this instanceof _IsInterface) {
                    fp.print("extends ");
                } else {
                    fp.print("implements ");
                }
                String delim = "";
                for (String name : this.impls) {
                    fp.print(delim + name);
                    delim = ", ";
                }
            }
            super.emit(indent, fp);
        }
    }

    public static class CLASS
    extends _ClassBody
    implements _Statement,
    _NeedBlock {
        String name;

        public CLASS(String type, String name) {
            super(type, name);
            this.name = name;
        }

        public void addIMPL(String name) {
            this.impls.add(name);
        }

        public void addIMPL(String[] names) {
            if (names == null) {
                return;
            }
            for (String name1 : names) {
                this.addIMPL(name1);
            }
        }

        public void setExtends(String name) {
            this.extendName = name;
        }

        public METHOD addCLINIT() {
            METHOD f = new METHOD(null, null, null);
            f.setIsCLinit(true);
            this.add(f);
            return f;
        }

        public METHOD addCTOR(String modifier) {
            METHOD f = new METHOD(modifier, null, this.name);
            this.add(f);
            return f;
        }

        public METHOD addMETHOD(String retType, String name) {
            METHOD f = new METHOD(null, retType, name);
            this.add(f);
            return f;
        }

        public void addProperty(String type, String name, String def, boolean readOnly) {
            VAR var = this.addVAR("private", type, name, def);
            String getMethod = this.makeGetter(name);
            String setMethod = this.makeSetter(name);
            METHOD getter = this.addMETHOD("public", type, getMethod);
            getter.setComment("Get " + name);
            getter.addS("return this." + name);
            if (!readOnly) {
                METHOD setter = this.addMETHOD("public", "void", setMethod);
                setter.setComment("Set " + name);
                setter.addArg(type, name, name);
                setter.addS("this." + name + "=" + name);
            }
        }

        public void addProperty(String type, String name, String def) {
            this.addProperty(name, type, def, false);
        }

        public void addReadOnlyProperty(String type, String name, String def) {
            this.addProperty(name, type, def, true);
        }

        public METHOD addMETHOD(String modifier, String retType, String name) {
            METHOD f = modifier.indexOf("abstract") < 0 ? new METHOD(modifier, retType, name, false) : new METHOD(modifier, retType, name, true);
            this.add(f);
            return f;
        }

        private String makeGetter(String attr) {
            StringBuilder sb = new StringBuilder(attr.length() + 3);
            sb.append("get");
            sb.append(attr.substring(0, 1).toUpperCase());
            sb.append(attr.substring(1));
            return sb.toString();
        }

        private String makeSetter(String attr) {
            StringBuilder sb = new StringBuilder(attr.length() + 3);
            sb.append("set");
            sb.append(attr.substring(0, 1).toUpperCase());
            sb.append(attr.substring(1));
            return sb.toString();
        }
    }

    public static class INTERFACE
    extends _ClassBody
    implements _Statement,
    _NeedBlock,
    _IsInterface {
        public INTERFACE(String type, String name) {
            super(type, name);
        }

        public void addEXTENDS(String name) {
            this.impls.add(name);
        }

        public void addEXTENDS(String[] names) {
            if (names == null) {
                return;
            }
            for (String name : names) {
                this.addEXTENDS(name);
            }
        }

        public METHOD addMETHOD(String retType, String name) {
            METHOD f = new METHOD(null, retType, name, true);
            this.add(f);
            return f;
        }
    }

    public static class Arg {
        private String type;
        private String name;
        private String comment;

        public Arg(String type, String name) {
            if (type == null) {
                throw new NullPointerException("Argument type cannot be null");
            }
            this.type = type;
            if (name == null) {
                throw new NullPointerException("Argument name cannot be null");
            }
            this.name = name.trim();
        }

        public Arg(String type, String name, String comment) {
            this(type, name);
            this.comment = comment.trim();
        }

        public void emit(PrintWriter fp) {
            fp.print(this.type + " " + this.name);
        }

        public void emitComment(int indent, PrintWriter fp) {
            if (this.comment == null) {
                this.comment = "is " + this.type;
            }
            Java.emitCommentIndentNOnly(fp, "@param " + this.name + " " + this.comment, indent, false);
        }
    }

    public static class Throw {
        private String name;
        private String comment;

        public Throw(String name) {
            if (name == null) {
                throw new NullPointerException("Throw name cannot be null");
            }
            this.name = name.trim();
        }

        public Throw(String name, String comment) {
            this(name);
            this.comment = comment.trim();
        }

        public void emit(PrintWriter fp) {
            fp.print(this.name);
        }

        public void emitComment(int indent, PrintWriter fp) {
            if (this.comment == null) {
                this.comment = "";
            }
            Java.emitCommentIndentNOnly(fp, "@throws " + this.name + " " + this.comment, indent, false);
        }
    }

    public static class METHOD
    extends _StatementBlock
    implements _Statement,
    _NeedBlock {
        private List<Arg> args;
        private List<Throw> thrws;
        private String modifier;
        private String retType;
        private String methodName;
        private String comment;
        private boolean isInterface;
        private String returns;
        private boolean isCLinit;

        public METHOD(String modifier, String retType, String methodName) {
            this.modifier = modifier == null ? "" : modifier.trim() + " ";
            this.retType = retType == null ? "" : retType.trim();
            if (methodName == null) {
                methodName = "";
            }
            this.methodName = methodName.trim();
            this.args = new ArrayList<Arg>();
            this.thrws = new ArrayList<Throw>();
        }

        public METHOD(String modifier, String retType, String methodName, boolean isInterface) {
            this(modifier, retType, methodName);
            this.isInterface = isInterface;
        }

        public void setIsCLinit(boolean mode) {
            this.isCLinit = mode;
        }

        public boolean isCLinit() {
            return this.isCLinit;
        }

        public void setComment(String comment) {
            if (comment != null) {
                this.comment = comment.trim();
            }
        }

        public void setReturnComment(String comment) {
            if (comment != null) {
                this.returns = comment.trim();
            }
        }

        public void addArg(String type, String name) {
            this.args.add(new Arg(type, name));
        }

        public void addArg(String type, String name, String comment) {
            this.args.add(new Arg(type, name, comment));
        }

        public void addTHROWS(String name) {
            this.thrws.add(new Throw(name));
        }

        public void addTHROWS(String name, String comment) {
            this.thrws.add(new Throw(name, comment));
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.println();
            this.emitIndent(indent, fp);
            fp.println("/**");
            if (this.isCLinit()) {
                if (this.comment == null) {
                    this.comment = "Static initializer";
                }
                Java.emitCommentIndentNOnly(fp, this.comment, indent);
            } else {
                if (this.comment == null) {
                    this.comment = "Description of the method.";
                }
                Java.emitCommentIndentNOnly(fp, this.comment, indent);
                for (Arg arg : this.args) {
                    arg.emitComment(indent, fp);
                }
                if (this.retType.length() > 0 && this.retType.indexOf("void") < 0) {
                    String c = this.returns == null ? "a " + this.retType : this.returns;
                    Java.emitCommentIndentNOnly(fp, "@return " + c, indent, false);
                }
                if (this.thrws.size() > 0) {
                    for (Throw thrw : this.thrws) {
                        thrw.emitComment(indent, fp);
                    }
                }
            }
            Java.emitFinishCommentIndentN(fp, indent);
            this.emitIndent(indent, fp);
            if (this.isCLinit()) {
                fp.print("static ");
            } else {
                fp.print(this.modifier + this.retType + " " + this.methodName + "(");
                String delim = "";
                for (Arg arg : this.args) {
                    fp.print(delim);
                    arg.emit(fp);
                    delim = ", ";
                }
                fp.print(")");
                if (this.thrws.size() > 0) {
                    fp.println();
                    this.emitIndent(indent + 4, fp);
                    fp.print("throws ");
                    delim = "";
                    for (Throw thrw : this.thrws) {
                        fp.print(delim);
                        delim = ", ";
                        thrw.emit(fp);
                    }
                }
            }
            if (this.isInterface) {
                fp.println(";");
            } else {
                if (mode != 2) {
                    fp.print(" ");
                }
                super.emit(indent, fp);
            }
        }
    }

    public static class VAR
    extends _ClassBlock
    implements _Statement,
    _NoBlock {
        private String modifier;
        private String type;
        private String name;
        private String init;
        private String comment;
        private boolean isClassVar;

        public VAR(boolean isClassVar, String modifier, String type, String name) {
            this.modifier = modifier == null ? null : modifier.trim();
            this.type = type.trim();
            this.name = name.trim();
            this.isClassVar = isClassVar;
        }

        public VAR(boolean isClassVar, String modifier, String type, String name, String init) {
            this(isClassVar, modifier, type, name);
            this.init = init.trim();
        }

        public void setComment(String comment) {
            if (comment != null) {
                this.comment = comment.trim();
            }
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            boolean jdoc;
            boolean bl = jdoc = this.type.indexOf("private") < 0;
            if (this.comment != null) {
                Java.emitCommentIndentN(fp, this.comment, indent, jdoc);
                if (this.isClassVar) {
                    super.emitIndent(indent, fp);
                }
            }
            if (this.modifier == null) {
                fp.print(this.type + " " + this.name);
            } else {
                fp.print(this.modifier + " " + this.type + " " + this.name);
            }
            if (this.init != null) {
                fp.print(" = " + this.init);
            }
            fp.println(";");
        }
    }

    public static class CATCH
    extends _StatementBlock
    implements _Statement,
    _NeedBlock {
        private String ex;
        private String name;
        private boolean fin;

        public CATCH() {
            this.fin = true;
        }

        public CATCH(String ex, String name) {
            this.ex = ex.trim();
            this.name = name.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (this.fin) {
                fp.print("finally");
            } else {
                fp.print("catch(" + this.ex + " " + this.name + ")");
            }
            super.emit(indent, fp);
        }
    }

    public static class TRY
    extends _StatementBlock
    implements _Statement,
    _NeedBlock {
        _StatementBlock parent;

        public TRY(_StatementBlock sb) {
            this.parent = sb;
        }

        public CATCH addCATCH(String ex, String name) {
            CATCH c = new CATCH(ex, name);
            this.parent.add(c);
            return c;
        }

        public CATCH addFINALLY() {
            CATCH c = new CATCH();
            this.parent.add(c);
            return c;
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.print("try");
            super.emit(indent, fp);
        }
    }

    public static class DOWHILE
    extends _StatementBlock
    implements _Statement,
    _NeedSomething {
        private String condition;

        public DOWHILE(String condition) {
            if (condition == null) {
                throw new NullPointerException("condition cannot be null");
            }
            this.condition = condition.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.print("do");
            super.emit(indent, fp);
            super.emitIndent(indent, fp);
            fp.println("while(" + this.condition + ");");
        }
    }

    public static class CASE
    extends _StatementBlock
    implements _Statement {
        private String condition;
        private boolean defCase;
        private boolean fallThru;

        public CASE(String condition) {
            if (condition == null) {
                throw new NullPointerException("condition cannot be null");
            }
            this.condition = condition.trim();
        }

        public void setFallThru(boolean fallThru) {
            this.fallThru = fallThru;
        }

        public void setDefault(boolean defCase) {
            this.defCase = defCase;
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (this.defCase) {
                fp.print("default:");
            } else {
                fp.print("case " + this.condition + ":");
            }
            if (this instanceof _NeedBlock && mode == 2) {
                super.emitIndent(indent + 4, fp);
            }
            super.emit(indent, fp);
            super.emitIndent(indent + 4, fp);
            if (this.fallThru) {
                fp.println("// fall through ");
            } else {
                fp.println("break;");
            }
        }
    }

    public static class CaseNoBlock
    extends CASE
    implements _NoBlock,
    _NoIndent {
        public CaseNoBlock(String cond) {
            super(cond);
        }
    }

    public static class CaseBlock
    extends CASE
    implements _NeedBlock {
        public CaseBlock(String cond) {
            super(cond);
        }
    }

    public static class SWITCH
    extends _StatementBlock
    implements _Statement,
    _NeedBlock {
        private String condition;

        public SWITCH(String condition) {
            if (condition == null) {
                throw new NullPointerException("condition cannot be null");
            }
            this.condition = condition.trim();
        }

        public CASE addCASE(String cond) {
            return this.addCASE(false, cond);
        }

        public CASE addCASE(boolean block, String cond) {
            CASE w = block ? new CaseBlock(cond) : new CaseNoBlock(cond);
            this.add(w);
            return w;
        }

        public CASE addDEFAULT() {
            return this.addDEFAULT(false);
        }

        public CASE addDEFAULT(boolean block) {
            CASE c = this.addCASE(block, "");
            c.setDefault(true);
            return c;
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.print("switch(" + this.condition + ")");
            super.emit(indent, fp);
        }
    }

    public static class WHILE
    extends _StatementBlock
    implements _Statement,
    _NeedSomething {
        private String condition;

        public WHILE(String condition) {
            if (condition == null) {
                throw new NullPointerException("condition cannot be null");
            }
            this.condition = condition.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.print("while(" + this.condition + ")");
            super.emit(indent, fp);
        }
    }

    public static class ELSE
    extends _StatementBlock
    implements _Statement,
    _NeedSomething {
        private String cond;
        private boolean just_else;

        public ELSE() {
            this.just_else = true;
        }

        public ELSE(String cond) {
            this.cond = cond.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (mode == 2) {
                if (this.just_else) {
                    fp.print("else");
                } else {
                    fp.println("else");
                    this.emitIndent(indent, fp);
                    fp.print("if(" + this.cond + ")");
                }
                super.emit(indent, fp);
            } else {
                if (this.just_else) {
                    fp.print("else");
                } else {
                    fp.print("else if(" + this.cond + ")");
                }
                super.emit(indent, fp);
            }
        }
    }

    public static class IF
    extends _StatementBlock
    implements _Statement,
    _NeedSomething {
        private _StatementBlock parent;
        private String condition;

        public IF(_StatementBlock parent, String condition) {
            this.parent = parent;
            if (condition == null) {
                throw new NullPointerException("condition cannot be null");
            }
            this.condition = condition.trim();
        }

        public ELSE addELSE() {
            ELSE e = new ELSE();
            this.parent.add(e);
            return e;
        }

        public ELSE addELSEIF(String cond) {
            ELSE e = new ELSE(cond);
            this.parent.add(e);
            return e;
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.print("if(" + this.condition + ")");
            super.emit(indent, fp);
        }
    }

    public static class FOR
    extends _StatementBlock
    implements _Statement,
    _NeedSomething {
        private String start;
        private String condition;
        private String iter;

        public FOR(String start, String condition, String iter) {
            this.start = start == null ? "" : start.trim();
            this.condition = condition == null ? "" : condition.trim();
            this.iter = iter == null ? "" : iter.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.print("for(" + this.start + "; " + this.condition + "; " + this.iter + ")");
            super.emit(indent, fp);
        }
    }

    public static class C
    implements _Statement {
        private String s;
        private boolean oneLine;

        public C(boolean oneLine, String s) {
            this.s = s.trim();
            this.oneLine = oneLine;
        }

        public C(String s) {
            this(false, s);
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (this.oneLine) {
                Java.emitOneLineCommentIndentN(fp, this.s, indent);
            } else {
                Java.emitCommentIndentN(fp, this.s, indent, false);
            }
        }
    }

    public static class RETURN
    implements _Statement,
    _NoBlock {
        private String expr;

        public RETURN(String expr) {
            this.expr = expr.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (mode == 2) {
                fp.println("return " + this.expr + ";");
            } else {
                fp.println("return " + this.expr + ";");
            }
        }
    }

    public static class LABEL
    implements _Statement,
    _NoIndent,
    _NoBlock {
        private String s;

        public LABEL(String s) {
            this.s = s.trim();
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            fp.println(this.s + ":");
        }
    }

    public static class Line
    implements _Statement {
        private String s;

        public Line(String s) {
            this.s = s;
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (this.s == null) {
                fp.println();
            } else {
                fp.println(this.s);
            }
        }
    }

    public static class S
    implements _Statement {
        private String s;

        public S(String s) {
            if (s != null) {
                this.s = s.trim();
            }
        }

        @Override
        public void emit(int indent, PrintWriter fp) {
            if (this.s == null) {
                fp.println();
            } else {
                fp.println(this.s + ";");
            }
        }
    }

    public static class _StatementBlock
    extends _Block {
        public VAR addVAR(String modifier, String type, String name) {
            VAR v = new VAR(false, modifier, type, name);
            this.add(v);
            return v;
        }

        public VAR addVAR(String modifier, String type, String name, String init) {
            VAR v = new VAR(false, modifier, type, name, init);
            this.add(v);
            return v;
        }

        public void addS(String s) {
            S stmt = new S(s);
            this.add(stmt);
        }

        public void addLine() {
            this.addLine("");
        }

        public void addLine(String s) {
            Line stmt = new Line(s);
            this.add(stmt);
        }

        public void addRETURN(String expr) {
            RETURN r = new RETURN(expr);
            this.add(r);
        }

        public void addLABEL(String s) {
            LABEL l = new LABEL(s);
            this.add(l);
        }

        public FOR addFOR(String start, String condition, String iter) {
            FOR f = new FOR(start, condition, iter);
            this.add(f);
            return f;
        }

        public IF addIF(String cond) {
            IF i = new IF(this, cond);
            this.add(i);
            return i;
        }

        public WHILE addWHILE(String cond) {
            WHILE w = new WHILE(cond);
            this.add(w);
            return w;
        }

        public SWITCH addSWITCH(String cond) {
            SWITCH w = new SWITCH(cond);
            this.add(w);
            return w;
        }

        public DOWHILE addDOWHILE(String cond) {
            DOWHILE w = new DOWHILE(cond);
            this.add(w);
            return w;
        }

        public TRY addTRY() {
            TRY t = new TRY(this);
            this.add(t);
            return t;
        }
    }

    public static class _ClassBlock
    extends _Block {
        public CLASS addCLASS(String type, String name) {
            CLASS c = new CLASS(type, name);
            c.setTopLevel(false);
            this.add(c);
            return c;
        }

        public INTERFACE addINTERFACE(String type, String name) {
            INTERFACE c = new INTERFACE(type, name);
            c.setTopLevel(false);
            this.add(c);
            return c;
        }

        public VAR addVAR(String modifier, String type, String name) {
            VAR v = new VAR(true, modifier, type, name);
            this.add(v);
            return v;
        }

        public VAR addVAR(String modifier, String type, String name, String init) {
            VAR v = init == null ? new VAR(true, modifier, type, name) : new VAR(true, modifier, type, name, init);
            this.add(v);
            return v;
        }
    }

    public static class _Block
    extends ArrayList<_Statement> {
        public void addC(String s) {
            C stmt = new C(s);
            this.add(stmt);
        }

        public void addC(boolean oneLine, String s) {
            C stmt = new C(oneLine, s);
            this.add(stmt);
        }

        public void emitIndent(int indent, PrintWriter fp) {
            String spaces = "                                                               ";
            fp.print("                                                               ".substring(0, indent));
        }

        public void emit(int indent, PrintWriter fp) {
            if (!(this instanceof _NoBlock) && (this.size() > 0 || this instanceof _NeedBlock)) {
                if (mode == 2) {
                    fp.println();
                    if (this.size() > 1 || this instanceof _NeedBlock) {
                        this.emitIndent(indent, fp);
                    }
                } else if (this.size() > 1 || this instanceof _NeedBlock) {
                    fp.print(" ");
                } else {
                    fp.println();
                }
                if (this.size() > 1 || this instanceof _NeedBlock) {
                    fp.println(Java.OP);
                }
            }
            if (this.size() == 0 && this instanceof _NeedSomething) {
                S s = new S("");
                fp.println();
                this.emitIndent(indent + 4, fp);
                s.emit(indent + 4, fp);
            } else {
                for (_Statement s : this) {
                    if (s instanceof _NoIndent) {
                        this.emitIndent(indent, fp);
                        s.emit(indent, fp);
                        continue;
                    }
                    this.emitIndent(indent + 4, fp);
                    s.emit(indent + 4, fp);
                }
            }
            if (!(this instanceof _NoBlock) && (this.size() > 1 || this instanceof _NeedBlock)) {
                this.emitIndent(indent, fp);
                fp.println(Java.CP);
            }
        }
    }

    static interface _IsInterface {
    }

    static interface _NoIndent {
    }

    static interface _NeedSomething {
    }

    static interface _NeedBlock {
    }

    static interface _NoBlock {
    }

    static interface _Statement {
        public void emit(int var1, PrintWriter var2);
    }
}

