/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer.java;

import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.FuzzerOutput;
import com.uwemeding.fuzzer.Member;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.Program;
import com.uwemeding.fuzzer.Rule;
import com.uwemeding.fuzzer.RuleExpression;
import com.uwemeding.fuzzer.Variable;
import com.uwemeding.fuzzer.java.Java;
import com.uwemeding.fuzzer.java.NameMap;
import java.io.File;
import java.io.IOException;

public class JavaOutputType
implements FuzzerOutput {
    private final NameMap nameMap = new NameMap();

    @Override
    public void createOutput(String output, Program program) {
        try {
            this.nameMap.clear();
            this.createProgram(output, program);
        }
        catch (IOException ex) {
            throw new FuzzerException(ex);
        }
    }

    private void createProgram(String outputdir, Program program) throws IOException {
        Java.CLASS clazz = Java.createClass("public", program.getName());
        if (program.getPackageName() != null) {
            clazz.setPackage(program.getPackageName());
        }
        Java.METHOD ctor = clazz.addCTOR("public");
        ctor.setComment("Construct a fuzzy object");
        Java.METHOD method = clazz.addMETHOD("public", "CRISP", "calculate");
        method.setComment("Calculate new values");
        program.inputs().forEach(v -> method.addArg("Number", v.getName(), v.toLogString()));
        program.outputs().forEach(v -> method.addS("double[] " + v.getName() + " = new double[" + v.getTotalSteps() + "]"));
        program.rules().forEach(rule -> {
            method.addC(true, rule.getName());
            String varName = this.addCondition(method, (Rule)rule, rule.getCondition());
            rule.assignmentVariables().forEach(output -> {
                Member member = rule.getMember((Variable)output);
                String frv = output.getName() + "$" + member.getName();
                Java.IF fire = method.addIF("Math.abs(" + varName + ".doubleValue()) > " + program.getEpsilon());
                fire.addC(true, "assign " + output.getName() + " to " + member.getName());
                Java.FOR fout = fire.addFOR("int i = 0", "i<" + output.getTotalSteps(), "i++");
                fout.addS("Number map = (double)" + frv + "[i] / 255.0");
                fout.addS("map = rs(" + varName + ", map)");
                fout.addS(output.getName() + "[i] = Math.max(" + output.getName() + "[i], map.doubleValue())");
            });
        });
        method.addLine();
        method.addC(true, "Calculate the crisp values");
        method.addLine("CRISP crisp = new CRISP(");
        int noutputs = program.outputs().size();
        for (Variable v2 : program.outputs()) {
            String delim = --noutputs > 0 ? "," : "";
            method.addLine("    calculateCrispValue(" + v2.getFrom() + ", " + v2.getTo() + ", " + v2.getStep() + ", " + v2.getName() + ")" + delim);
        }
        method.addLine(");");
        method.addRETURN("crisp");
        this.addIntegerRoundingMethod(clazz);
        this.addReasoningMethod(clazz, program);
        this.addFindAssociation(clazz);
        this.addCalculateCrispValue(program, clazz);
        this.addCrispOutputs(clazz, program);
        clazz.addC(true, "======== INPUTS =========");
        program.inputs().forEach(v -> v.members().forEach(m -> {
            if (m.isReferenced()) {
                String varName = v.getName() + "$" + m.getName();
                String content = this.createNormalized((Member)m);
                Java.VAR var = clazz.addVAR("private final", "int[]", varName, content);
                var.setComment("Variable: " + v.getName() + " Member: " + m.getName());
            }
        }));
        clazz.addC(true, "======== OUTPUTS =========");
        program.outputs().forEach(v -> v.members().forEach(m -> {
            if (m.isReferenced()) {
                String varName = v.getName() + "$" + m.getName();
                String content = this.createNormalized((Member)m);
                Java.VAR var = clazz.addVAR("private final", "int[]", varName, content);
                var.setComment("Variable: " + v.getName() + " Member: " + m.getName());
            }
        }));
        Java.setBaseDirectory(new File(outputdir));
        Java.createSource(clazz);
    }

    private String addCondition(Java.METHOD method, Rule rule, Node node) {
        switch (node.getNodeType()) {
            case IN: {
                RuleExpression in = (RuleExpression)node.cast();
                Variable var = (Variable)in.getLeft().cast();
                Member member = (Member)in.getRight().cast();
                String varName = this.nameMap.map(rule.getName() + "_" + var.getName() + "_in_" + member.getName());
                this.callFindAssociation(method, varName, var, member);
                return varName;
            }
            case OR: 
            case AND: {
                RuleExpression comb = (RuleExpression)node.cast();
                String l = this.addCondition(method, rule, comb.getLeft());
                String r = this.addCondition(method, rule, comb.getRight());
                String varName = this.nameMap.map(rule.getName() + "_" + l + "_" + (Object)((Object)node.getNodeType()) + "_" + r);
                String op = node.getNodeType() == Node.Type.OR ? "Math.max" : "Math.min";
                method.addS("Number " + varName + " = " + op + "(" + l + ".doubleValue(), " + r + ".doubleValue())");
                return varName;
            }
        }
        throw new FuzzerException((Object)((Object)node.getNodeType()) + ": unable to process");
    }

    private void addCrispOutputs(Java.CLASS clazz, Program program) {
        Java.CLASS crispClass = clazz.addCLASS("public static", "CRISP");
        crispClass.setComment("Crisp output values");
        program.outputs().forEach(v -> crispClass.addVAR("private final", "Number", v.getName()));
        Java.METHOD crispCtor = crispClass.addCTOR("private");
        crispCtor.setComment("Create crisp output values");
        program.outputs().forEach(v -> {
            crispCtor.addArg("Number", v.getName(), v.getName() + " crisp value");
            crispCtor.addS("this." + v.getName() + " = " + v.getName());
        });
        program.outputs().forEach(v -> {
            String getterName = this.makeGetter(v.getName());
            Java.METHOD getter = crispClass.addMETHOD("public", "Number", getterName);
            getter.setComment("Get the " + v.getName() + " crisp value");
            getter.setReturnComment("the " + v.getName() + " crisp value");
            getter.addRETURN(v.getName());
        });
    }

    private String makeGetter(String attr) {
        StringBuilder sb = new StringBuilder(attr.length() + 3);
        sb.append("get");
        sb.append(attr.substring(0, 1).toUpperCase());
        sb.append(attr.substring(1));
        return sb.toString();
    }

    private void addIntegerRoundingMethod(Java.CLASS clazz) {
        Java.METHOD iround = clazz.addMETHOD("private", "int", "iround");
        iround.setComment("Round to the nearest integer");
        iround.setReturnComment("the nearest integer");
        iround.addArg("Number", "value", "value to be rounded");
        iround.addRETURN("(int)Math.round(value.doubleValue())");
    }

    private void addReasoningMethod(Java.CLASS clazz, Program program) throws FuzzerException {
        Java.METHOD rs = clazz.addMETHOD("private", "Number", "rs");
        rs.setComment("Reasoning strategy is " + program.getReasoningStrategy().getName());
        rs.setReturnComment("the reasoned value");
        rs.addArg("Number", "a", "strength value");
        rs.addArg("Number", "b", "mapped value");
        switch (program.getReasoningStrategy()) {
            case MAXDOT: {
                rs.addRETURN("a.doubleValue() * b.doubleValue()");
                break;
            }
            case MAXMIN: {
                rs.addRETURN("a.doubleValue() < b.doubleValue() ? a : b");
                break;
            }
            default: {
                throw new FuzzerException((Object)((Object)program.getReasoningStrategy()) + ": not implemented");
            }
        }
    }

    private void addCalculateCrispValue(Program program, Java.CLASS clazz) {
        Java.METHOD calc = clazz.addMETHOD("private", "Number", "calculateCrispValue");
        calc.setComment("Calculate the crisp value");
        calc.setReturnComment("the crisp value");
        calc.addArg("Number", "from", "Start interval");
        calc.addArg("Number", "to", "End interval");
        calc.addArg("Number", "step", "Interval step");
        calc.addArg("double[]", "fuzzy", "Fuzzy value");
        calc.addS("double area = 0.0");
        calc.addS("double moment = 0.0");
        Java.FOR fout = calc.addFOR("int i = 0", "i < fuzzy.length", "i++");
        fout.addS("double normalized = from.doubleValue() + (step.doubleValue() * i)");
        fout.addS("area += fuzzy[i]");
        fout.addS("moment += fuzzy[i] * normalized");
        calc.addS("double crisp = Math.abs(area) < " + program.getEpsilon() + " ? " + "to.doubleValue() + step.doubleValue() : moment / area");
        calc.addRETURN("Math.abs(crisp) > " + program.getEpsilon() + " ? crisp : 0.0");
    }

    private void callFindAssociation(Java.METHOD method, String result, Variable variable, Member member) {
        String setName = variable.getName() + "$" + member.getName();
        method.addS("Number " + result + " = findAssociation(" + variable.getName() + ", " + variable.getFrom() + ", " + variable.getTo() + ", " + variable.getStep() + ", " + setName + ")");
    }

    private void addFindAssociation(Java.CLASS clazz) {
        Java.METHOD assoc = clazz.addMETHOD("private", "Number", "findAssociation");
        assoc.setComment("Determine the association of a value into a fuzzy range");
        assoc.setReturnComment("the association");
        assoc.addArg("Number", "value", "value to check");
        assoc.addArg("Number", "from", "fuzzy range start");
        assoc.addArg("Number", "to", "fuzzy range end");
        assoc.addArg("Number", "step", "fuzzy range step");
        assoc.addArg("int[]", "frv", "fuzzy range values");
        Java.IF vlimit = assoc.addIF("value.doubleValue() < from.doubleValue()");
        vlimit.addS("value = from");
        vlimit.addELSEIF("value.doubleValue() > to.doubleValue()").addS("value = to");
        assoc.addS("int index = iround((value.doubleValue() - from.doubleValue()) / step.doubleValue())");
        assoc.addIF("index > frv.length").addS("index = frv.length - 1");
        assoc.addIF("index < 0").addS("index = 0");
        assoc.addS("Number mapped = frv[index]");
        assoc.addRETURN("mapped.doubleValue() / 255.0");
    }

    private String createNormalized(Member m) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        String delim = "";
        sb.append("{");
        for (Integer i : m.normalized()) {
            if (count++ % 10 == 0) {
                sb.append(delim).append("\n        ");
            } else {
                sb.append(delim);
            }
            sb.append(String.format(" %3d", i));
            delim = ",";
        }
        sb.append("\n    }");
        return sb.toString();
    }
}

