/*
 * Decompiled with CFR 0.152.
 */
package com.uwemeding.fuzzer.parser;

import com.uwemeding.fuzzer.ExternalFunction;
import com.uwemeding.fuzzer.Function;
import com.uwemeding.fuzzer.FunctionCall;
import com.uwemeding.fuzzer.FuzzerException;
import com.uwemeding.fuzzer.Hedge;
import com.uwemeding.fuzzer.Member;
import com.uwemeding.fuzzer.Node;
import com.uwemeding.fuzzer.PiecewiseFunction;
import com.uwemeding.fuzzer.Program;
import com.uwemeding.fuzzer.ReasoningStrategy;
import com.uwemeding.fuzzer.Rule;
import com.uwemeding.fuzzer.RuleConditions;
import com.uwemeding.fuzzer.Variable;
import com.uwemeding.fuzzer.parser.FuzzerParserConstants;
import com.uwemeding.fuzzer.parser.FuzzerParserTokenManager;
import com.uwemeding.fuzzer.parser.ParseException;
import com.uwemeding.fuzzer.parser.SimpleCharStream;
import com.uwemeding.fuzzer.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class FuzzerParser
implements FuzzerParserConstants {
    private static boolean jj_initialized_once = false;
    public static FuzzerParserTokenManager token_source;
    static SimpleCharStream jj_input_stream;
    public static Token token;
    public static Token jj_nt;
    private static int jj_ntk;
    private static Token jj_scanpos;
    private static Token jj_lastpos;
    private static int jj_la;
    private static int jj_gen;
    private static final int[] jj_la1;
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static final JJCalls[] jj_2_rtns;
    private static boolean jj_rescan;
    private static int jj_gc;
    private static final LookaheadSuccess jj_ls;
    private static List<int[]> jj_expentries;
    private static int[] jj_expentry;
    private static int jj_kind;
    private static int[] jj_lasttokens;
    private static int jj_endpos;

    public FuzzerParser() {
    }

    public Program parse(InputStream in) {
        try {
            FuzzerParser parser = new FuzzerParser(in);
            return parser.FuzzerProgram();
        }
        catch (ParseException e) {
            throw new FuzzerException("Error parsing program definitions", e);
        }
    }

    public static void main(String ... av) {
        Program program = new FuzzerParser().parse(System.in);
        program.dump(System.out);
    }

    public static final Program FuzzerProgram() throws ParseException {
        Program program = null;
        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 9: {
                FuzzerParser.PackageDeclaration();
                break;
            }
            default: {
                FuzzerParser.jj_la1[0] = jj_gen;
            }
        }
        program = FuzzerParser.ProgramDeclaration();
        FuzzerParser.jj_consume_token(0);
        return program;
    }

    public static final void PackageDeclaration() throws ParseException {
        FuzzerParser.jj_consume_token(9);
        FuzzerParser.Name();
        FuzzerParser.jj_consume_token(45);
    }

    public static final Program ProgramDeclaration() throws ParseException {
        FuzzerParser.jj_consume_token(10);
        String programName = FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(41);
        Program program = new Program(programName);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 11: 
                case 12: 
                case 15: 
                case 16: 
                case 18: 
                case 22: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[1] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.ProgramBodyDeclaration(program);
        }
        FuzzerParser.jj_consume_token(42);
        return program;
    }

    public static final void ProgramBodyDeclaration(Program program) throws ParseException {
        block0 : switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 11: {
                FuzzerParser.jj_consume_token(11);
                String name = FuzzerParser.VariableDeclarator();
                FuzzerParser.jj_consume_token(39);
                String arg = FuzzerParser.VariableDeclarator();
                FuzzerParser.jj_consume_token(40);
                String expr = FuzzerParser.Expression();
                FuzzerParser.jj_consume_token(45);
                program.addHedge(name, arg, expr);
                break;
            }
            default: {
                FuzzerParser.jj_la1[3] = jj_gen;
                if (FuzzerParser.jj_2_1(Integer.MAX_VALUE)) {
                    FuzzerParser.jj_consume_token(12);
                    String name = FuzzerParser.VariableDeclarator();
                    FuzzerParser.jj_consume_token(39);
                    String arg = FuzzerParser.VariableDeclarator();
                    FuzzerParser.jj_consume_token(40);
                    FuzzerParser.jj_consume_token(13);
                    PiecewiseFunction pwFunc = program.addPiecewiseFunction(name, arg);
                    FuzzerParser.PiecewiseDeclaration(pwFunc);
                    FuzzerParser.jj_consume_token(41);
                    block12: while (true) {
                        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                            case 33: 
                            case 47: {
                                break;
                            }
                            default: {
                                FuzzerParser.jj_la1[2] = jj_gen;
                                break block12;
                            }
                        }
                        FuzzerParser.PiecewiseRange(pwFunc);
                    }
                    FuzzerParser.jj_consume_token(42);
                    break;
                }
                if (FuzzerParser.jj_2_2(Integer.MAX_VALUE)) {
                    FuzzerParser.jj_consume_token(12);
                    String name = FuzzerParser.VariableDeclarator();
                    FuzzerParser.jj_consume_token(39);
                    String arg = FuzzerParser.VariableDeclarator();
                    FuzzerParser.jj_consume_token(40);
                    FuzzerParser.jj_consume_token(14);
                    ExternalFunction extFunc = program.addExternalFunction(name, arg);
                    FuzzerParser.ExternalFunctionDeclaration(extFunc);
                    FuzzerParser.jj_consume_token(45);
                    break;
                }
                switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                    case 15: {
                        FuzzerParser.jj_consume_token(15);
                        FuzzerParser.FuzzyVariableDeclaration(program, true);
                        break block0;
                    }
                    case 16: {
                        FuzzerParser.jj_consume_token(16);
                        FuzzerParser.FuzzyVariableDeclaration(program, false);
                        break block0;
                    }
                    case 18: {
                        FuzzerParser.jj_consume_token(18);
                        FuzzerParser.FuzzyRule(program);
                        break block0;
                    }
                    case 22: {
                        FuzzerParser.jj_consume_token(22);
                        FuzzerParser.FuzzyReasoning(program);
                        break block0;
                    }
                }
                FuzzerParser.jj_la1[4] = jj_gen;
                FuzzerParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final void PiecewiseDeclaration(PiecewiseFunction pwFunc) throws ParseException {
        String var = FuzzerParser.VariableDeclarator();
        pwFunc.addParameter(var);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[5] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.jj_consume_token(46);
            var = FuzzerParser.VariableDeclarator();
            pwFunc.addParameter(var);
        }
    }

    public static final void PiecewiseRange(PiecewiseFunction pwFunc) throws ParseException {
        if (FuzzerParser.jj_2_3(Integer.MAX_VALUE)) {
            FuzzerParser.jj_consume_token(47);
            String to = FuzzerParser.VariableDeclarator();
            String expr = FuzzerParser.Expression();
            FuzzerParser.jj_consume_token(45);
            pwFunc.add("<", to, expr);
        } else if (FuzzerParser.jj_2_4(Integer.MAX_VALUE)) {
            String from = FuzzerParser.VariableDeclarator();
            FuzzerParser.jj_consume_token(47);
            String to = FuzzerParser.VariableDeclarator();
            String expr = FuzzerParser.Expression();
            FuzzerParser.jj_consume_token(45);
            pwFunc.add(from, to, expr);
        } else if (FuzzerParser.jj_2_5(Integer.MAX_VALUE)) {
            String from = FuzzerParser.VariableDeclarator();
            FuzzerParser.jj_consume_token(47);
            String expr = FuzzerParser.Expression();
            FuzzerParser.jj_consume_token(45);
            pwFunc.add(from, ">", expr);
        } else {
            FuzzerParser.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void ExternalFunctionDeclaration(ExternalFunction extFunc) throws ParseException {
        String name = FuzzerParser.Name();
        FuzzerParser.jj_consume_token(39);
        String var = FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(40);
        extFunc.setupClassReference(name, var);
    }

    public static final void FuzzyVariableDeclaration(Program program, boolean isInput) throws ParseException {
        String name = FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(39);
        Number from = FuzzerParser.NumberReference();
        FuzzerParser.jj_consume_token(47);
        Number to = FuzzerParser.NumberReference();
        FuzzerParser.jj_consume_token(17);
        Number step = FuzzerParser.NumberReference();
        FuzzerParser.jj_consume_token(40);
        Variable var = isInput ? program.addInput(name, from, to, step) : program.addOutput(name, from, to, step);
        FuzzerParser.jj_consume_token(41);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[6] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.MemberDefinition(program, var);
        }
        FuzzerParser.jj_consume_token(42);
    }

    public static final void MemberDefinition(Program program, Variable var) throws ParseException {
        if (FuzzerParser.jj_2_6(Integer.MAX_VALUE)) {
            String memberName = FuzzerParser.VariableDeclarator();
            FuzzerParser.jj_consume_token(49);
            Member member = var.addMember(memberName);
            block3: while (true) {
                FuzzerParser.MemberStep(member);
                switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                    case 41: {
                        continue block3;
                    }
                }
                break;
            }
            FuzzerParser.jj_la1[7] = jj_gen;
            FuzzerParser.jj_consume_token(45);
        } else if (FuzzerParser.jj_2_7(Integer.MAX_VALUE)) {
            String memberName = FuzzerParser.VariableDeclarator();
            FuzzerParser.jj_consume_token(49);
            FuzzerParser.FunctionCall(program, var, memberName);
            FuzzerParser.jj_consume_token(45);
        } else {
            FuzzerParser.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public static final void MemberStep(Member member) throws ParseException {
        FuzzerParser.jj_consume_token(41);
        Number x = FuzzerParser.NumberReference();
        block0 : switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 45: 
            case 46: 
            case 50: {
                switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                    case 46: {
                        FuzzerParser.jj_consume_token(46);
                        break block0;
                    }
                    case 45: {
                        FuzzerParser.jj_consume_token(45);
                        break block0;
                    }
                    case 50: {
                        FuzzerParser.jj_consume_token(50);
                        break block0;
                    }
                }
                FuzzerParser.jj_la1[8] = jj_gen;
                FuzzerParser.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                FuzzerParser.jj_la1[9] = jj_gen;
            }
        }
        Number y = FuzzerParser.NumberReference();
        FuzzerParser.jj_consume_token(42);
        member.add(x, y);
    }

    public static final void FunctionCall(Program program, Variable var, String memberName) throws ParseException {
        String functionName = FuzzerParser.VariableDeclarator();
        Function function = program.getFunction(functionName);
        FunctionCall call = new FunctionCall(function);
        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 43: {
                FuzzerParser.jj_consume_token(43);
                block6: while (true) {
                    switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                        case 25: 
                        case 29: 
                        case 51: {
                            break;
                        }
                        default: {
                            FuzzerParser.jj_la1[10] = jj_gen;
                            break block6;
                        }
                    }
                    FuzzerParser.FunctionCallParameters(program, var, memberName, call);
                }
                FuzzerParser.jj_consume_token(44);
                break;
            }
            default: {
                FuzzerParser.jj_la1[11] = jj_gen;
            }
        }
        FuzzerParser.jj_consume_token(39);
        FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(40);
        Member member = var.addMember(memberName, call);
    }

    public static final void FunctionCallParameters(Program program, Variable var, String memberName, FunctionCall call) throws ParseException {
        Number parameter = FuzzerParser.NumberReference();
        call.bindParameter(parameter);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[12] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.jj_consume_token(46);
            parameter = FuzzerParser.NumberReference();
            call.bindParameter(parameter);
        }
    }

    public static final void FuzzyRule(Program program) throws ParseException {
        String ruleName = FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(39);
        Node condition = FuzzerParser.FuzzyCondition(program);
        FuzzerParser.jj_consume_token(40);
        Rule rule = program.addRule(ruleName, condition);
        FuzzerParser.jj_consume_token(41);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[13] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.FuzzyRuleAssignment(program, rule);
        }
        FuzzerParser.jj_consume_token(42);
    }

    public static final Node FuzzyCondition(Program program) throws ParseException {
        Node condition = FuzzerParser.FuzzyOrCondition(program);
        return condition;
    }

    public static final Node FuzzyOrCondition(Program program) throws ParseException {
        Node left = FuzzerParser.FuzzyAndCondition(program);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[14] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.jj_consume_token(21);
            Node right = FuzzerParser.FuzzyAndCondition(program);
            left = RuleConditions.createOrCondition(left, right);
        }
        return left;
    }

    public static final Node FuzzyAndCondition(Program program) throws ParseException {
        Node left = FuzzerParser.FuzzyInSetCondition(program);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 20: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[15] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.jj_consume_token(20);
            Node right = FuzzerParser.FuzzyInSetCondition(program);
            left = RuleConditions.createAndCondition(left, right);
        }
        return left;
    }

    public static final Node FuzzyInSetCondition(Program program) throws ParseException {
        String hedgeName = null;
        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 39: {
                FuzzerParser.jj_consume_token(39);
                Node node = FuzzerParser.FuzzyCondition(program);
                FuzzerParser.jj_consume_token(40);
                return node;
            }
        }
        FuzzerParser.jj_la1[16] = jj_gen;
        if (FuzzerParser.jj_2_8(4)) {
            Member member;
            String varName = FuzzerParser.VariableDeclarator();
            FuzzerParser.jj_consume_token(19);
            hedgeName = FuzzerParser.VariableDeclarator();
            String memberName = FuzzerParser.VariableDeclarator();
            Variable var = program.getInput(varName);
            if (var.haveMember(hedgeName, memberName)) {
                member = var.getMember(hedgeName, memberName);
            } else {
                Hedge hedge = program.getHedge(hedgeName);
                member = var.getMember(memberName);
                member = member.applyHedge(hedge);
                var.addMember(member);
            }
            member.incrReferenceCount();
            return RuleConditions.createInCondition(var, member);
        }
        if (FuzzerParser.jj_2_9(3)) {
            String varName = FuzzerParser.VariableDeclarator();
            FuzzerParser.jj_consume_token(19);
            String memberName = FuzzerParser.VariableDeclarator();
            Variable var = program.getInput(varName);
            Member member = var.getMember(memberName);
            member.incrReferenceCount();
            return RuleConditions.createInCondition(var, member);
        }
        FuzzerParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final void FuzzyRuleAssignment(Program program, Rule rule) throws ParseException {
        String varName = FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(49);
        String memberName = FuzzerParser.VariableDeclarator();
        FuzzerParser.jj_consume_token(45);
        Variable var = program.getOutput(varName);
        Member member = var.getMember(memberName);
        member.incrReferenceCount();
        rule.assign(var, member);
    }

    public static final void FuzzyReasoning(Program program) throws ParseException {
        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 23: {
                FuzzerParser.jj_consume_token(23);
                FuzzerParser.jj_consume_token(45);
                program.setReasoningStrategy(ReasoningStrategy.MAXMIN);
                break;
            }
            case 24: {
                FuzzerParser.jj_consume_token(24);
                FuzzerParser.jj_consume_token(45);
                program.setReasoningStrategy(ReasoningStrategy.MAXDOT);
                break;
            }
            default: {
                FuzzerParser.jj_la1[17] = jj_gen;
                FuzzerParser.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public static final String VariableDeclarator() throws ParseException {
        FuzzerParser.jj_consume_token(33);
        return FuzzerParser.getToken((int)0).image;
    }

    public static final Number NumberReference() throws ParseException {
        boolean haveSign = false;
        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 51: {
                FuzzerParser.jj_consume_token(51);
                haveSign = true;
                break;
            }
            default: {
                FuzzerParser.jj_la1[18] = jj_gen;
            }
        }
        Number number = FuzzerParser.UnsignedNumberReference();
        return haveSign ? (Number)(-number.doubleValue()) : (Number)number;
    }

    public static final Number UnsignedNumberReference() throws ParseException {
        switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
            case 25: {
                FuzzerParser.jj_consume_token(25);
                return Double.parseDouble(FuzzerParser.getToken((int)0).image);
            }
            case 29: {
                FuzzerParser.jj_consume_token(29);
                return Double.parseDouble(FuzzerParser.getToken((int)0).image);
            }
        }
        FuzzerParser.jj_la1[19] = jj_gen;
        FuzzerParser.jj_consume_token(-1);
        throw new ParseException();
    }

    public static final String Expression() throws ParseException {
        FuzzerParser.jj_consume_token(36);
        String expr = FuzzerParser.getToken((int)0).image.substring(2).trim();
        return expr;
    }

    public static final String Name() throws ParseException {
        StringJoiner sj = new StringJoiner(".");
        String name = FuzzerParser.VariableDeclarator();
        sj.add(name);
        block3: while (true) {
            switch (jj_ntk == -1 ? FuzzerParser.jj_ntk() : jj_ntk) {
                case 48: {
                    break;
                }
                default: {
                    FuzzerParser.jj_la1[20] = jj_gen;
                    break block3;
                }
            }
            FuzzerParser.jj_consume_token(48);
            name = FuzzerParser.VariableDeclarator();
            sj.add(name);
        }
        return sj.toString();
    }

    private static boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(0, xla);
        }
    }

    private static boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(1, xla);
        }
    }

    private static boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(2, xla);
        }
    }

    private static boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(3, xla);
        }
    }

    private static boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(4, xla);
        }
    }

    private static boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(5, xla);
        }
    }

    private static boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(6, xla);
        }
    }

    private static boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(7, xla);
        }
    }

    private static boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            boolean bl = !FuzzerParser.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            FuzzerParser.jj_save(8, xla);
        }
    }

    private static boolean jj_3_5() {
        if (FuzzerParser.jj_scan_token(33)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(47);
    }

    private static boolean jj_3_6() {
        if (FuzzerParser.jj_scan_token(33)) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(49)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(41);
    }

    private static boolean jj_3_8() {
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(19)) {
            return true;
        }
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        return FuzzerParser.jj_3R_12();
    }

    private static boolean jj_3_2() {
        if (FuzzerParser.jj_scan_token(12)) {
            return true;
        }
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(39)) {
            return true;
        }
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(40)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(14);
    }

    private static boolean jj_3_4() {
        if (FuzzerParser.jj_scan_token(33)) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(47)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(33);
    }

    private static boolean jj_3R_12() {
        return FuzzerParser.jj_scan_token(33);
    }

    private static boolean jj_3_9() {
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(19)) {
            return true;
        }
        return FuzzerParser.jj_3R_12();
    }

    private static boolean jj_3_3() {
        if (FuzzerParser.jj_scan_token(47)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(33);
    }

    private static boolean jj_3_1() {
        if (FuzzerParser.jj_scan_token(12)) {
            return true;
        }
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(39)) {
            return true;
        }
        if (FuzzerParser.jj_3R_12()) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(40)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(13);
    }

    private static boolean jj_3_7() {
        if (FuzzerParser.jj_scan_token(33)) {
            return true;
        }
        if (FuzzerParser.jj_scan_token(49)) {
            return true;
        }
        return FuzzerParser.jj_scan_token(33);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{512, 4560896, 0, 2048, 4554752, 0, 0, 0, 0, 0, 0x22000000, 0, 0, 0, 0x200000, 0x100000, 0, 0x1800000, 0, 0x22000000, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 32770, 0, 0, 16384, 2, 512, 286720, 286720, 524288, 2048, 16384, 2, 0, 0, 128, 0, 524288, 0, 65536};
    }

    public FuzzerParser(InputStream stream) {
        this(stream, null);
    }

    public FuzzerParser(InputStream stream, String encoding) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser.  ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new FuzzerParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            FuzzerParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            FuzzerParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(InputStream stream) {
        FuzzerParser.ReInit(stream, null);
    }

    public static void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        FuzzerParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            FuzzerParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            FuzzerParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FuzzerParser(Reader stream) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new FuzzerParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            FuzzerParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            FuzzerParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public static void ReInit(Reader stream) {
        int i;
        jj_input_stream.ReInit(stream, 1, 1);
        FuzzerParserTokenManager.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            FuzzerParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            FuzzerParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public FuzzerParser(FuzzerParserTokenManager tm) {
        int i;
        if (jj_initialized_once) {
            System.out.println("ERROR: Second call to constructor of static parser. ");
            System.out.println("       You must either use ReInit() or set the JavaCC option STATIC to false");
            System.out.println("       during parser generation.");
            throw new Error();
        }
        jj_initialized_once = true;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            FuzzerParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            FuzzerParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(FuzzerParserTokenManager tm) {
        int i;
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (i = 0; i < 21; ++i) {
            FuzzerParser.jj_la1[i] = -1;
        }
        for (i = 0; i < jj_2_rtns.length; ++i) {
            FuzzerParser.jj_2_rtns[i] = new JJCalls();
        }
    }

    private static Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = token;
        token = oldToken.next != null ? FuzzerParser.token.next : (FuzzerParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        if (FuzzerParser.token.kind == kind) {
            ++jj_gen;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; ++i) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw FuzzerParser.generateParseException();
    }

    private static boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            --jj_la;
            if (FuzzerParser.jj_scanpos.next == null) {
                jj_scanpos = FuzzerParser.jj_scanpos.next = token_source.getNextToken();
                jj_lastpos = FuzzerParser.jj_scanpos.next;
            } else {
                jj_lastpos = jj_scanpos = FuzzerParser.jj_scanpos.next;
            }
        } else {
            jj_scanpos = FuzzerParser.jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                FuzzerParser.jj_add_error_token(kind, i);
            }
        }
        if (FuzzerParser.jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    public static final Token getNextToken() {
        token = FuzzerParser.token.next != null ? FuzzerParser.token.next : (FuzzerParser.token.next = token_source.getNextToken());
        jj_ntk = -1;
        ++jj_gen;
        return token;
    }

    public static final Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = token_source.getNextToken());
        }
        return t;
    }

    private static int jj_ntk() {
        jj_nt = FuzzerParser.token.next;
        if (jj_nt == null) {
            FuzzerParser.token.next = token_source.getNextToken();
            jj_ntk = FuzzerParser.token.next.kind;
            return jj_ntk;
        }
        jj_ntk = FuzzerParser.jj_nt.kind;
        return jj_ntk;
    }

    private static void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            FuzzerParser.jj_lasttokens[FuzzerParser.jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; ++i) {
                FuzzerParser.jj_expentry[i] = jj_lasttokens[i];
            }
            block1: for (int[] oldentry : jj_expentries) {
                if (oldentry.length != jj_expentry.length) continue;
                for (int i = 0; i < jj_expentry.length; ++i) {
                    if (oldentry[i] != jj_expentry[i]) continue block1;
                }
                jj_expentries.add(jj_expentry);
                break;
            }
            if (pos != 0) {
                jj_endpos = pos;
                FuzzerParser.jj_lasttokens[FuzzerParser.jj_endpos - 1] = kind;
            }
        }
    }

    public static ParseException generateParseException() {
        int i;
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[52];
        if (jj_kind >= 0) {
            la1tokens[FuzzerParser.jj_kind] = true;
            jj_kind = -1;
        }
        for (i = 0; i < 21; ++i) {
            if (jj_la1[i] != jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 52; ++i) {
            if (!la1tokens[i]) continue;
            jj_expentry = new int[1];
            FuzzerParser.jj_expentry[0] = i;
            jj_expentries.add(jj_expentry);
        }
        jj_endpos = 0;
        FuzzerParser.jj_rescan_token();
        FuzzerParser.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i2 = 0; i2 < jj_expentries.size(); ++i2) {
            exptokseq[i2] = jj_expentries.get(i2);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    public static final void enable_tracing() {
    }

    public static final void disable_tracing() {
    }

    private static void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 9; ++i) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen <= jj_gen) continue;
                    jj_la = p.arg;
                    jj_lastpos = jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            FuzzerParser.jj_3_1();
                            break;
                        }
                        case 1: {
                            FuzzerParser.jj_3_2();
                            break;
                        }
                        case 2: {
                            FuzzerParser.jj_3_3();
                            break;
                        }
                        case 3: {
                            FuzzerParser.jj_3_4();
                            break;
                        }
                        case 4: {
                            FuzzerParser.jj_3_5();
                            break;
                        }
                        case 5: {
                            FuzzerParser.jj_3_6();
                            break;
                        }
                        case 6: {
                            FuzzerParser.jj_3_7();
                            break;
                        }
                        case 7: {
                            FuzzerParser.jj_3_8();
                            break;
                        }
                        case 8: {
                            FuzzerParser.jj_3_9();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        jj_rescan = false;
    }

    private static void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static {
        jj_la1 = new int[21];
        FuzzerParser.jj_la1_init_0();
        FuzzerParser.jj_la1_init_1();
        jj_2_rtns = new JJCalls[9];
        jj_rescan = false;
        jj_gc = 0;
        jj_ls = new LookaheadSuccess();
        jj_expentries = new ArrayList<int[]>();
        jj_kind = -1;
        jj_lasttokens = new int[100];
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

