/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.urlencoder;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class UrlEncoder {
    static final BitSet UNRESERVED_URI_CHARS;
    private static final char[] HEX_DIGITS;

    private UrlEncoder() {
    }

    private static void appendUrlEncodedByte(StringBuilder stringBuilder, int n) {
        stringBuilder.append("%");
        UrlEncoder.appendUrlEncodedDigit(stringBuilder, n >> 4);
        UrlEncoder.appendUrlEncodedDigit(stringBuilder, n);
    }

    private static void appendUrlEncodedDigit(StringBuilder stringBuilder, int n) {
        stringBuilder.append(HEX_DIGITS[n & 0xF]);
    }

    public static String decode(String string) {
        return UrlEncoder.decode(string, false);
    }

    public static String decode(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = null;
        byte[] byArray = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c == '%') {
                stringBuilder = UrlEncoder.startConstructingIfNeeded(stringBuilder, string, n3);
                if (byArray == null) {
                    byArray = new byte[(n - n3) / 3];
                }
                if (n < ++n3 + 2) {
                    throw new IllegalArgumentException("Illegal escape sequence");
                }
                try {
                    int n4 = Integer.parseInt(string, n3, n3 + 2, 16);
                    if (n4 < 0 || n4 > 255) {
                        throw new IllegalArgumentException("Illegal escape value");
                    }
                    byArray[n2++] = (byte)n4;
                    n3 += 2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Illegal characters in escape sequence: " + numberFormatException.getMessage(), numberFormatException);
                }
            }
            if (byArray != null) {
                stringBuilder.append(new String(byArray, 0, n2, StandardCharsets.UTF_8));
                byArray = null;
                n2 = 0;
            }
            if (bl && c == '+') {
                stringBuilder = UrlEncoder.startConstructingIfNeeded(stringBuilder, string, n3);
                stringBuilder.append(" ");
            } else if (stringBuilder != null) {
                stringBuilder.append(c);
            }
            ++n3;
        }
        if (stringBuilder == null) {
            return string;
        }
        if (byArray != null) {
            stringBuilder.append(new String(byArray, 0, n2, StandardCharsets.UTF_8));
        }
        return stringBuilder.toString();
    }

    private static StringBuilder startConstructingIfNeeded(StringBuilder stringBuilder, String string, int n) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(string.length());
            stringBuilder.append(string, 0, n);
        }
        return stringBuilder;
    }

    public static String encode(String string) {
        return UrlEncoder.encode(string, null, false);
    }

    public static String encode(String string, String string2) {
        return UrlEncoder.encode(string, string2, false);
    }

    public static String encode(String string, boolean bl) {
        return UrlEncoder.encode(string, null, bl);
    }

    public static String encode(String string, String string2, boolean bl) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        while (n < string.length()) {
            int n222;
            char c = string.charAt(n);
            if (UrlEncoder.isUnreservedUriChar(c) || string2 != null && string2.indexOf(c) != -1) {
                if (stringBuilder != null) {
                    stringBuilder.append(c);
                }
                ++n;
                continue;
            }
            stringBuilder = UrlEncoder.startConstructingIfNeeded(stringBuilder, string, n);
            int n3 = string.codePointAt(n);
            if (n3 < 128) {
                if (bl && c == ' ') {
                    stringBuilder.append('+');
                } else {
                    UrlEncoder.appendUrlEncodedByte(stringBuilder, n3);
                }
                ++n;
                continue;
            }
            if (Character.isBmpCodePoint(n3)) {
                for (int n222 : Character.toString(c).getBytes(StandardCharsets.UTF_8)) {
                    UrlEncoder.appendUrlEncodedByte(stringBuilder, n222);
                }
                ++n;
                continue;
            }
            if (!Character.isSupplementaryCodePoint(n3)) continue;
            char c2 = Character.highSurrogate(n3);
            int n4 = Character.lowSurrogate(n3);
            byte[] byArray = new String(new char[]{c2, n4}).getBytes(StandardCharsets.UTF_8);
            n222 = byArray.length;
            for (int i = 0; i < n222; ++i) {
                byte by = byArray[i];
                UrlEncoder.appendUrlEncodedByte(stringBuilder, by);
            }
            n += 2;
        }
        if (stringBuilder == null) {
            return string;
        }
        return stringBuilder.toString();
    }

    private static boolean isUnreservedUriChar(char c) {
        return c <= 'z' && UNRESERVED_URI_CHARS.get(c);
    }

    public static void main(String[] stringArray) {
        try {
            MainResult mainResult = UrlEncoder.processMain(stringArray);
            if (mainResult.status == 0) {
                System.out.println(mainResult.output);
            } else {
                System.err.println(mainResult.output);
            }
            System.exit(mainResult.status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(UrlEncoder.class.getSimpleName() + ": " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    static MainResult processMain(String ... stringArray) {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>(List.of(stringArray));
        if (!arrayList.isEmpty() && arrayList.get(0).startsWith("-")) {
            string = arrayList.remove(0);
            if ("-d".equals(string)) {
                bl2 = true;
                bl = arrayList.size() == 1;
            } else if ("-e".equals(string)) {
                bl = arrayList.size() == 1;
            } else {
                arrayList.clear();
            }
        }
        string = "";
        if (arrayList.size() == 1 && !arrayList.get(0).isEmpty()) {
            string = arrayList.remove(0);
            bl = true;
        }
        if (!bl) {
            return new MainResult("Usage : java -jar urlencoder-*.jar [-ed] text" + System.lineSeparator() + "Encode and decode URL components defensively." + System.lineSeparator() + "  -e  encode (default)" + System.lineSeparator() + "  -d  decode", 1);
        }
        if (bl2) {
            return new MainResult(UrlEncoder.decode(string), 0);
        }
        return new MainResult(UrlEncoder.encode(string), 0);
    }

    static {
        int n;
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
        BitSet bitSet = new BitSet(123);
        bitSet.set(45);
        bitSet.set(46);
        for (n = 48; n <= 57; ++n) {
            bitSet.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            bitSet.set(n);
        }
        bitSet.set(95);
        for (n = 97; n <= 122; ++n) {
            bitSet.set(n);
        }
        UNRESERVED_URI_CHARS = bitSet;
    }

    static class MainResult {
        final String output;
        final int status;

        public MainResult(String string, int n) {
            this.output = string;
            this.status = n;
        }
    }
}

