/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer;

import com.vaadin.addon.jpacontainer.AdvancedFilterable;
import com.vaadin.addon.jpacontainer.BatchableEntityProvider;
import com.vaadin.addon.jpacontainer.BufferedContainerDelegate;
import com.vaadin.addon.jpacontainer.CachingEntityProvider;
import com.vaadin.addon.jpacontainer.EntityContainer;
import com.vaadin.addon.jpacontainer.EntityItem;
import com.vaadin.addon.jpacontainer.EntityProvider;
import com.vaadin.addon.jpacontainer.EntityProviderChangeEvent;
import com.vaadin.addon.jpacontainer.EntityProviderChangeListener;
import com.vaadin.addon.jpacontainer.EntityProviderChangeNotifier;
import com.vaadin.addon.jpacontainer.Filter;
import com.vaadin.addon.jpacontainer.HierarchicalEntityContainer;
import com.vaadin.addon.jpacontainer.JPAContainerItem;
import com.vaadin.addon.jpacontainer.MutableEntityProvider;
import com.vaadin.addon.jpacontainer.PropertyList;
import com.vaadin.addon.jpacontainer.SortBy;
import com.vaadin.addon.jpacontainer.filter.Filters;
import com.vaadin.addon.jpacontainer.filter.PropertyFilter;
import com.vaadin.addon.jpacontainer.filter.util.AdvancedFilterableSupport;
import com.vaadin.addon.jpacontainer.metadata.EntityClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.MetadataFactory;
import com.vaadin.data.Buffered;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.filter.UnsupportedFilterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAContainer<T>
implements EntityContainer<T>,
EntityProviderChangeListener<T>,
HierarchicalEntityContainer<T>,
Container.Indexed {
    private static final long serialVersionUID = -4031940552175752858L;
    private EntityProvider<T> entityProvider;
    private AdvancedFilterableSupport filterSupport;
    private LinkedList<Container.ItemSetChangeListener> listeners;
    private EntityClassMetadata<T> entityClassMetadata;
    private List<SortBy> sortByList;
    private PropertyList<T> propertyList;
    private BufferedContainerDelegate<T> bufferingDelegate;
    private boolean readOnly = false;
    private boolean writeThrough = false;
    private Collection<String> additionalFilterablePropertyIds;
    private boolean fireContainerItemSetChangeEvents = true;
    private boolean fireItemSetChangeOnProviderChange = true;
    private boolean containsIdFiresItemSetChangeIfNotFound = false;
    private String parentProperty;
    private String parentIdProperty;

    public JPAContainer(Class<T> entityClass) {
        assert (entityClass != null) : "entityClass must not be null";
        this.entityClassMetadata = MetadataFactory.getInstance().getEntityClassMetadata(entityClass);
        this.propertyList = new PropertyList<T>(this.entityClassMetadata);
        this.filterSupport = new AdvancedFilterableSupport();
        this.bufferingDelegate = new BufferedContainerDelegate(this);
        this.filterSupport.addListener(new AdvancedFilterableSupport.ApplyFiltersListener(){
            private static final long serialVersionUID = -23196201919497112L;

            public void filtersApplied(AdvancedFilterableSupport sender) {
                JPAContainer.this.fireContainerItemSetChange(new AdvancedFilterable.FiltersAppliedEvent(JPAContainer.this));
            }
        });
        this.updateFilterablePropertyIds();
    }

    public void setAdditionalFilterablePropertyIds(String ... propertyIds) {
        this.additionalFilterablePropertyIds = propertyIds == null || propertyIds.length == 0 ? null : Arrays.asList(propertyIds);
        this.updateFilterablePropertyIds();
    }

    protected void updateFilterablePropertyIds() {
        HashSet<String> properties = new HashSet<String>();
        properties.addAll(this.propertyList.getPersistentPropertyNames());
        if (this.additionalFilterablePropertyIds != null) {
            properties.addAll(this.additionalFilterablePropertyIds);
        }
        this.filterSupport.setFilterablePropertyIds(properties);
    }

    protected EntityClassMetadata<T> getEntityClassMetadata() {
        return this.entityClassMetadata;
    }

    public void addListener(Container.ItemSetChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(Container.ItemSetChangeListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireContainerItemSetChange(Container.ItemSetChangeEvent event) {
        assert (event != null) : "event must not be null";
        if (this.listeners == null || !this.fireContainerItemSetChangeEvents) {
            return;
        }
        LinkedList list = (LinkedList)this.listeners.clone();
        for (Container.ItemSetChangeListener l : list) {
            l.containerItemSetChange(event);
        }
    }

    public void setFireContainerItemSetChangeEvents(boolean value) {
        this.fireContainerItemSetChangeEvents = value;
    }

    public boolean isFireContainerItemSetChangeEvents() {
        return this.fireContainerItemSetChangeEvents;
    }

    @Override
    public void addNestedContainerProperty(String nestedProperty) throws UnsupportedOperationException {
        this.propertyList.addNestedProperty(nestedProperty);
        this.updateFilterablePropertyIds();
    }

    @Override
    public Class<T> getEntityClass() {
        return this.getEntityClassMetadata().getMappedClass();
    }

    @Override
    public EntityProvider<T> getEntityProvider() {
        return this.entityProvider;
    }

    protected EntityProvider<T> doGetEntityProvider() throws IllegalStateException {
        if (this.entityProvider == null) {
            throw new IllegalStateException("No EntityProvider has been set");
        }
        return this.entityProvider;
    }

    @Override
    public boolean isReadOnly() {
        return !(this.doGetEntityProvider() instanceof MutableEntityProvider) || this.readOnly;
    }

    @Override
    public void setEntityProvider(EntityProvider<T> entityProvider) {
        assert (entityProvider != null) : "entityProvider must not be null";
        if (this.entityProvider != null && this.entityProvider instanceof EntityProviderChangeNotifier) {
            ((EntityProviderChangeNotifier)((Object)this.entityProvider)).removeListener(this);
        }
        this.entityProvider = entityProvider;
        if (this.entityProvider instanceof EntityProviderChangeNotifier) {
            ((EntityProviderChangeNotifier)((Object)this.entityProvider)).addListener(this);
        }
    }

    protected void setFireItemSetChangeOnProviderChange(boolean fireItemSetChangeOnProviderChange) {
        this.fireItemSetChangeOnProviderChange = fireItemSetChangeOnProviderChange;
    }

    protected boolean isFireItemSetChangeOnProviderChange() {
        return this.fireItemSetChangeOnProviderChange;
    }

    @Override
    public void entityProviderChange(EntityProviderChangeEvent<T> event) {
        if (this.isFireItemSetChangeOnProviderChange()) {
            this.fireContainerItemSetChange(new ProviderChangedEvent(event));
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws UnsupportedOperationException {
        if (readOnly) {
            this.readOnly = readOnly;
        } else if (this.doGetEntityProvider() instanceof MutableEntityProvider) {
            this.readOnly = readOnly;
        } else {
            throw new UnsupportedOperationException("EntityProvider is not mutable");
        }
    }

    public void setSortProperty(String propertyId, String sortProperty) throws IllegalArgumentException {
        this.propertyList.setSortProperty(propertyId, sortProperty);
    }

    public Collection<String> getSortableContainerPropertyIds() {
        return this.propertyList.getSortablePropertyMap().keySet();
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        assert (propertyId != null) : "propertyId must not be null";
        assert (ascending != null) : "ascending must not be null";
        assert (propertyId.length == ascending.length) : "propertyId and ascending must have the same length";
        this.sortByList = new LinkedList<SortBy>();
        for (int i = 0; i < propertyId.length; ++i) {
            if (!this.getSortableContainerPropertyIds().contains(propertyId[i].toString())) {
                throw new IllegalArgumentException("No such sortable property ID: " + propertyId[i]);
            }
            String sortProperty = this.propertyList.getSortablePropertyMap().get(propertyId[i]);
            this.sortByList.add(new SortBy(sortProperty, ascending[i]));
        }
        this.sortByList = Collections.unmodifiableList(this.sortByList);
        this.fireContainerItemSetChange(new ContainerSortedEvent());
    }

    protected List<SortBy> getSortByList() {
        if (this.sortByList == null) {
            return Collections.emptyList();
        }
        return this.sortByList;
    }

    public Object addItemAfter(Object previousItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object firstItemId() {
        if (this.isWriteThrough() || this.bufferingDelegate.getAddedItemIds().isEmpty()) {
            Object itemId = this.doGetEntityProvider().getFirstEntityIdentifier(this.getAppliedFiltersAsConjunction(), this.getSortByList());
            return itemId;
        }
        return this.bufferingDelegate.getAddedItemIds().get(0);
    }

    public boolean isFirstId(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return itemId.equals(this.firstItemId());
    }

    public boolean isLastId(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return itemId.equals(this.lastItemId());
    }

    public Object lastItemId() {
        Object itemId = this.doGetEntityProvider().getLastEntityIdentifier(this.getAppliedFiltersAsConjunction(), this.getSortByList());
        if (this.isWriteThrough() || this.bufferingDelegate.getAddedItemIds().isEmpty()) {
            return itemId;
        }
        if (itemId == null) {
            return this.bufferingDelegate.getAddedItemIds().get(this.bufferingDelegate.getAddedItemIds().size() - 1);
        }
        return itemId;
    }

    public Object nextItemId(Object itemId) {
        if (this.isWriteThrough() || this.bufferingDelegate.getAddedItemIds().isEmpty() || !this.bufferingDelegate.isAdded(itemId)) {
            return this.doGetEntityProvider().getNextEntityIdentifier(itemId, this.getAppliedFiltersAsConjunction(), this.getSortByList());
        }
        int ix = this.bufferingDelegate.getAddedItemIds().indexOf(itemId);
        if (ix == this.bufferingDelegate.getAddedItemIds().size() - 1) {
            return this.doGetEntityProvider().getFirstEntityIdentifier(this.getAppliedFiltersAsConjunction(), this.getSortByList());
        }
        return this.bufferingDelegate.getAddedItemIds().get(ix + 1);
    }

    public Object prevItemId(Object itemId) {
        if (this.isWriteThrough() || this.bufferingDelegate.getAddedItemIds().isEmpty()) {
            return this.doGetEntityProvider().getPreviousEntityIdentifier(itemId, this.getAppliedFiltersAsConjunction(), this.getSortByList());
        }
        if (this.bufferingDelegate.isAdded(itemId)) {
            int ix = this.bufferingDelegate.getAddedItemIds().indexOf(itemId);
            if (ix == 0) {
                return null;
            }
            return this.bufferingDelegate.getAddedItemIds().get(ix - 1);
        }
        Object prevId = this.doGetEntityProvider().getPreviousEntityIdentifier(itemId, this.getAppliedFiltersAsConjunction(), this.getSortByList());
        if (prevId == null) {
            return this.bufferingDelegate.getAddedItemIds().get(this.bufferingDelegate.getAddedItemIds().size() - 1);
        }
        return prevId;
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Item addItem(Object itemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object addItem() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean containsId(Object itemId) {
        boolean result = this.doContainsId(itemId);
        if (this.containsIdFiresItemSetChangeIfNotFound && !result) {
            this.fireContainerItemSetChange(new ItemNotFoundEvent());
        }
        return result;
    }

    public boolean isContainsIdFiresItemSetChangeIfNotFound() {
        return this.containsIdFiresItemSetChangeIfNotFound;
    }

    public void setContainsIdFiresItemSetChangeIfNotFound(boolean value) {
        this.containsIdFiresItemSetChangeIfNotFound = value;
    }

    protected boolean doContainsId(Object itemId) {
        if (this.isWriteThrough()) {
            return this.doGetEntityProvider().containsEntity(itemId, this.getAppliedFiltersAsConjunction());
        }
        return this.bufferingDelegate.isAdded(itemId) || this.doGetEntityProvider().containsEntity(itemId, this.getAppliedFiltersAsConjunction());
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        return item == null ? null : item.getItemProperty(propertyId);
    }

    public Collection<String> getContainerPropertyIds() {
        return this.propertyList.getPropertyNames();
    }

    PropertyList<T> getPropertyList() {
        return this.propertyList;
    }

    @Override
    public EntityItem<T> getItem(Object itemId) {
        if (itemId == null) {
            return null;
        }
        if (this.isWriteThrough() || !this.bufferingDelegate.isModified()) {
            T entity = this.doGetEntityProvider().getEntity(itemId);
            return entity != null ? new JPAContainerItem<T>(this, entity) : null;
        }
        if (this.bufferingDelegate.isAdded(itemId)) {
            JPAContainerItem<T> item = new JPAContainerItem<T>(this, this.bufferingDelegate.getAddedEntity(itemId), itemId, false);
            return item;
        }
        if (this.bufferingDelegate.isUpdated(itemId)) {
            JPAContainerItem<T> item = new JPAContainerItem<T>(this, this.bufferingDelegate.getUpdatedEntity(itemId));
            item.setDirty(true);
            return item;
        }
        if (this.bufferingDelegate.isDeleted(itemId)) {
            T entity = this.doGetEntityProvider().getEntity(itemId);
            if (entity != null) {
                JPAContainerItem<T> item = new JPAContainerItem<T>(this, entity);
                item.setDeleted(true);
                return item;
            }
            return null;
        }
        T entity = this.doGetEntityProvider().getEntity(itemId);
        return entity != null ? new JPAContainerItem<T>(this, entity) : null;
    }

    public Collection<Object> getItemIds() {
        List<Object> ids = this.getEntityProvider().getAllEntityIdentifiers(this.getAppliedFiltersAsConjunction(), this.getSortByList());
        if (this.isWriteThrough() || !this.bufferingDelegate.isModified()) {
            return ids;
        }
        LinkedList<Object> newIds = new LinkedList<Object>();
        newIds.addAll(this.bufferingDelegate.getAddedItemIds());
        newIds.addAll(ids);
        return Collections.unmodifiableCollection(newIds);
    }

    @Override
    public EntityItem<T> createEntityItem(T entity) {
        return new JPAContainerItem<T>(this, entity, null, false);
    }

    public Class<?> getType(Object propertyId) {
        assert (propertyId != null) : "propertyId must not be null";
        return this.propertyList.getPropertyType(propertyId.toString());
    }

    public boolean removeContainerProperty(Object propertyId) throws UnsupportedOperationException {
        assert (propertyId != null) : "propertyId must not be null";
        boolean result = this.propertyList.removeProperty(propertyId.toString());
        this.updateFilterablePropertyIds();
        return result;
    }

    public int size() {
        int origSize = this.doGetEntityProvider().getEntityCount(this.getAppliedFiltersAsConjunction());
        if (this.isWriteThrough()) {
            return origSize;
        }
        int newSize = origSize + this.bufferingDelegate.getAddedItemIds().size();
        return newSize;
    }

    @Override
    public void addFilter(Filter filter) throws IllegalArgumentException {
        this.filterSupport.addFilter(filter);
    }

    @Override
    public void applyFilters() {
        this.filterSupport.applyFilters();
    }

    @Override
    public List<Filter> getAppliedFilters() {
        return this.filterSupport.getAppliedFilters();
    }

    protected Filter getAppliedFiltersAsConjunction() {
        if (this.getAppliedFilters().isEmpty()) {
            return null;
        }
        if (this.getAppliedFilters().size() == 1) {
            return this.getAppliedFilters().iterator().next();
        }
        return Filters.and(this.getAppliedFilters());
    }

    @Override
    public Collection<Object> getFilterablePropertyIds() {
        return this.filterSupport.getFilterablePropertyIds();
    }

    @Override
    public List<Filter> getFilters() {
        return this.filterSupport.getFilters();
    }

    @Override
    public boolean hasUnappliedFilters() {
        return this.filterSupport.hasUnappliedFilters();
    }

    @Override
    public boolean isApplyFiltersImmediately() {
        return this.filterSupport.isApplyFiltersImmediately();
    }

    @Override
    public boolean isFilterable(Object propertyId) {
        return this.filterSupport.isFilterable(propertyId);
    }

    @Override
    public void removeAllFilters() {
        this.filterSupport.removeAllFilters();
    }

    @Override
    public void removeFilter(Filter filter) {
        this.filterSupport.removeFilter(filter);
    }

    @Override
    public void setApplyFiltersImmediately(boolean applyFiltersImmediately) {
        this.filterSupport.setApplyFiltersImmediately(applyFiltersImmediately);
    }

    @Override
    public void addContainerFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        filterString = onlyMatchPrefix ? filterString + "%" : "%" + filterString + "%";
        this.addFilter(Filters.like(propertyId, filterString, !ignoreCase));
        if (!this.isApplyFiltersImmediately()) {
            this.applyFilters();
        }
    }

    @Override
    public void removeAllContainerFilters() {
        this.removeAllFilters();
        if (!this.isApplyFiltersImmediately()) {
            this.applyFilters();
        }
    }

    @Override
    public void removeContainerFilters(Object propertyId) {
        List<Filter> filters = this.getFilters();
        for (int i = filters.size() - 1; i >= 0; --i) {
            Filter f = filters.get(i);
            if (!(f instanceof PropertyFilter) || !((PropertyFilter)f).getPropertyId().equals(propertyId)) continue;
            this.removeFilter(f);
        }
        if (!this.isApplyFiltersImmediately()) {
            this.applyFilters();
        }
    }

    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.addFilter(AdvancedFilterableSupport.convertFilter(filter));
        if (!this.isApplyFiltersImmediately()) {
            this.applyFilters();
        }
    }

    public void removeContainerFilter(Container.Filter filter) {
        this.removeFilter(AdvancedFilterableSupport.convertFilter(filter));
        if (!this.isApplyFiltersImmediately()) {
            this.applyFilters();
        }
    }

    public Object addItemAt(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Item addItemAt(int index, Object newItemId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getIdByIndex(int index) {
        if (this.isWriteThrough()) {
            return this.doGetEntityProvider().getEntityIdentifierAt(this.getAppliedFiltersAsConjunction(), this.getSortByList(), index);
        }
        int addedItems = this.bufferingDelegate.getAddedItemIds().size();
        if (index < addedItems) {
            return this.bufferingDelegate.getAddedItemIds().get(index);
        }
        Object itemId = this.doGetEntityProvider().getEntityIdentifierAt(this.getAppliedFiltersAsConjunction(), this.getSortByList(), index - addedItems);
        return itemId;
    }

    public int indexOfId(Object itemId) {
        if (this.size() > 100) {
            System.err.println("(JPAContainer) WARNING! Invoking indexOfId() when size > 100 is not recommended!");
        }
        for (int i = 0; i < this.size(); ++i) {
            Object id = this.getIdByIndex(i);
            if (id == null) {
                return -1;
            }
            if (!id.equals(itemId)) continue;
            return i;
        }
        return -1;
    }

    protected void requireWritableContainer() throws IllegalStateException, UnsupportedOperationException {
        if (!(this.entityProvider instanceof MutableEntityProvider)) {
            throw new UnsupportedOperationException("EntityProvider does not support editing");
        }
        if (this.readOnly) {
            throw new IllegalStateException("Container is read only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addEntity(T entity) throws UnsupportedOperationException, IllegalStateException {
        Object id;
        assert (entity != null) : "entity must not be null";
        this.requireWritableContainer();
        if (this.isWriteThrough()) {
            T result = ((MutableEntityProvider)this.getEntityProvider()).addEntity(entity);
            id = this.getEntityClassMetadata().getPropertyValue(result, this.getEntityClassMetadata().getIdentifierProperty().getName());
        } else {
            id = this.bufferingDelegate.addEntity(entity);
        }
        this.setFireItemSetChangeOnProviderChange(false);
        try {
            this.fireContainerItemSetChange(new ItemAddedEvent(id));
        }
        finally {
            this.setFireItemSetChangeOnProviderChange(true);
        }
        return id;
    }

    public boolean removeAllItems() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        assert (itemId != null) : "itemId must not be null";
        this.requireWritableContainer();
        if (this.isWriteThrough()) {
            if (this.getEntityProvider().containsEntity(itemId, null)) {
                ((MutableEntityProvider)this.getEntityProvider()).removeEntity(itemId);
                this.setFireItemSetChangeOnProviderChange(false);
                try {
                    this.fireContainerItemSetChange(new ItemRemovedEvent(itemId));
                }
                finally {
                    this.setFireItemSetChangeOnProviderChange(true);
                }
                return true;
            }
            return false;
        }
        if (this.bufferingDelegate.isAdded(itemId) || this.getEntityProvider().containsEntity(itemId, null)) {
            this.bufferingDelegate.deleteItem(itemId);
            this.setFireItemSetChangeOnProviderChange(false);
            try {
                this.fireContainerItemSetChange(new ItemRemovedEvent(itemId));
            }
            finally {
                this.setFireItemSetChangeOnProviderChange(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containerItemPropertyModified(JPAContainerItem<T> item, String propertyId) {
        assert (item != null) : "item must not be null";
        assert (propertyId != null) : "propertyId must not be null";
        if (item.getItemId() != null) {
            this.requireWritableContainer();
            Object itemId = item.getItemId();
            if (this.isWriteThrough()) {
                ((MutableEntityProvider)this.getEntityProvider()).updateEntityProperty(itemId, propertyId, item.getItemProperty(propertyId).getValue());
                item.setDirty(false);
            } else {
                this.bufferingDelegate.updateEntity(itemId, item.getEntity());
            }
            this.setFireItemSetChangeOnProviderChange(false);
            try {
                this.fireContainerItemSetChange(new ItemUpdatedEvent(itemId));
            }
            finally {
                this.setFireItemSetChangeOnProviderChange(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void containerItemModified(JPAContainerItem<T> item) {
        assert (item != null) : "item must not be null";
        if (item.getItemId() != null) {
            this.requireWritableContainer();
            Object itemId = item.getItemId();
            if (this.isWriteThrough()) {
                ((MutableEntityProvider)this.getEntityProvider()).updateEntity(item.getEntity());
                item.setDirty(false);
            } else {
                this.bufferingDelegate.updateEntity(itemId, item.getEntity());
            }
            this.setFireItemSetChangeOnProviderChange(false);
            try {
                this.fireContainerItemSetChange(new ItemUpdatedEvent(itemId));
            }
            finally {
                this.setFireItemSetChangeOnProviderChange(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        if (!this.isWriteThrough() && this.isModified()) {
            this.bufferingDelegate.commit();
            this.setFireItemSetChangeOnProviderChange(false);
            try {
                this.fireContainerItemSetChange(new ChangesCommittedEvent());
            }
            finally {
                this.setFireItemSetChangeOnProviderChange(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() throws Buffered.SourceException {
        if (!this.isWriteThrough() && this.isModified()) {
            this.bufferingDelegate.discard();
            this.setFireItemSetChangeOnProviderChange(false);
            try {
                this.fireContainerItemSetChange(new ChangesDiscardedEvent());
            }
            finally {
                this.setFireItemSetChangeOnProviderChange(true);
            }
        }
    }

    public boolean isModified() {
        if (this.isWriteThrough()) {
            return false;
        }
        return this.bufferingDelegate.isModified();
    }

    public boolean isReadThrough() {
        EntityProvider<T> ep = this.doGetEntityProvider();
        if (ep instanceof CachingEntityProvider) {
            return !((CachingEntityProvider)ep).isCacheInUse();
        }
        return true;
    }

    public boolean isWriteThrough() {
        return !(this.doGetEntityProvider() instanceof BatchableEntityProvider) || this.writeThrough;
    }

    public void setReadThrough(boolean readThrough) throws Buffered.SourceException {
        throw new UnsupportedOperationException();
    }

    public void setWriteThrough(boolean writeThrough) throws Buffered.SourceException, Validator.InvalidValueException {
        if (writeThrough) {
            this.commit();
            this.writeThrough = writeThrough;
        } else if (this.doGetEntityProvider() instanceof BatchableEntityProvider) {
            this.writeThrough = writeThrough;
        } else {
            throw new UnsupportedOperationException("EntityProvider is not batchable");
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws Buffered.SourceException, Validator.InvalidValueException {
        this.setWriteThrough(autoCommit);
    }

    @Override
    public boolean isAutoCommit() {
        return this.isWriteThrough();
    }

    @Override
    public String getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        this.parentProperty = parentProperty;
        if (parentProperty == null) {
            this.parentIdProperty = null;
        } else {
            StringBuilder sb = new StringBuilder(parentProperty);
            sb.append('.');
            sb.append(this.getEntityClassMetadata().getIdentifierProperty().getName());
            this.parentIdProperty = sb.toString();
        }
    }

    public boolean areChildrenAllowed(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return this.parentProperty != null && this.containsId(itemId);
    }

    private Filter getChildrenFilter(Object parentId) {
        PropertyFilter parentFilter = parentId == null ? Filters.isNull(this.parentProperty) : Filters.eq(this.parentIdProperty, parentId);
        Filter appliedFilter = this.getAppliedFiltersAsConjunction();
        if (appliedFilter == null) {
            return parentFilter;
        }
        return Filters.and(parentFilter, appliedFilter);
    }

    public Collection<?> getChildren(Object itemId) {
        if (this.getParentProperty() == null) {
            if (itemId == null) {
                return this.getItemIds();
            }
            return Collections.emptyList();
        }
        return this.doGetEntityProvider().getAllEntityIdentifiers(this.getChildrenFilter(itemId), this.getSortByList());
    }

    public Object getParent(Object itemId) {
        Object parent;
        if (this.parentProperty == null) {
            return null;
        }
        Item item = this.getItem(itemId);
        Object object = parent = item == null ? null : item.getItemProperty(this.parentProperty).getValue();
        if (parent == null) {
            return null;
        }
        return this.getEntityClassMetadata().getPropertyValue(parent, this.getEntityClassMetadata().getIdentifierProperty().getName());
    }

    public boolean hasChildren(Object itemId) {
        return !this.getChildren(itemId).isEmpty();
    }

    public boolean isRoot(Object itemId) {
        return this.getParent(itemId) == null;
    }

    public Collection<?> rootItemIds() {
        return this.getChildren(null);
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean setParent(Object itemId, Object newParentId) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public final class ItemRemovedEvent
    extends ItemEvent {
        private static final long serialVersionUID = 530688830477630703L;

        protected ItemRemovedEvent(Object itemId) {
            super(itemId);
        }
    }

    public final class ItemUpdatedEvent
    extends ItemEvent {
        private static final long serialVersionUID = 4464120712728895566L;

        protected ItemUpdatedEvent(Object itemId) {
            super(itemId);
        }
    }

    public final class ItemAddedEvent
    extends ItemEvent {
        private static final long serialVersionUID = 197074826066153230L;

        protected ItemAddedEvent(Object itemId) {
            super(itemId);
        }
    }

    public abstract class ItemEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = -7867054889972105067L;
        protected final Object itemId;

        protected ItemEvent(Object itemId) {
            this.itemId = itemId;
        }

        public Container getContainer() {
            return JPAContainer.this;
        }

        public Object getItemId() {
            return this.itemId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ProviderChangedEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = -2719424959990430585L;
        private final EntityProviderChangeEvent<?> event;

        protected ProviderChangedEvent(EntityProviderChangeEvent<?> event) {
            this.event = event;
        }

        public Container getContainer() {
            return JPAContainer.this;
        }

        public EntityProviderChangeEvent<?> getChangeEvent() {
            return this.event;
        }
    }

    public final class ItemNotFoundEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = 7542676056363040711L;

        protected ItemNotFoundEvent() {
        }

        public Container getContainer() {
            return JPAContainer.this;
        }
    }

    public final class AllItemsRemovedEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = -7429226164483121998L;

        protected AllItemsRemovedEvent() {
        }

        public Container getContainer() {
            return JPAContainer.this;
        }
    }

    public final class ChangesDiscardedEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = 1192258036968002982L;

        protected ChangesDiscardedEvent() {
        }

        public Container getContainer() {
            return JPAContainer.this;
        }
    }

    public final class ChangesCommittedEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = -7802570988994951818L;

        protected ChangesCommittedEvent() {
        }

        public Container getContainer() {
            return JPAContainer.this;
        }
    }

    public final class ContainerSortedEvent
    implements Container.ItemSetChangeEvent {
        private static final long serialVersionUID = -4330673683011445634L;

        protected ContainerSortedEvent() {
        }

        public Container getContainer() {
            return JPAContainer.this;
        }
    }
}

