/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer;

import com.vaadin.addon.jpacontainer.EntityContainer;
import com.vaadin.addon.jpacontainer.EntityItem;
import com.vaadin.addon.jpacontainer.EntityItemProperty;
import com.vaadin.addon.jpacontainer.JPAContainer;
import com.vaadin.addon.jpacontainer.PropertyList;
import com.vaadin.data.Buffered;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JPAContainerItem<T>
implements EntityItem<T> {
    private static final long serialVersionUID = 3835181888110236341L;
    private T entity;
    private JPAContainer<T> container;
    private PropertyList<T> propertyList;
    private Map<Object, ItemProperty> propertyMap;
    private boolean modified = false;
    private boolean dirty = false;
    private boolean persistent = true;
    private boolean readThrough = true;
    private boolean writeThrough = true;
    private boolean deleted = false;
    private Object itemId;

    private static boolean nullSafeEquals(Object o1, Object o2) {
        try {
            return o1 == o2 || o1.equals(o2);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    JPAContainerItem(JPAContainer<T> container, T entity) {
        this(container, entity, container.getEntityClassMetadata().getPropertyValue(entity, container.getEntityClassMetadata().getIdentifierProperty().getName()), true);
    }

    JPAContainerItem(JPAContainer<T> container, T entity, Object itemId, boolean persistent) {
        assert (container != null) : "container must not be null";
        assert (entity != null) : "entity must not be null";
        this.entity = entity;
        this.container = container;
        this.propertyList = new PropertyList<T>(container.getPropertyList());
        this.itemId = itemId;
        this.persistent = itemId == null ? false : persistent;
        this.propertyMap = new HashMap<Object, ItemProperty>();
    }

    @Override
    public Object getItemId() {
        return this.itemId;
    }

    @Override
    public boolean addItemProperty(Object id, Property property) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addNestedContainerProperty(String nestedProperty) throws UnsupportedOperationException {
        this.propertyList.addNestedProperty(nestedProperty);
    }

    @Override
    public EntityItemProperty getItemProperty(Object id) {
        assert (id != null) : "id must not be null";
        ItemProperty p = this.propertyMap.get(id);
        if (p == null) {
            if (!this.getItemPropertyIds().contains(id.toString())) {
                return null;
            }
            p = new ItemProperty(id.toString());
            this.propertyMap.put(id, p);
        }
        return p;
    }

    @Override
    public Collection<String> getItemPropertyIds() {
        return this.propertyList.getAllAvailablePropertyNames();
    }

    @Override
    public boolean removeItemProperty(Object id) throws UnsupportedOperationException {
        assert (id != null) : "id must not be null";
        if (id.toString().indexOf(46) > -1) {
            return this.propertyList.removeProperty(id.toString());
        }
        return false;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.isPersistent() && this.dirty;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    @Override
    public boolean isDeleted() {
        return this.isPersistent() && !this.getContainer().isWriteThrough() && this.deleted;
    }

    void setDeleted(boolean deleted) {
        this.deleted = true;
    }

    @Override
    public EntityContainer<T> getContainer() {
        return this.container;
    }

    @Override
    public T getEntity() {
        return this.entity;
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        if (!this.isWriteThrough()) {
            try {
                for (ItemProperty prop : this.propertyMap.values()) {
                    prop.commit();
                }
                this.modified = false;
                this.container.containerItemModified(this);
            }
            catch (Property.ConversionException e) {
                throw new Validator.InvalidValueException(e.getMessage());
            }
            catch (Property.ReadOnlyException e) {
                throw new Buffered.SourceException((Buffered)this, (Throwable)e);
            }
        }
    }

    public void discard() throws Buffered.SourceException {
        if (!this.isWriteThrough()) {
            for (ItemProperty prop : this.propertyMap.values()) {
                prop.discard();
            }
            this.modified = false;
        }
    }

    public boolean isReadThrough() {
        return this.readThrough;
    }

    public boolean isWriteThrough() {
        return this.writeThrough;
    }

    public void setReadThrough(boolean readThrough) throws Buffered.SourceException {
        if (this.readThrough != readThrough) {
            if (!readThrough && this.writeThrough) {
                throw new IllegalStateException("ReadThrough can only be turned off if WriteThrough is turned off");
            }
            for (ItemProperty prop : this.propertyMap.values()) {
                prop.notifyListenersIfCacheAndRealValueDiffer();
            }
            this.readThrough = readThrough;
        }
    }

    public void setWriteThrough(boolean writeThrough) throws Buffered.SourceException, Validator.InvalidValueException {
        if (this.writeThrough != writeThrough) {
            if (writeThrough) {
                this.commit();
                for (ItemProperty prop : this.propertyMap.values()) {
                    prop.clearCache();
                }
            } else {
                for (ItemProperty prop : this.propertyMap.values()) {
                    prop.cacheRealValue();
                }
            }
            this.writeThrough = writeThrough;
            this.setReadThrough(writeThrough);
        }
    }

    @Override
    public void addListener(Property.ValueChangeListener listener) {
        for (String propertyId : this.getItemPropertyIds()) {
            this.getItemProperty(propertyId).addListener(listener);
        }
    }

    @Override
    public void removeListener(Property.ValueChangeListener listener) {
        for (String propertyId : this.getItemPropertyIds()) {
            this.getItemProperty(propertyId).removeListener(listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ItemProperty
    implements EntityItemProperty {
        private static final long serialVersionUID = 2791934277775480650L;
        private String propertyId;
        private Object cachedValue;
        private List<Property.ValueChangeListener> listeners;

        ItemProperty(String propertyId) {
            assert (propertyId != null) : "propertyId must not be null";
            this.propertyId = propertyId;
            if (!JPAContainerItem.this.isWriteThrough()) {
                this.cacheRealValue();
            }
        }

        void notifyListenersIfCacheAndRealValueDiffer() {
            Object realValue = this.getRealValue();
            if (!JPAContainerItem.nullSafeEquals(realValue, this.cachedValue)) {
                this.notifyListeners();
            }
        }

        void cacheRealValue() {
            Object realValue;
            this.cachedValue = realValue = this.getRealValue();
        }

        void clearCache() {
            this.cachedValue = null;
        }

        void commit() throws Property.ConversionException {
            if (!this.isReadOnly()) {
                try {
                    this.setRealValue(this.cachedValue);
                }
                catch (Exception e) {
                    throw new Property.ConversionException((Throwable)e);
                }
                if (JPAContainerItem.this.isReadThrough()) {
                    this.notifyListeners();
                }
            }
        }

        void discard() {
            Object realValue = this.getRealValue();
            if (!JPAContainerItem.nullSafeEquals(realValue, this.cachedValue)) {
                this.cacheRealValue();
                if (!JPAContainerItem.this.isReadThrough()) {
                    this.notifyListeners();
                }
            } else {
                this.cacheRealValue();
            }
        }

        @Override
        public EntityItem<?> getItem() {
            return JPAContainerItem.this;
        }

        public Class<?> getType() {
            return JPAContainerItem.this.propertyList.getPropertyType(this.propertyId);
        }

        public Object getValue() {
            if (JPAContainerItem.this.isReadThrough()) {
                return this.getRealValue();
            }
            return this.cachedValue;
        }

        private Object getRealValue() {
            return JPAContainerItem.this.propertyList.getPropertyValue(JPAContainerItem.this.entity, this.propertyId);
        }

        public String toString() {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        public boolean isReadOnly() {
            return !JPAContainerItem.this.propertyList.isPropertyWritable(this.propertyId);
        }

        public void setReadOnly(boolean newStatus) {
            throw new UnsupportedOperationException("The read only state cannot be changed");
        }

        private void setRealValue(Object newValue) {
            JPAContainerItem.this.propertyList.setPropertyValue(JPAContainerItem.this.entity, this.propertyId, newValue);
            JPAContainerItem.this.dirty = true;
        }

        public void setValue(Object newValue) throws Property.ReadOnlyException, Property.ConversionException {
            if (this.isReadOnly()) {
                throw new Property.ReadOnlyException();
            }
            if (newValue != null && !this.getType().isAssignableFrom(newValue.getClass())) {
                try {
                    Constructor<?> constr = this.getType().getConstructor(String.class);
                    newValue = constr.newInstance(newValue.toString());
                }
                catch (Exception e) {
                    throw new Property.ConversionException((Throwable)e);
                }
            }
            try {
                if (JPAContainerItem.this.isWriteThrough()) {
                    this.setRealValue(newValue);
                    JPAContainerItem.this.container.containerItemPropertyModified(JPAContainerItem.this, this.propertyId);
                } else {
                    this.cachedValue = newValue;
                    JPAContainerItem.this.modified = true;
                }
            }
            catch (Exception e) {
                throw new Property.ConversionException((Throwable)e);
            }
            if (!JPAContainerItem.this.isReadThrough() || JPAContainerItem.this.isWriteThrough()) {
                this.notifyListeners();
            }
        }

        private void notifyListeners() {
            if (this.listeners != null) {
                Object[] l = this.listeners.toArray();
                ValueChangeEvent event = new ValueChangeEvent(this);
                for (int i = 0; i < l.length; ++i) {
                    ((Property.ValueChangeListener)l[i]).valueChange((Property.ValueChangeEvent)event);
                }
            }
        }

        public void addListener(Property.ValueChangeListener listener) {
            assert (listener != null) : "listener must not be null";
            if (this.listeners == null) {
                this.listeners = new LinkedList<Property.ValueChangeListener>();
            }
            this.listeners.add(listener);
        }

        public void removeListener(Property.ValueChangeListener listener) {
            assert (listener != null) : "listener must not be null";
            if (this.listeners != null) {
                this.listeners.remove(listener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ValueChangeEvent
        extends EventObject
        implements Property.ValueChangeEvent {
            private static final long serialVersionUID = 4999596001491426923L;

            private ValueChangeEvent(ItemProperty source) {
                super(source);
            }

            public Property getProperty() {
                return (Property)this.getSource();
            }
        }
    }
}

