/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.filter;

import com.vaadin.addon.jpacontainer.Filter;
import com.vaadin.addon.jpacontainer.filter.BetweenFilter;
import com.vaadin.addon.jpacontainer.filter.ComparisonFilter;
import com.vaadin.addon.jpacontainer.filter.Conjunction;
import com.vaadin.addon.jpacontainer.filter.Disjunction;
import com.vaadin.addon.jpacontainer.filter.IntervalFilter;
import com.vaadin.addon.jpacontainer.filter.IsEmptyFilter;
import com.vaadin.addon.jpacontainer.filter.IsNotEmptyFilter;
import com.vaadin.addon.jpacontainer.filter.IsNotNullFilter;
import com.vaadin.addon.jpacontainer.filter.IsNullFilter;
import com.vaadin.addon.jpacontainer.filter.JoinFilter;
import com.vaadin.addon.jpacontainer.filter.Junction;
import com.vaadin.addon.jpacontainer.filter.Negation;
import com.vaadin.addon.jpacontainer.filter.OutsideFilter;
import com.vaadin.addon.jpacontainer.filter.PropertyFilter;
import com.vaadin.addon.jpacontainer.filter.SimpleJoinFilter;
import com.vaadin.addon.jpacontainer.filter.StringComparisonFilter;
import com.vaadin.addon.jpacontainer.filter.ValueFilter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Filters {
    private Filters() {
    }

    public static PropertyFilter isNull(Object propertyId) {
        return new IsNullFilter(propertyId);
    }

    public static PropertyFilter isNotNull(Object propertyId) {
        return new IsNotNullFilter(propertyId);
    }

    public static PropertyFilter isEmpty(Object propertyId) {
        return new IsEmptyFilter(propertyId);
    }

    public static PropertyFilter isNotEmpty(Object propertyId) {
        return new IsNotEmptyFilter(propertyId);
    }

    public static ValueFilter eq(Object propertyId, String value, boolean caseSensitive) {
        return new StringComparisonFilter(propertyId, value, caseSensitive, "=");
    }

    public static ValueFilter like(Object propertyId, String value, boolean caseSensitive) {
        return new StringComparisonFilter(propertyId, value, caseSensitive, "like");
    }

    public static ValueFilter eq(Object propertyId, Object value) {
        return new ComparisonFilter(propertyId, value, "=");
    }

    public static ValueFilter gteq(Object propertyId, Object value) {
        return new ComparisonFilter(propertyId, value, ">=");
    }

    public static ValueFilter gt(Object propertyId, Object value) {
        return new ComparisonFilter(propertyId, value, ">");
    }

    public static ValueFilter lteq(Object propertyId, Object value) {
        return new ComparisonFilter(propertyId, value, "<=");
    }

    public static ValueFilter lt(Object propertyId, Object value) {
        return new ComparisonFilter(propertyId, value, "<");
    }

    public static IntervalFilter between(Object propertyId, Object startingPoint, Object endingPoint, boolean includeStartingPoint, boolean includeEndingPoint) {
        return new BetweenFilter(propertyId, startingPoint, includeStartingPoint, endingPoint, includeEndingPoint);
    }

    public static IntervalFilter betweenInclusive(Object propertyId, Object startingPoint, Object endingPoint) {
        return Filters.between(propertyId, startingPoint, endingPoint, true, true);
    }

    public static IntervalFilter betweenExlusive(Object propertyId, Object startingPoint, Object endingPoint) {
        return Filters.between(propertyId, startingPoint, endingPoint, false, false);
    }

    public static IntervalFilter outside(Object propertyId, Object startingPoint, Object endingPoint, boolean includeStartingPoint, boolean includeEndingPoint) {
        return new OutsideFilter(propertyId, startingPoint, includeStartingPoint, endingPoint, includeEndingPoint);
    }

    public static IntervalFilter outsideInclusive(Object propertyId, Object startingPoint, Object endingPoint) {
        return Filters.outside(propertyId, startingPoint, endingPoint, true, true);
    }

    public static IntervalFilter outsideExclusive(Object propertyId, Object startingPoint, Object endingPoint) {
        return Filters.outside(propertyId, startingPoint, endingPoint, false, false);
    }

    public static Filter not(Filter filter) {
        return new Negation(filter);
    }

    public static Junction and(Filter ... filters) {
        return new Conjunction(filters);
    }

    public static Junction and(List<Filter> filters) {
        return new Conjunction(filters);
    }

    public static Junction or(Filter ... filters) {
        return new Disjunction(filters);
    }

    public static Junction or(List<Filter> filters) {
        return new Disjunction(filters);
    }

    public static JoinFilter joinFilter(String joinProperty, Filter ... filters) {
        return new SimpleJoinFilter(joinProperty, filters);
    }
}

