/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.metadata;

import com.vaadin.addon.jpacontainer.metadata.ClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.EntityClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.PersistentPropertyMetadata;
import com.vaadin.addon.jpacontainer.metadata.PropertyMetadata;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataFactory {
    private static MetadataFactory INSTANCE;
    private Map<Class<?>, ClassMetadata<?>> metadataMap = new HashMap();

    protected MetadataFactory() {
    }

    public static MetadataFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetadataFactory();
        }
        return INSTANCE;
    }

    public <T> EntityClassMetadata<T> getEntityClassMetadata(Class<T> mappedClass) throws IllegalArgumentException {
        assert (mappedClass != null) : "mappedClass must not be null";
        if (mappedClass.getAnnotation(Entity.class) == null) {
            throw new IllegalArgumentException("The class is not an entity");
        }
        PersistentPropertyMetadata.AccessType accessType = this.determineAccessType(mappedClass);
        if (accessType == null) {
            throw new IllegalArgumentException("The access type could not be determined");
        }
        return (EntityClassMetadata)this.getClassMetadata(mappedClass, accessType);
    }

    public <T> ClassMetadata<T> getClassMetadata(Class<T> mappedClass, PersistentPropertyMetadata.AccessType accessType) throws IllegalArgumentException {
        assert (mappedClass != null) : "mappedClass must not be null";
        assert (accessType != null) : "accessType must not be null";
        ClassMetadata<Object> metadata = this.metadataMap.get(mappedClass);
        if (metadata != null) {
            return metadata;
        }
        Entity entity = mappedClass.getAnnotation(Entity.class);
        Embeddable embeddable = mappedClass.getAnnotation(Embeddable.class);
        if (entity != null) {
            String entityName = entity.name().length() == 0 ? mappedClass.getSimpleName() : entity.name();
            metadata = new EntityClassMetadata(mappedClass, entityName);
            this.metadataMap.put(mappedClass, metadata);
            this.loadProperties(mappedClass, metadata, accessType);
            EntityClassMetadata entityMetadata = (EntityClassMetadata)metadata;
            for (PersistentPropertyMetadata pm : entityMetadata.getPersistentProperties()) {
                if (pm.getAnnotation(Version.class) != null) {
                    entityMetadata.setVersionPropertyName(pm.getName());
                } else if (pm.getAnnotation(Id.class) != null || pm.getAnnotation(EmbeddedId.class) != null) {
                    entityMetadata.setIdentifierPropertyName(pm.getName());
                }
                if (!entityMetadata.hasIdentifierProperty() || !entityMetadata.hasVersionProperty()) continue;
                break;
            }
        } else if (embeddable != null) {
            metadata = new ClassMetadata<T>(mappedClass);
            this.metadataMap.put(mappedClass, metadata);
            this.loadProperties(mappedClass, metadata, accessType);
        } else {
            throw new IllegalArgumentException("The class is nether an entity nor embeddable");
        }
        return metadata;
    }

    protected void loadProperties(Class<?> type, ClassMetadata<?> metadata, PersistentPropertyMetadata.AccessType accessType) {
        Class<?> superclass = type.getSuperclass();
        if (superclass != null && (superclass.getAnnotation(MappedSuperclass.class) != null || superclass.getAnnotation(Entity.class) != null) || superclass.getAnnotation(Embeddable.class) != null) {
            this.loadProperties(superclass, metadata, accessType);
        }
        if (accessType == PersistentPropertyMetadata.AccessType.FIELD) {
            this.extractPropertiesFromFields(type, metadata);
        } else {
            this.extractPropertiesFromMethods(type, metadata);
        }
    }

    protected PersistentPropertyMetadata.AccessType determineAccessType(Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            if (field.getAnnotation(Id.class) == null && field.getAnnotation(EmbeddedId.class) == null) continue;
            return PersistentPropertyMetadata.AccessType.FIELD;
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (((Method)accessibleObject).getAnnotation(Id.class) == null && ((Method)accessibleObject).getAnnotation(EmbeddedId.class) == null) continue;
            return PersistentPropertyMetadata.AccessType.METHOD;
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass != null && (superclass.getAnnotation(MappedSuperclass.class) != null || superclass.getAnnotation(Entity.class) != null)) {
            return this.determineAccessType(superclass);
        }
        return null;
    }

    protected boolean isReference(AccessibleObject ab) {
        return ab.getAnnotation(OneToOne.class) != null || ab.getAnnotation(ManyToOne.class) != null;
    }

    protected boolean isCollection(AccessibleObject ab) {
        return ab.getAnnotation(OneToMany.class) != null || ab.getAnnotation(ManyToMany.class) != null;
    }

    protected boolean isEmbedded(AccessibleObject ab) {
        return ab.getAnnotation(Embedded.class) != null || ab.getAnnotation(EmbeddedId.class) != null;
    }

    protected void extractPropertiesFromFields(Class<?> type, ClassMetadata<?> metadata) {
        int mod;
        for (Field field : type.getDeclaredFields()) {
            ClassMetadata<?> cm;
            mod = field.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || Modifier.isTransient(mod) || field.getAnnotation(Transient.class) != null) continue;
            if (this.isEmbedded(field)) {
                cm = this.getClassMetadata(field.getType(), PersistentPropertyMetadata.AccessType.FIELD);
                metadata.addProperties(new PersistentPropertyMetadata(field.getName(), cm, PersistentPropertyMetadata.PropertyKind.EMBEDDED, field));
                continue;
            }
            if (this.isReference(field)) {
                cm = this.getClassMetadata(field.getType(), PersistentPropertyMetadata.AccessType.FIELD);
                metadata.addProperties(new PersistentPropertyMetadata(field.getName(), cm, PersistentPropertyMetadata.PropertyKind.REFERENCE, field));
                continue;
            }
            if (this.isCollection(field)) {
                metadata.addProperties(new PersistentPropertyMetadata(field.getName(), field.getType(), PersistentPropertyMetadata.PropertyKind.COLLECTION, field));
                continue;
            }
            metadata.addProperties(new PersistentPropertyMetadata(field.getName(), this.convertPrimitiveType(field.getType()), PersistentPropertyMetadata.PropertyKind.SIMPLE, field));
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            mod = ((Method)accessibleObject).getModifiers();
            if (!((Method)accessibleObject).getName().startsWith("get") || Modifier.isStatic(mod) || ((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).getReturnType() == Void.TYPE) continue;
            Method setter = null;
            try {
                setter = type.getDeclaredMethod("set" + ((Method)accessibleObject).getName().substring(3), ((Method)accessibleObject).getReturnType());
            }
            catch (NoSuchMethodException ignoreit) {
                // empty catch block
            }
            String name = Introspector.decapitalize(((Method)accessibleObject).getName().substring(3));
            if (metadata.getProperty(name) != null) continue;
            metadata.addProperties(new PropertyMetadata(name, ((Method)accessibleObject).getReturnType(), (Method)accessibleObject, setter));
        }
    }

    private Class<?> convertPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                type = Boolean.class;
            } else if (type.equals(Integer.TYPE)) {
                type = Integer.class;
            } else if (type.equals(Float.TYPE)) {
                type = Float.class;
            } else if (type.equals(Double.TYPE)) {
                type = Double.class;
            } else if (type.equals(Byte.TYPE)) {
                type = Byte.class;
            } else if (type.equals(Character.TYPE)) {
                type = Character.class;
            } else if (type.equals(Short.TYPE)) {
                type = Short.class;
            } else if (type.equals(Long.TYPE)) {
                type = Long.class;
            }
        }
        return type;
    }

    protected void extractPropertiesFromMethods(Class<?> type, ClassMetadata<?> metadata) {
        for (Method m : type.getDeclaredMethods()) {
            int mod = m.getModifiers();
            if (!m.getName().startsWith("get") || Modifier.isStatic(mod) || m.isSynthetic() || m.getReturnType() == Void.TYPE) continue;
            Method setter = null;
            try {
                setter = type.getDeclaredMethod("set" + m.getName().substring(3), m.getReturnType());
            }
            catch (NoSuchMethodException ignoreit) {
                // empty catch block
            }
            String name = Introspector.decapitalize(m.getName().substring(3));
            if (setter != null && m.getAnnotation(Transient.class) == null) {
                ClassMetadata<?> cm;
                if (this.isEmbedded(m)) {
                    cm = this.getClassMetadata(m.getReturnType(), PersistentPropertyMetadata.AccessType.METHOD);
                    metadata.addProperties(new PersistentPropertyMetadata(name, cm, PersistentPropertyMetadata.PropertyKind.EMBEDDED, m, setter));
                    continue;
                }
                if (this.isReference(m)) {
                    cm = this.getClassMetadata(m.getReturnType(), PersistentPropertyMetadata.AccessType.METHOD);
                    metadata.addProperties(new PersistentPropertyMetadata(name, cm, PersistentPropertyMetadata.PropertyKind.REFERENCE, m, setter));
                    continue;
                }
                if (this.isCollection(m)) {
                    metadata.addProperties(new PersistentPropertyMetadata(name, m.getReturnType(), PersistentPropertyMetadata.PropertyKind.COLLECTION, m, setter));
                    continue;
                }
                metadata.addProperties(new PersistentPropertyMetadata(name, m.getReturnType(), PersistentPropertyMetadata.PropertyKind.SIMPLE, m, setter));
                continue;
            }
            metadata.addProperties(new PropertyMetadata(name, m.getReturnType(), m, setter));
        }
    }
}

