/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.metadata;

import com.vaadin.addon.jpacontainer.metadata.ClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.PropertyMetadata;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentPropertyMetadata
extends PropertyMetadata {
    private static final long serialVersionUID = -4097189601179456814L;
    private final PropertyKind propertyKind;
    private final ClassMetadata<?> typeMetadata;
    final transient Field field;
    protected final String fieldName;
    protected final Class<?> fieldDeclaringClass;

    PersistentPropertyMetadata(String name, Class<?> type, PropertyKind propertyKind, Field field) {
        super(name, type, null, null);
        assert (propertyKind == PropertyKind.COLLECTION || propertyKind == PropertyKind.SIMPLE) : "propertyKind must be COLLECTION or SIMPLE";
        assert (field != null) : "field must not be null";
        this.propertyKind = propertyKind;
        this.typeMetadata = null;
        this.field = field;
        this.fieldName = field.getName();
        this.fieldDeclaringClass = field.getDeclaringClass();
    }

    PersistentPropertyMetadata(String name, Class<?> type, PropertyKind propertyKind, Method getter, Method setter) {
        super(name, type, getter, setter);
        assert (propertyKind == PropertyKind.COLLECTION || propertyKind == PropertyKind.SIMPLE) : "propertyKind must be COLLECTION or SIMPLE";
        assert (getter != null) : "getter must not be null";
        assert (setter != null) : "setter must not be null";
        this.propertyKind = propertyKind;
        this.typeMetadata = null;
        this.field = null;
        this.fieldName = null;
        this.fieldDeclaringClass = null;
    }

    PersistentPropertyMetadata(String name, ClassMetadata<?> type, PropertyKind propertyKind, Field field) {
        super(name, type.getMappedClass(), null, null);
        assert (type != null) : "type must not be null";
        assert (propertyKind == PropertyKind.REFERENCE || propertyKind == PropertyKind.EMBEDDED) : "propertyKind must be REFERENCE or EMBEDDED";
        assert (field != null) : "field must not be null";
        this.propertyKind = propertyKind;
        this.typeMetadata = type;
        this.field = field;
        this.fieldName = field.getName();
        this.fieldDeclaringClass = field.getDeclaringClass();
    }

    PersistentPropertyMetadata(String name, ClassMetadata<?> type, PropertyKind propertyKind, Method getter, Method setter) {
        super(name, type.getMappedClass(), getter, setter);
        assert (type != null) : "type must not be null";
        assert (propertyKind == PropertyKind.REFERENCE || propertyKind == PropertyKind.EMBEDDED) : "propertyKind must be REFERENCE or EMBEDDED";
        assert (getter != null) : "getter must not be null";
        assert (setter != null) : "setter must not be null";
        this.propertyKind = propertyKind;
        this.typeMetadata = type;
        this.field = null;
        this.fieldName = null;
        this.fieldDeclaringClass = null;
    }

    private PersistentPropertyMetadata(String name, ClassMetadata<?> typeMetadata, Class<?> type, PropertyKind propertyKind, Method getter, Method setter, Field field) {
        super(name, type, getter, setter);
        this.propertyKind = propertyKind;
        this.typeMetadata = typeMetadata;
        this.field = field;
        if (this.field == null) {
            this.fieldName = null;
            this.fieldDeclaringClass = null;
        } else {
            this.fieldName = field.getName();
            this.fieldDeclaringClass = field.getDeclaringClass();
        }
    }

    public ClassMetadata<?> getTypeMetadata() {
        return this.typeMetadata;
    }

    public PropertyKind getPropertyKind() {
        return this.propertyKind;
    }

    public AccessType getAccessType() {
        return this.field != null ? AccessType.FIELD : AccessType.METHOD;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.field != null) {
            return this.field.getAnnotation(annotationClass);
        }
        return super.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        return super.getAnnotations();
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        try {
            Field f = null;
            if (this.fieldName != null) {
                f = this.fieldDeclaringClass.getDeclaredField(this.fieldName);
            }
            Method getterM = null;
            if (this.getterName != null) {
                getterM = this.getterDeclaringClass.getDeclaredMethod(this.getterName, new Class[0]);
            }
            Method setterM = null;
            if (this.setterName != null) {
                setterM = this.setterDeclaringClass.getDeclaredMethod(this.setterName, this.getType());
            }
            return new PersistentPropertyMetadata(this.getName(), this.typeMetadata, this.getType(), this.propertyKind, getterM, setterM, f);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidObjectException(e.getMessage());
        }
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            PersistentPropertyMetadata other = (PersistentPropertyMetadata)obj;
            return this.propertyKind.equals((Object)other.propertyKind) && (this.typeMetadata == null ? other.typeMetadata == null : this.typeMetadata.getMappedClass().equals(other.typeMetadata.getMappedClass())) && (this.field == null ? other.field == null : this.field.equals(other.field));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.propertyKind.hashCode();
        if (this.typeMetadata != null) {
            hash = hash * 31 + this.typeMetadata.getMappedClass().hashCode();
        }
        if (this.field != null) {
            hash = hash * 31 + this.field.hashCode();
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessType {
        METHOD,
        FIELD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyKind {
        EMBEDDED,
        REFERENCE,
        COLLECTION,
        SIMPLE;

    }
}

