/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.metadata;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMetadata
implements Serializable {
    private static final long serialVersionUID = -6500231861860229121L;
    private final String name;
    private final Class<?> type;
    final transient Method getter;
    final transient Method setter;
    protected final String getterName;
    protected final String setterName;
    protected final Class<?> getterDeclaringClass;
    protected final Class<?> setterDeclaringClass;

    PropertyMetadata(String name, Class<?> type, Method getter, Method setter) {
        assert (name != null) : "name must not be null";
        assert (type != null) : "type must not be null";
        this.name = name;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        if (getter != null) {
            this.getterName = getter.getName();
            this.getterDeclaringClass = getter.getDeclaringClass();
        } else {
            this.getterName = null;
            this.getterDeclaringClass = null;
        }
        if (setter != null) {
            this.setterName = setter.getName();
            this.setterDeclaringClass = setter.getDeclaringClass();
        } else {
            this.setterName = null;
            this.setterDeclaringClass = null;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            Method getterM = null;
            if (this.getterName != null) {
                getterM = this.getterDeclaringClass.getDeclaredMethod(this.getterName, new Class[0]);
            }
            Method setterM = null;
            if (this.setterName != null) {
                setterM = this.setterDeclaringClass.getDeclaredMethod(this.setterName, this.type);
            }
            return new PropertyMetadata(this.name, this.type, getterM, setterM);
        }
        catch (Exception e) {
            throw new InvalidObjectException(e.getMessage());
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Annotation[] getAnnotations() {
        return this.getter.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getter.getAnnotation(annotationClass);
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            PropertyMetadata other = (PropertyMetadata)obj;
            return this.name.equals(other.name) && this.type.equals(other.type) && (this.getter == null ? other.getter == null : this.getter.equals(other.getter)) && (this.setter == null ? other.setter == null : this.setter.equals(other.setter));
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.name.hashCode();
        hash = hash * 31 + this.type.hashCode();
        if (this.getter != null) {
            hash = hash * 31 + this.getter.hashCode();
        }
        if (this.setter != null) {
            hash = hash * 31 + this.setter.hashCode();
        }
        return hash;
    }
}

