/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.provider;

import com.vaadin.addon.jpacontainer.CachingEntityProvider;
import com.vaadin.addon.jpacontainer.Filter;
import com.vaadin.addon.jpacontainer.SortBy;
import com.vaadin.addon.jpacontainer.provider.CachingSupport;
import com.vaadin.addon.jpacontainer.provider.LocalEntityProvider;
import java.util.List;
import javax.persistence.EntityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingLocalEntityProvider<T>
extends LocalEntityProvider<T>
implements CachingEntityProvider<T> {
    private static final long serialVersionUID = 302600441430870363L;
    private CachingSupport<T> cachingSupport = new CachingSupport(this);

    public CachingLocalEntityProvider(Class<T> entityClass) {
        super(entityClass);
    }

    public CachingLocalEntityProvider(Class<T> entityClass, EntityManager entityManager) {
        super(entityClass, entityManager);
    }

    @Override
    public void flush() {
        this.cachingSupport.flush();
    }

    @Override
    public int getEntityCacheMaxSize() {
        return this.cachingSupport.getMaxCacheSize();
    }

    @Override
    public boolean isCacheInUse() {
        return this.cachingSupport.isCacheInUse();
    }

    @Override
    public void setCacheInUse(boolean cacheInUse) {
        this.cachingSupport.setCacheInUse(cacheInUse);
    }

    @Override
    public void setEntityCacheMaxSize(int maxSize) {
        this.cachingSupport.setMaxCacheSize(maxSize);
    }

    @Override
    public boolean containsEntity(Object entityId, Filter filter) {
        return this.cachingSupport.containsEntity(entityId, filter);
    }

    @Override
    public List<Object> getAllEntityIdentifiers(Filter filter, List<SortBy> sortBy) {
        return this.cachingSupport.getAllEntityIdentifiers(filter, sortBy);
    }

    @Override
    public synchronized T getEntity(Object entityId) {
        return this.cachingSupport.getEntity(entityId);
    }

    @Override
    public boolean isEntitiesDetached() {
        return this.isCacheInUse() || super.isEntitiesDetached();
    }

    @Override
    public boolean isCloneCachedEntities() {
        return this.cachingSupport.isCloneCachedEntities();
    }

    @Override
    public void setCloneCachedEntities(boolean clone) throws UnsupportedOperationException {
        this.cachingSupport.setCloneCachedEntities(clone);
    }

    @Override
    public int getEntityCount(Filter filter) {
        return this.cachingSupport.getEntityCount(filter);
    }

    @Override
    public Object getEntityIdentifierAt(Filter filter, List<SortBy> sortBy, int index) {
        return this.cachingSupport.getEntityIdentifierAt(filter, sortBy, index);
    }

    @Override
    public Object getFirstEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        return this.cachingSupport.getFirstEntityIdentifier(filter, sortBy);
    }

    @Override
    public Object getLastEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        return this.cachingSupport.getLastEntityIdentifier(filter, sortBy);
    }

    @Override
    public Object getNextEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        return this.cachingSupport.getNextEntityIdentifier(entityId, filter, sortBy);
    }

    @Override
    public Object getPreviousEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        return this.cachingSupport.getPreviousEntityIdentifier(entityId, filter, sortBy);
    }
}

