/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.provider;

import com.vaadin.addon.jpacontainer.EntityProvider;
import com.vaadin.addon.jpacontainer.Filter;
import com.vaadin.addon.jpacontainer.SortBy;
import com.vaadin.addon.jpacontainer.filter.CompositeFilter;
import com.vaadin.addon.jpacontainer.filter.Filters;
import com.vaadin.addon.jpacontainer.filter.IntervalFilter;
import com.vaadin.addon.jpacontainer.filter.JoinFilter;
import com.vaadin.addon.jpacontainer.filter.Junction;
import com.vaadin.addon.jpacontainer.filter.ValueFilter;
import com.vaadin.addon.jpacontainer.metadata.EntityClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.MetadataFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalEntityProvider<T>
implements EntityProvider<T>,
Serializable {
    private static final long serialVersionUID = 1601796410565144708L;
    private transient EntityManager entityManager;
    private EntityClassMetadata<T> entityClassMetadata;
    private boolean entitiesDetached = true;
    private Serializable serializableEntityManager;

    public LocalEntityProvider(Class<T> entityClass, EntityManager entityManager) {
        this(entityClass);
        assert (entityManager != null) : "entityManager must not be null";
        this.entityManager = entityManager;
    }

    public LocalEntityProvider(Class<T> entityClass) {
        assert (entityClass != null) : "entityClass must not be null";
        this.entityClassMetadata = MetadataFactory.getInstance().getEntityClassMetadata(entityClass);
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.entityManager != null && this.entityManager instanceof Serializable) {
            this.serializableEntityManager = (Serializable)this.entityManager;
        }
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.serializableEntityManager != null) {
            this.entityManager = (EntityManager)this.serializableEntityManager;
        }
        return this;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected EntityClassMetadata<T> getEntityClassMetadata() {
        return this.entityClassMetadata;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected EntityManager doGetEntityManager() throws IllegalStateException {
        if (this.getEntityManager() == null) {
            throw new IllegalStateException("No entity manager specified");
        }
        return this.getEntityManager();
    }

    protected List<SortBy> addPrimaryKeyToSortList(List<SortBy> original) {
        ArrayList<SortBy> newList = new ArrayList<SortBy>();
        newList.addAll(original);
        if (this.getEntityClassMetadata().hasEmbeddedIdentifier()) {
            for (String p : this.getEntityClassMetadata().getIdentifierProperty().getTypeMetadata().getPersistentPropertyNames()) {
                newList.add(new SortBy(this.getEntityClassMetadata().getIdentifierProperty().getName() + "." + p, true));
            }
        } else {
            newList.add(new SortBy(this.getEntityClassMetadata().getIdentifierProperty().getName(), true));
        }
        return Collections.unmodifiableList(newList);
    }

    protected Query createUnsortedFilteredQuery(String fieldsToSelect, String entityAlias, Filter filter, Filter.PropertyIdPreprocessor propertyIdPreprocessor) {
        return this.createFilteredQuery(fieldsToSelect, entityAlias, filter, null, false, propertyIdPreprocessor);
    }

    private void addJoins(Filter filter, StringBuffer sb, String entityAlias) {
        if (filter instanceof JoinFilter) {
            sb.append(" ");
            JoinFilter jf = (JoinFilter)filter;
            sb.append("join");
            sb.append(" ");
            sb.append(entityAlias);
            sb.append(".");
            sb.append(jf.getJoinProperty());
            sb.append(" as ");
            sb.append(jf.getJoinProperty());
        } else if (filter instanceof CompositeFilter) {
            for (Filter f : ((CompositeFilter)filter).getFilters()) {
                this.addJoins(f, sb, entityAlias);
            }
        }
    }

    protected Query createFilteredQuery(String fieldsToSelect, final String entityAlias, Filter filter, List<SortBy> sortBy, boolean swapSortOrder, Filter.PropertyIdPreprocessor propertyIdPreprocessor) {
        assert (fieldsToSelect != null) : "fieldsToSelect must not be null";
        assert (entityAlias != null) : "entityAlias must not be null";
        assert (sortBy == null || !sortBy.isEmpty()) : "sortBy must be either null or non-empty";
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        sb.append(fieldsToSelect);
        sb.append(" from ");
        sb.append(this.getEntityClassMetadata().getEntityName());
        sb.append(" as ");
        sb.append(entityAlias);
        if (filter != null) {
            this.addJoins(filter, sb, entityAlias);
        }
        if (filter != null) {
            sb.append(" where ");
            if (propertyIdPreprocessor == null) {
                sb.append(filter.toQLString(new Filter.PropertyIdPreprocessor(){

                    public String process(Object propertyId) {
                        return entityAlias + "." + propertyId;
                    }
                }));
            } else {
                sb.append(filter.toQLString(propertyIdPreprocessor));
            }
        }
        if (sortBy != null && sortBy.size() > 0) {
            sb.append(" order by ");
            Iterator<SortBy> it = sortBy.iterator();
            while (it.hasNext()) {
                SortBy sortedProperty = it.next();
                sb.append(entityAlias);
                sb.append(".");
                sb.append(sortedProperty.getPropertyId());
                if (sortedProperty.isAscending() != swapSortOrder) {
                    sb.append(" asc");
                } else {
                    sb.append(" desc");
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        String queryString = sb.toString();
        Query query = this.doGetEntityManager().createQuery(queryString);
        if (filter != null) {
            this.setQueryParameters(query, filter);
        }
        return query;
    }

    private void setQueryParameters(Query query, Filter filter) {
        if (filter instanceof ValueFilter) {
            ValueFilter vf = (ValueFilter)filter;
            query.setParameter(vf.getQLParameterName(), vf.getValue());
        } else if (filter instanceof IntervalFilter) {
            IntervalFilter intf = (IntervalFilter)filter;
            query.setParameter(intf.getEndingPointQLParameterName(), intf.getEndingPoint());
            query.setParameter(intf.getStartingPointQLParameterName(), intf.getStartingPoint());
        } else if (filter instanceof CompositeFilter) {
            for (Filter f : ((CompositeFilter)filter).getFilters()) {
                this.setQueryParameters(query, f);
            }
        }
    }

    protected boolean doContainsEntity(Object entityId, Filter filter) {
        assert (entityId != null) : "entityId must not be null";
        ValueFilter entityIdFilter = Filters.eq(this.getEntityClassMetadata().getIdentifierProperty().getName(), entityId);
        Filter f = filter == null ? entityIdFilter : Filters.and(entityIdFilter, filter);
        Query query = this.getEntityClassMetadata().hasEmbeddedIdentifier() ? this.createUnsortedFilteredQuery(String.format("count(obj.%s.%s)", this.getEntityClassMetadata().getIdentifierProperty().getName(), this.getEntityClassMetadata().getIdentifierProperty().getTypeMetadata().getPersistentPropertyNames().iterator().next()), "obj", f, null) : this.createUnsortedFilteredQuery("count(obj)", "obj", f, null);
        Object result = query.getSingleResult();
        if (result instanceof Integer) {
            return (Integer)result == 1;
        }
        return (Long)result == 1L;
    }

    @Override
    public boolean containsEntity(Object entityId, Filter filter) {
        return this.doContainsEntity(entityId, filter);
    }

    protected T doGetEntity(Object entityId) {
        assert (entityId != null) : "entityId must not be null";
        Object entity = this.doGetEntityManager().find(this.getEntityClassMetadata().getMappedClass(), entityId);
        return (T)this.detachEntity(entity);
    }

    @Override
    public T getEntity(Object entityId) {
        return this.doGetEntity(entityId);
    }

    protected Object doGetEntityIdentifierAt(Filter filter, List<SortBy> sortBy, int index) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        Query query = this.createFilteredQuery("obj." + this.getEntityClassMetadata().getIdentifierProperty().getName(), "obj", filter, this.addPrimaryKeyToSortList(sortBy), false, null);
        query.setMaxResults(1);
        query.setFirstResult(index);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public Object getEntityIdentifierAt(Filter filter, List<SortBy> sortBy, int index) {
        return this.doGetEntityIdentifierAt(filter, sortBy, index);
    }

    protected int doGetEntityCount(Filter filter) {
        Query query = this.getEntityClassMetadata().hasEmbeddedIdentifier() ? this.createUnsortedFilteredQuery(String.format("count(obj.%s.%s)", this.getEntityClassMetadata().getIdentifierProperty().getName(), this.getEntityClassMetadata().getIdentifierProperty().getTypeMetadata().getPersistentPropertyNames().iterator().next()), "obj", filter, null) : this.createUnsortedFilteredQuery("count(obj)", "obj", filter, null);
        Object ret = query.getSingleResult();
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        return ((Long)ret).intValue();
    }

    @Override
    public int getEntityCount(Filter filter) {
        return this.doGetEntityCount(filter);
    }

    protected Object doGetFirstEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        Query query = this.createFilteredQuery("obj." + this.getEntityClassMetadata().getIdentifierProperty().getName(), "obj", filter, this.addPrimaryKeyToSortList(sortBy), false, null);
        query.setMaxResults(1);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public Object getFirstEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        return this.doGetFirstEntityIdentifier(filter, sortBy);
    }

    protected Object doGetLastEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        Query query = this.createFilteredQuery("obj." + this.getEntityClassMetadata().getIdentifierProperty().getName(), "obj", filter, this.addPrimaryKeyToSortList(sortBy), true, null);
        query.setMaxResults(1);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public Object getLastEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        return this.doGetLastEntityIdentifier(filter, sortBy);
    }

    protected Object getSibling(Object entityId, Filter filter, List<SortBy> sortBy, boolean backwards) {
        Query query = this.createSiblingQuery(entityId, filter, sortBy, backwards);
        query.setMaxResults(1);
        List result = query.getResultList();
        if (result.size() != 1) {
            return null;
        }
        return result.get(0);
    }

    protected Query createSiblingQuery(Object entityId, Filter filter, List<SortBy> sortBy, boolean backwards) {
        Filter limitingFilter;
        assert (entityId != null) : "entityId must not be null";
        assert (sortBy != null) : "sortBy must not be null";
        if ((sortBy = this.addPrimaryKeyToSortList(sortBy)).size() == 1) {
            limitingFilter = backwards ? Filters.lt(this.getEntityClassMetadata().getIdentifierProperty().getName(), entityId) : Filters.gt(this.getEntityClassMetadata().getIdentifierProperty().getName(), entityId);
        } else {
            T currentEntity = this.getEntity(entityId);
            if (currentEntity == null) {
                throw new EntityNotFoundException("No entity found with the ID " + entityId);
            }
            HashMap<Object, Object> filterValues = new HashMap<Object, Object>();
            for (SortBy sb : sortBy) {
                filterValues.put(sb.getPropertyId(), this.getEntityClassMetadata().getPropertyValue(currentEntity, sb.getPropertyId().toString()));
            }
            limitingFilter = Filters.or(new Filter[0]);
            for (int i = sortBy.size() - 1; i >= 0; --i) {
                SortBy sb;
                Junction caseFilter = Filters.and(new Filter[0]);
                for (int j = 0; j < i; ++j) {
                    sb = sortBy.get(j);
                    caseFilter.add(Filters.eq(sb.getPropertyId(), filterValues.get(sb.getPropertyId())));
                }
                sb = sortBy.get(i);
                if (sb.isAscending() ^ backwards) {
                    caseFilter.add(Filters.gt(sb.getPropertyId(), filterValues.get(sb.getPropertyId())));
                } else {
                    caseFilter.add(Filters.lt(sb.getPropertyId(), filterValues.get(sb.getPropertyId())));
                }
                ((Junction)limitingFilter).add(caseFilter);
            }
        }
        Filter queryFilter = filter == null ? limitingFilter : Filters.and(filter, limitingFilter);
        Query query = this.createFilteredQuery("obj." + this.getEntityClassMetadata().getIdentifierProperty().getName(), "obj", queryFilter, sortBy, backwards, null);
        return query;
    }

    protected Object doGetNextEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        return this.getSibling(entityId, filter, sortBy, false);
    }

    @Override
    public Object getNextEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        return this.doGetNextEntityIdentifier(entityId, filter, sortBy);
    }

    protected Object doGetPreviousEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        return this.getSibling(entityId, filter, sortBy, true);
    }

    @Override
    public Object getPreviousEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        return this.doGetPreviousEntityIdentifier(entityId, filter, sortBy);
    }

    protected T detachEntity(T entity) {
        if (entity == null) {
            return null;
        }
        if (!this.isEntitiesDetached()) {
            return entity;
        }
        if (entity instanceof Serializable) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(os);
                oos.writeObject(entity);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(is);
                return this.getEntityClassMetadata().getMappedClass().cast(ois.readObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("WARNING: Clearing EntityManager in order to detach the entities in it");
        this.doGetEntityManager().clear();
        return entity;
    }

    @Override
    public boolean isEntitiesDetached() {
        return this.entitiesDetached;
    }

    @Override
    public void setEntitiesDetached(boolean detached) throws UnsupportedOperationException {
        this.entitiesDetached = detached;
    }

    protected List<Object> doGetAllEntityIdentifiers(Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        sortBy = this.addPrimaryKeyToSortList(sortBy);
        Query query = this.createFilteredQuery("obj." + this.getEntityClassMetadata().getIdentifierProperty().getName(), "obj", filter, sortBy, false, null);
        return Collections.unmodifiableList(query.getResultList());
    }

    @Override
    public List<Object> getAllEntityIdentifiers(Filter filter, List<SortBy> sortBy) {
        return this.doGetAllEntityIdentifiers(filter, sortBy);
    }
}

