/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.LicenseEventHandler;
import com.vaadin.flow.server.VaadinService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public class CollaborationEngineConfiguration {
    static final boolean DEFAULT_AUTOMATICALLY_ACTIVATE_PUSH = true;
    private LicenseEventHandler licenseEventHandler;
    private VaadinService vaadinService;
    private String configuredDataDir;
    private boolean automaticallyActivatePush = true;

    public CollaborationEngineConfiguration(LicenseEventHandler licenseEventHandler) {
        this.licenseEventHandler = Objects.requireNonNull(licenseEventHandler, "The license event handler cannot be null");
    }

    public LicenseEventHandler getLicenseEventHandler() {
        return this.licenseEventHandler;
    }

    public String getDataDir() {
        return this.configuredDataDir;
    }

    public void setDataDir(String dataDir) {
        this.configuredDataDir = dataDir;
    }

    public void setAutomaticallyActivatePush(boolean automaticallyActivatePush) {
        this.automaticallyActivatePush = automaticallyActivatePush;
    }

    public boolean isAutomaticallyActivatePush() {
        return this.automaticallyActivatePush;
    }

    void setVaadinService(VaadinService vaadinService) {
        this.vaadinService = vaadinService;
    }

    boolean isLicenseCheckingEnabled() {
        return this.vaadinService.getDeploymentConfiguration().isProductionMode();
    }

    Path getDataDirPath() {
        String dataDirectory = this.vaadinService.getDeploymentConfiguration().getStringProperty("ce.dataDir", null);
        if (dataDirectory == null) {
            dataDirectory = this.configuredDataDir;
        }
        return dataDirectory != null ? Paths.get(dataDirectory, new String[0]) : null;
    }
}

