/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationAvatarGroup;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.CollaborationMessage;
import com.vaadin.collaborationengine.CollaborationMessagePersister;
import com.vaadin.collaborationengine.CollaborationMessageSubmitter;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.messages.MessageList;
import com.vaadin.flow.component.messages.MessageListItem;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CollaborationMessageList
extends Composite<MessageList>
implements HasSize,
HasStyle {
    private static final Object FETCH_LOCK = new Object();
    private static final String MISSING_RECENT_MESSAGES = "The messages returned invoking CollaborationMessagePersister.fetchMessages() do not include the last fetched message of the previous call. Please update the implementation to fetch all messages whose timestamp is greater OR EQUAL with the query's timestamp.";
    static final String LIST_NAME = CollaborationMessageList.class.getName();
    private final CollaborationEngine ce;
    private Registration topicRegistration;
    private CollaborationList list;
    private CollaborationMessagePersister persister;
    private CollaborationAvatarGroup.ImageProvider imageProvider;
    private String topicId;
    private final UserInfo localUser;
    private CollaborationMessageSubmitter submitter;
    private Registration submitterRegistration;
    private MessageConfigurator messageConfigurator;

    public CollaborationMessageList(UserInfo localUser, String topicId) {
        this(localUser, topicId, null, CollaborationEngine.getInstance());
    }

    public CollaborationMessageList(UserInfo localUser, String topicId, CollaborationMessagePersister persister) {
        this(localUser, topicId, persister, CollaborationEngine.getInstance());
    }

    CollaborationMessageList(UserInfo localUser, String topicId, CollaborationMessagePersister persister, CollaborationEngine ce) {
        this.localUser = Objects.requireNonNull(localUser, "User cannot be null");
        this.ce = ce;
        this.persister = persister;
        this.setTopic(topicId);
    }

    public void setTopic(String topicId) {
        this.topicId = topicId;
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
            this.topicRegistration = null;
        }
        if (topicId != null) {
            this.topicRegistration = this.ce.openTopicConnection(this.getContent(), topicId, this.localUser, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
        }
    }

    public void setSubmitter(CollaborationMessageSubmitter submitter) {
        this.submitter = submitter;
        if (this.submitterRegistration != null) {
            this.submitterRegistration.remove();
        }
        if (submitter != null && this.list != null) {
            this.submitterRegistration = submitter.onActivation(this::appendMessage);
            Objects.requireNonNull(this.submitterRegistration, "The submitter should return a non-null registration object");
        }
    }

    void appendMessage(String text) {
        CollaborationMessage message = new CollaborationMessage(this.localUser, text, this.ce.getClock().instant());
        if (this.persister != null) {
            CollaborationMessagePersister.PersistRequest request = new CollaborationMessagePersister.PersistRequest(this, this.topicId, message);
            this.persister.persistMessage(request);
            this.fetchPersistedList();
        } else {
            this.list.append(message);
        }
    }

    public void setImageProvider(CollaborationAvatarGroup.ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
        this.refreshMessages();
    }

    public CollaborationAvatarGroup.ImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setMessageConfigurator(MessageConfigurator messageConfigurator) {
        this.messageConfigurator = messageConfigurator;
        this.refreshMessages();
    }

    public MessageConfigurator getMessageConfigurator() {
        return this.messageConfigurator;
    }

    private Registration onConnectionActivate(TopicConnection topicConnection) {
        this.list = topicConnection.getNamedList(LIST_NAME);
        this.list.subscribe(event -> this.refreshMessages());
        this.fetchPersistedList();
        if (this.submitter != null && this.submitterRegistration == null) {
            this.submitterRegistration = this.submitter.onActivation(this::appendMessage);
            Objects.requireNonNull(this.submitterRegistration, "The submitter should return a non-null registration object");
        }
        return this::onConnectionDeactivate;
    }

    private void onConnectionDeactivate() {
        this.list = null;
        this.refreshMessages();
        if (this.submitterRegistration != null) {
            this.submitterRegistration.remove();
            this.submitterRegistration = null;
        }
    }

    private void refreshMessages() {
        List messageListItems = this.getMessages().stream().map(this::convertToMessageListItem).collect(Collectors.toList());
        ((MessageList)this.getContent()).setItems(messageListItems);
    }

    private MessageListItem convertToMessageListItem(CollaborationMessage message) {
        MessageListItem messageListItem = new MessageListItem(message.getText(), message.getTime(), message.getUser().getName());
        if (this.imageProvider == null) {
            messageListItem.setUserImage(message.getUser().getImage());
        } else {
            messageListItem.setUserImageResource(this.imageProvider.getImageResource(message.getUser()));
        }
        messageListItem.setUserAbbreviation(message.getUser().getAbbreviation());
        messageListItem.setUserColorIndex(Integer.valueOf(this.ce.getUserColorIndex(message.getUser())));
        if (this.messageConfigurator != null) {
            this.messageConfigurator.configureMessage(messageListItem, message.getUser());
        }
        return messageListItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchPersistedList() {
        if (this.persister != null && this.topicId != null) {
            Object object = FETCH_LOCK;
            synchronized (object) {
                List<CollaborationMessage> recentMessages = this.getRecentMessages();
                Instant since = recentMessages.isEmpty() ? Instant.EPOCH : recentMessages.get(0).getTime();
                CollaborationMessagePersister.FetchQuery query = new CollaborationMessagePersister.FetchQuery(this, this.topicId, since);
                List<CollaborationMessage> messages = this.persister.fetchMessages(query).sorted(Comparator.comparing(CollaborationMessage::getTime)).filter(message -> !recentMessages.remove(message)).collect(Collectors.toList());
                if (!recentMessages.isEmpty()) {
                    throw new IllegalStateException(MISSING_RECENT_MESSAGES);
                }
                if (!messages.isEmpty()) {
                    query.throwIfPropsNotUsed();
                    messages.forEach(this.list::append);
                }
            }
        }
    }

    private List<CollaborationMessage> getRecentMessages() {
        CollaborationMessage lastMessage;
        List<CollaborationMessage> currentMessages = this.getMessages();
        ArrayList<CollaborationMessage> recentMessages = new ArrayList<CollaborationMessage>();
        CollaborationMessage collaborationMessage = lastMessage = currentMessages.isEmpty() ? null : currentMessages.get(currentMessages.size() - 1);
        if (lastMessage != null) {
            CollaborationMessage m;
            Instant lastMessageTime = lastMessage.getTime();
            for (int i = currentMessages.size() - 1; i >= 0 && (m = currentMessages.get(i)).getTime().equals(lastMessageTime); --i) {
                recentMessages.add(m);
            }
        }
        return recentMessages;
    }

    private List<CollaborationMessage> getMessages() {
        return this.list != null ? this.list.getItems(CollaborationMessage.class) : Collections.emptyList();
    }

    static {
        UsageStatistics.markAsUsed((String)"vaadin-collaboration-engine/CollaborationMessageList", (String)"3.2");
    }

    @FunctionalInterface
    public static interface MessageConfigurator {
        public void configureMessage(MessageListItem var1, UserInfo var2);
    }
}

