/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.ComponentConnectionContext;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.MapChangeEvent;
import com.vaadin.collaborationengine.NewUserHandler;
import com.vaadin.collaborationengine.TopicConnection;
import com.vaadin.collaborationengine.TopicConnectionRegistration;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PresenceManager {
    static final String MAP_NAME = PresenceManager.class.getName();
    static final String MAP_KEY = "users";
    private final Map<String, Registration> handlerRegistrations = new ConcurrentHashMap<String, Registration>();
    private final UserInfo localUser;
    private final String topicId;
    private CollaborationMap map;
    private NewUserHandler newUserHandler;
    private boolean markAsPresent = false;
    private TopicConnectionRegistration topicRegistration;

    public PresenceManager(Component component, UserInfo localUser, String topicId) {
        this(new ComponentConnectionContext(component), localUser, topicId, CollaborationEngine.getInstance());
    }

    PresenceManager(ConnectionContext connectionContext, UserInfo localUser, String topicId, CollaborationEngine collaborationEngine) {
        this.localUser = Objects.requireNonNull(localUser);
        this.topicId = Objects.requireNonNull(topicId);
        this.topicRegistration = collaborationEngine.openTopicConnection(connectionContext, topicId, localUser, (SerializableFunction<TopicConnection, Registration>)((SerializableFunction & Serializable)this::onConnectionActivate));
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void close() {
        if (this.topicRegistration != null) {
            this.topicRegistration.remove();
            this.topicRegistration = null;
        }
    }

    public void markAsPresent(boolean markAsPresent) {
        if (this.markAsPresent != markAsPresent && this.map != null) {
            if (markAsPresent) {
                this.addLocalUserToTopic();
            } else {
                this.removeLocalUserFromTopic();
            }
        }
        this.markAsPresent = markAsPresent;
    }

    private void addLocalUserToTopic() {
        this.updateUsers(this.map, (SerializableFunction<Stream<UserInfo>, Stream<UserInfo>>)(SerializableFunction & Serializable)oldValue -> Stream.concat(oldValue, Stream.of(this.localUser)));
    }

    private void removeLocalUserFromTopic() {
        this.updateUsers(this.map, (SerializableFunction<Stream<UserInfo>, Stream<UserInfo>>)(SerializableFunction & Serializable)oldValue -> {
            List users = oldValue.collect(Collectors.toList());
            users.remove(this.localUser);
            return users.stream();
        });
    }

    public void setNewUserHandler(NewUserHandler handler) {
        this.removeAllRegistrations();
        this.newUserHandler = handler;
        if (handler != null) {
            this.getUsers().forEach(this::applyHandler);
        }
    }

    private Stream<UserInfo> getUsers() {
        if (this.map != null) {
            List<UserInfo> list = this.map.get(MAP_KEY, JsonUtil.LIST_USER_TYPE_REF);
            return list != null ? list.stream().distinct() : Stream.empty();
        }
        return Stream.empty();
    }

    private Registration onConnectionActivate(TopicConnection topicConnection) {
        this.map = topicConnection.getNamedMap(MAP_NAME);
        this.map.subscribe(this::onMapChange);
        if (this.markAsPresent) {
            this.addLocalUserToTopic();
        }
        return this::onConnectionDeactivate;
    }

    private void onConnectionDeactivate() {
        if (this.markAsPresent) {
            this.removeLocalUserFromTopic();
        }
        this.map = null;
        this.removeAllRegistrations();
    }

    private void onMapChange(MapChangeEvent event) {
        if (event.getKey().equals(MAP_KEY)) {
            List<UserInfo> oldUsersList = event.getOldValue(JsonUtil.LIST_USER_TYPE_REF);
            List<UserInfo> newUsersList = event.getValue(JsonUtil.LIST_USER_TYPE_REF);
            if (oldUsersList != null) {
                this.diff(oldUsersList, newUsersList).map(UserInfo::getId).forEach(this::removeRegistration);
            }
            if (newUsersList != null && this.newUserHandler != null) {
                this.diff(newUsersList, oldUsersList).forEach(this::applyHandler);
            }
        }
    }

    private Stream<UserInfo> diff(List<UserInfo> x, List<UserInfo> y) {
        LinkedHashSet<UserInfo> set = new LinkedHashSet<UserInfo>(x);
        if (y != null) {
            set.removeAll(y);
        }
        return set.stream();
    }

    private void applyHandler(UserInfo user) {
        if (this.newUserHandler != null) {
            this.handlerRegistrations.put(user.getId(), this.newUserHandler.handleNewUser(user));
        }
    }

    private void removeRegistration(String key) {
        Registration registration = this.handlerRegistrations.remove(key);
        if (registration != null) {
            registration.remove();
        }
    }

    private void removeAllRegistrations() {
        ArrayList<String> keys = new ArrayList<String>(this.handlerRegistrations.keySet());
        keys.forEach(this::removeRegistration);
    }

    private void updateUsers(CollaborationMap map, SerializableFunction<Stream<UserInfo>, Stream<UserInfo>> updater) {
        List<UserInfo> oldUsers = map.get(MAP_KEY, JsonUtil.LIST_USER_TYPE_REF);
        Stream<Object> oldUsersStream = oldUsers == null ? Stream.empty() : oldUsers.stream();
        List newUsers = ((Stream)updater.apply(oldUsersStream)).collect(Collectors.toList());
        map.replace(MAP_KEY, oldUsers, newUsers).thenAccept(success -> {
            if (!success.booleanValue()) {
                this.updateUsers(map, updater);
            }
        });
    }
}

